/*
 * Decompiled with CFR 0.152.
 */
package sedona.manifest;

import sedona.Facets;
import sedona.Type;
import sedona.manifest.KitManifest;
import sedona.manifest.SlotManifest;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

public class TypeManifest {
    public final KitManifest kit;
    public final int id;
    public final String name;
    public final String qname;
    public final Facets facets;
    public final String base;
    public final int flags;
    public final int sizeof;
    public SlotManifest[] slots;

    public boolean isPrimitive() {
        boolean bl = false;
        if (this.kit.name.equals("sys") && Type.isPrimitive(this.id)) {
            bl = true;
        }
        return bl;
    }

    public void encodeXml(XWriter xWriter) {
        xWriter.w("<!-- " + this.qname + " -->\n");
        xWriter.w("<type ").attr("id", "" + this.id).w(" ").attr("name", this.name).w(" ").attr("sizeof", this.sizeof);
        String string = TypeManifest.flagsToString(this.flags);
        if (string.length() > 0) {
            xWriter.w(" ").attr("flags", string);
        }
        if (this.base != null) {
            xWriter.w(" ").attr("base", this.base);
        }
        xWriter.w(">\n");
        if (!this.facets.isEmpty()) {
            this.facets.encodeXml(xWriter, 2);
        }
        int n = 0;
        while (n < this.slots.length) {
            this.slots[n].encodeXml(xWriter);
            ++n;
        }
        xWriter.w("</type>\n");
    }

    public static TypeManifest decodeXml(KitManifest kitManifest, XElem xElem) {
        int n = xElem.geti("id");
        String string = xElem.get("name");
        String string2 = xElem.get("base", null);
        Facets facets = Facets.decodeXml(xElem.elem("facets"));
        int n2 = xElem.geti("sizeof", -1);
        int n3 = TypeManifest.stringToFlags(xElem.get("flags", ""));
        TypeManifest typeManifest = new TypeManifest(kitManifest, n, string, facets, string2, n2, n3);
        XElem[] xElemArray = xElem.elems("slot");
        typeManifest.slots = new SlotManifest[xElemArray.length];
        int n4 = 0;
        while (n4 < xElemArray.length) {
            SlotManifest slotManifest = SlotManifest.decodeXml(typeManifest, xElemArray[n4]);
            if (slotManifest.declaredId != n4) {
                throw new XException("Misaligned declared slot ids", xElemArray[n4]);
            }
            typeManifest.slots[n4] = slotManifest;
            ++n4;
        }
        return typeManifest;
    }

    public static String flagsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('a');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('i');
        }
        return stringBuffer.toString();
    }

    public static int stringToFlags(String string) {
        int n = 0;
        boolean bl = true;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (c) {
                case 'a': {
                    n |= 1;
                    break;
                }
                case 'i': {
                    n |= 8;
                    bl = false;
                    break;
                }
            }
            ++n2;
        }
        if (bl) {
            n |= 0x10;
        }
        return n;
    }

    public TypeManifest(KitManifest kitManifest, int n, String string, Facets facets, String string2, int n2, int n3) {
        this.kit = kitManifest;
        this.id = n;
        this.name = string;
        this.qname = kitManifest.name + "::" + string;
        this.facets = facets == null ? Facets.empty : facets.ro();
        this.base = string2;
        this.sizeof = n2;
        this.flags = n3;
    }
}

