/*
 * Decompiled with CFR 0.152.
 */
package sedonacert.prov;

import java.io.File;
import java.util.Properties;
import sedona.Depend;
import sedona.Kit;
import sedona.Schema;
import sedona.platform.PlatformManifest;
import sedona.sox.KitVersion;
import sedona.sox.SoxFile;
import sedona.util.TextUtil;
import sedona.util.Version;
import sedona.xml.XContent;
import sedona.xml.XElem;
import sedonac.Compiler;
import sedonacert.Test;
import sedonacert.prov.Prov;

public abstract class ProvTest
extends Test {
    protected final Prov prov() {
        return (Prov)this.bundle;
    }

    protected void provision(File file, File file2) throws Exception {
        this.putFile(file, "app.sab.writing");
        this.putFile(file2, "kits.scode.writing");
        this.runner.sox.renameFile("app.sab.writing", "app.sab.stage");
        this.runner.sox.renameFile("kits.scode.writing", "kits.scode.stage");
        if (!this.runner.restart()) {
            this.fail("could not restart device");
        }
    }

    protected Properties getApp(File file) throws Exception {
        return this.runner.sox.getFile("app.sab", SoxFile.make((File)file), null, null);
    }

    protected Properties getScode(File file) throws Exception {
        return this.runner.sox.getFile("kits.scode", SoxFile.make((File)file), null, null);
    }

    protected Properties putFile(File file, String string) throws Exception {
        return this.runner.sox.putFile(string, SoxFile.make((File)file), null, null);
    }

    protected void compile(File file) {
        Compiler compiler = new Compiler();
        compiler.compile(file);
    }

    protected void makeScode(Schema schema, File file, boolean bl) throws Exception {
        PlatformManifest platformManifest = this.runner.platform;
        XElem xElem = new XElem("sedonaCode").addAttr("name", "addKit-cert").addAttr("endian", platformManifest.endian).addAttr("armDouble", Boolean.toString(platformManifest.armDouble)).addAttr("blockSize", Integer.toString(platformManifest.blockSize)).addAttr("refSize", Integer.toString(platformManifest.refSize)).addAttr("main", "sys::Sys.main").addAttr("debug", Boolean.toString(platformManifest.debug)).addAttr("test", Boolean.toString(platformManifest.test));
        KitVersion[] kitVersionArray = this.runner.version.kits;
        Kit[] kitArray = schema.kits;
        int n = 0;
        while (n < kitArray.length) {
            String string = kitArray[n].name;
            String string2 = "0x" + TextUtil.intToHexString((int)kitArray[n].checksum);
            Version version = kitArray[n].manifest.version;
            int n2 = 0;
            while (n2 < kitVersionArray.length) {
                if (kitVersionArray[n2].name.equals(string)) {
                    version = kitVersionArray[n2].version;
                    if (kitVersionArray[n2].checksum == kitArray[n].checksum) break;
                    throw new IllegalStateException("checksum mismatch for " + string + ": " + kitVersionArray[n2].checksum + " <> " + kitArray[n].checksum);
                }
                ++n2;
            }
            Depend depend = Depend.parse((String)(string + ' ' + version + "=, " + string2));
            xElem.addContent((XContent)new XElem("depend").addAttr("on", depend.toString()));
            ++n;
        }
        xElem.write(file);
        if (bl) {
            this.compile(file);
        }
    }

    public ProvTest(String string) {
        super(string);
    }
}

