/*
 * Decompiled with CFR 0.152.
 */
package sedonacert.sox;

import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Int;
import sedona.Schema;
import sedona.Type;
import sedona.Value;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedonacert.Test;
import sedonacert.sox.Sox;

public class SoxAdd
extends Test {
    public void run() throws Exception {
        SoxClient soxClient = this.runner.sox;
        Schema schema = soxClient.readSchema();
        Type type = schema.type("sox::SoxCert");
        if (type == null) {
            this.fail("sox::SoxCert type not installed");
        }
        SoxComponent soxComponent = soxClient.loadApp();
        this.verifyEq(soxComponent.id(), 0);
        int[] nArray = soxComponent.childrenIds();
        SoxComponent soxComponent2 = soxClient.add(soxComponent, type, "soxcert", new Value[]{Int.make((int)15), Bool.make((boolean)false), Byte.make((int)204)});
        ((Sox)this.bundle).soxCertId = soxComponent2.id();
        soxComponent = soxClient.update(soxComponent, 1);
        int[] nArray2 = soxComponent.childrenIds();
        this.verifyEq(nArray.length, nArray2.length - 1);
        this.verifyEq(nArray2[nArray2.length - 1], soxComponent2.id());
        soxClient.update(soxComponent2, 15);
        this.verifyEq(soxComponent2.parentId(), 0);
        this.verifyEq(soxComponent2.childrenIds().length, 0);
        this.verifyEq(soxComponent2.getBool("z"), false);
        this.verifyEq(soxComponent2.getInt("b"), 204);
        this.verifyEq(soxComponent2.getInt("s"), 52719);
        this.verifyEq(soxComponent2.getInt("i"), -889275714);
        this.verifyEq(soxComponent2.getLong("l"), -3819410105021120785L);
        this.verifyEq(soxComponent2.getFloat("f"), 2.04f);
        this.verifyEq(soxComponent2.getDouble("d"), 256.0);
        this.verifyEq(((Buf)soxComponent2.get("buf")).toString(), "0x[]");
    }

    public SoxAdd() {
        super("add");
    }
}

