/*
 * Decompiled with CFR 0.152.
 */
package sedonacert.sox;

import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Short;
import sedona.Value;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedonacert.Test;
import sedonacert.sox.Sox;

public class SoxReadWrite
extends Test {
    public void run() throws Exception {
        SoxClient soxClient = this.runner.sox;
        SoxComponent soxComponent = ((Sox)this.bundle).soxCertComp();
        soxClient.write(soxComponent, soxComponent.slot("z"), (Value)Bool.make((boolean)false));
        soxClient.write(soxComponent, soxComponent.slot("b"), (Value)Byte.make((int)200));
        soxClient.write(soxComponent, soxComponent.slot("s"), (Value)Short.make((int)64000));
        soxClient.write(soxComponent, soxComponent.slot("i"), (Value)Int.make((int)-123456789));
        soxClient.write(soxComponent, soxComponent.slot("l"), (Value)Long.make((long)-135557L));
        soxClient.write(soxComponent, soxComponent.slot("f"), (Value)Float.make((float)-567.0f));
        soxClient.write(soxComponent, soxComponent.slot("d"), (Value)Double.make((double)-1972.0));
        soxClient.write(soxComponent, soxComponent.slot("buf"), (Value)new Buf(new byte[]{1, 2, 3, 4}));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("z")), Bool.make((boolean)false));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("b")), Byte.make((int)200));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("s")), Short.make((int)64000));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("i")), Int.make((int)-123456789));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("l")), Long.make((long)-135557L));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("f")), Float.make((float)-567.0f));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("d")), Double.make((double)-1972.0));
        this.verifyEq(soxClient.readProp(soxComponent, soxComponent.slot("buf")).toString(), "0x[01020304]");
        soxClient.update(soxComponent, 15);
        this.verifyEq(soxComponent.parentId(), 0);
        this.verifyEq(soxComponent.childrenIds().length, 0);
        this.verifyEq(soxComponent.getBool("z"), false);
        this.verifyEq(soxComponent.getInt("b"), 200);
        this.verifyEq(soxComponent.getInt("s"), 64000);
        this.verifyEq(soxComponent.getInt("i"), -123456789);
        this.verifyEq(soxComponent.getLong("l"), -135557L);
        this.verifyEq(soxComponent.getFloat("f"), -567.0f);
        this.verifyEq(soxComponent.getDouble("d"), -1972.0);
        this.verifyEq(((Buf)soxComponent.get("buf")).toString(), "0x[01020304]");
    }

    public SoxReadWrite() {
        super("read-write");
    }
}

