/*
 * Decompiled with CFR 0.152.
 */
package sedona.manifest;

import sedona.Facets;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.manifest.TypeManifest;
import sedona.xml.XElem;
import sedona.xml.XWriter;

public class SlotManifest {
    public final TypeManifest parent;
    public final int declaredId;
    public final String name;
    public final String qname;
    public final String type;
    public final Facets facets;
    public final int flags;
    public final Value def;

    public void encodeXml(XWriter xWriter) {
        xWriter.w("  <slot ").attr("id", "" + this.declaredId).w(" ").attr("name", this.name).w(" ").attr("type", this.type);
        String string = SlotManifest.flagsToString(this.flags);
        if (string.length() > 0) {
            xWriter.w(" ").attr("flags", string);
        }
        if (this.def != null) {
            xWriter.w(" ").attr("default", this.def.encodeString());
        }
        if (this.facets.isEmpty()) {
            xWriter.w("/>\n");
        } else {
            xWriter.w(">\n");
            this.facets.encodeXml(xWriter, 4);
            xWriter.w("  </slot>\n");
        }
    }

    public static SlotManifest decodeXml(TypeManifest typeManifest, XElem xElem) {
        Object object;
        int n = xElem.geti("id");
        String string = xElem.get("name");
        String string2 = xElem.get("type");
        int n2 = SlotManifest.stringToFlags(xElem.get("flags", ""));
        Value value = null;
        if ((n2 & 4) != 0) {
            value = Str.make(xElem.get("default", ""));
        } else if ((n2 & 1) == 0) {
            value = Value.defaultForType(Type.predefinedId(string2));
            object = xElem.get("default", null);
            if (object != null) {
                value = value.decodeString((String)object);
            }
        }
        object = Facets.decodeXml(xElem.elem("facets"));
        return new SlotManifest(typeManifest, n, string, (Facets)object, string2, n2, value);
    }

    public static String flagsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('a');
        }
        if ((n & 2) != 0) {
            stringBuffer.append('c');
        }
        if ((n & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('o');
        }
        return stringBuffer.toString();
    }

    public static int stringToFlags(String string) {
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c = string.charAt(n2);
            switch (string.charAt(n2)) {
                case 'a': {
                    n |= 1;
                    break;
                }
                case 'c': {
                    n |= 2;
                    break;
                }
                case 's': {
                    n |= 4;
                    break;
                }
                case 'o': {
                    n |= 8;
                    break;
                }
                default: {
                    System.out.println("WARNING: unknown flag: " + (char)c);
                }
            }
            ++n2;
        }
        return n;
    }

    public SlotManifest(TypeManifest typeManifest, int n, String string, Facets facets, String string2, int n2, Value value) {
        this.parent = typeManifest;
        this.declaredId = n;
        this.name = string;
        this.qname = typeManifest.qname + '.' + string;
        this.facets = facets == null ? Facets.empty : facets.ro();
        this.type = string2;
        this.flags = n2;
        this.def = value;
    }
}

