/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaProvisioning.tooltasks;

import com.tridium.nsedona.sox.BISoxPlatform;
import com.tridium.nsedona.sox.PlatformSession;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ProvTask;
import javax.baja.file.FilePath;
import javax.baja.file.FileUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.util.Lexicon;
import sedona.Buf;
import sedona.Schema;
import sedona.offline.OfflineApp;
import sedona.sox.SoxFile;

public class GetApp
implements ProvTask {
    private final FilePath destPath;
    private final boolean saveChecksums;
    private final boolean isSax;
    private Buf appSab;

    public String getSummary() {
        Lexicon lexicon = Lexicon.make((String)"sedonaProvisioning");
        return lexicon.getText("getapp.summary");
    }

    public void execute(ProvCx provCx) throws Exception {
        PlatformSession.FileTransfer fileTransfer;
        Object object;
        provCx.log(this.getSummary());
        provCx.setAppFileOrd(BOrd.make((OrdQuery)this.destPath));
        if (this.appSab == null) {
            this.appSab = new Buf();
            object = SoxFile.make((Buf)this.appSab);
            fileTransfer = provCx.fileTransfer();
            fileTransfer.getFile("app.sab", object);
        }
        this.appSab.seek(0);
        if (this.isSax) {
            object = this.saveChecksums ? "[with kit checksums]" : "[without kit checksums]";
            provCx.log("  Converting to sax file " + (String)object);
            fileTransfer = GetApp.decodeApp(this.appSab, provCx);
            this.appSab.clear();
            fileTransfer.encodeAppXml(this.appSab.getOutputStream(), this.saveChecksums ^ true);
        }
        object = provCx.getProvStore().getFileSpace();
        fileTransfer = object.makeFile(this.destPath);
        provCx.log("  Saving app in " + fileTransfer.getAbsoluteOrd());
        fileTransfer.write(this.appSab.trim());
        BISoxPlatform bISoxPlatform = provCx.session().getPlatform();
        if (provCx.getAppFileOrd() != null) {
            bISoxPlatform.appUpdated(provCx.getAppFileOrd());
        }
        provCx.log("");
    }

    private static final OfflineApp decode(Buf buf) throws Exception {
        return OfflineApp.decodeAppBinary((Buf)buf);
    }

    public static OfflineApp decodeApp(Buf buf, ProvCx provCx) throws Exception {
        try {
            return GetApp.decode(buf);
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            provCx.resolveMissingManifests(missingKitManifestException.parts);
            buf.seek(0);
            return GetApp.decode(buf);
        }
    }

    public GetApp(FilePath filePath, boolean bl) {
        this(filePath, bl, null);
    }

    public GetApp(FilePath filePath, boolean bl, Buf buf) {
        this.destPath = filePath;
        this.saveChecksums = bl;
        this.appSab = buf;
        this.isSax = "sax".equals(FileUtil.getExtension((String)filePath.getName()));
    }
}

