/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonaProvisioning.tooltasks;

import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.env.ManifestDb;
import com.tridium.sedonaProvisioning.ProvCx;
import com.tridium.sedonaProvisioning.ProvTask;
import java.io.File;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import sedona.Buf;
import sedona.KitPart;
import sedona.manifest.KitManifest;
import sedona.platform.PlatformManifest;
import sedona.sox.SoxFile;
import sedona.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TransferFiles
implements ProvTask {
    private Array files;
    private KitDb.KitSummary[] manifests;
    static /* synthetic */ Class class$com$tridium$sedonaProvisioning$tooltasks$TransferFiles$Record;
    static /* synthetic */ Class class$com$tridium$sedonaProvisioning$tooltasks$TransferFiles;

    public String getSummary() {
        Class clazz = class$com$tridium$sedonaProvisioning$tooltasks$TransferFiles;
        if (clazz == null) {
            clazz = class$com$tridium$sedonaProvisioning$tooltasks$TransferFiles = TransferFiles.class("[Lcom.tridium.sedonaProvisioning.tooltasks.TransferFiles;", false);
        }
        Lexicon lexicon = Lexicon.make((Class)clazz);
        return lexicon.getText("commit.summary");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute(ProvCx var1_1) throws Exception {
        var1_1.log(this.getSummary());
        this.files = this.files.sort(new Comparator(){

            public final int compare(Object object, Object object2) {
                Record record = (Record)object;
                Record record2 = (Record)object2;
                if (record.isAppOrScode()) {
                    return 1 - record2.isAppOrScode();
                }
                return -1;
            }
        });
        try {
            var1_1.log("  Writing " + this.files.size() + " files:");
            var6_2 = 0;
            while (true) {
                if (var6_2 >= this.files.size()) break;
                var7_3 = (Record)this.files.get(var6_2);
                var8_4 = var7_3.destUri;
                if (var7_3.isAppOrScode()) {
                    var8_4 = var8_4 + ".writing";
                }
                var1_1.log("    " + (var6_2 + 1) + ": Put " + var8_4);
                var1_1.fileTransfer().putFile(SoxFile.make((File)var7_3.src), var8_4);
                ++var6_2;
            }
            var1_1.log("  Renaming *.writing files to *.stage on device");
            var6_2 = 0;
            while (true) {
                block13: {
                    if (var6_2 < this.files.size()) break block13;
                    this.tryManifestTransfer(var1_1);
                    ** GOTO lbl-1000
                }
                var7_3 = (Record)this.files.get(var6_2);
                if (var7_3.isAppOrScode()) {
                    var8_4 = var7_3.destUri + ".writing";
                    var9_5 = var7_3.destUri + ".stage";
                    var1_1.log("     Rename " + var8_4 + " -> " + var9_5);
                    var1_1.fileTransfer().renameFile(var8_4, var9_5);
                }
                ++var6_2;
            }
        }
        catch (Throwable var2_6) {
            var3_7 = null;
            var4_9 = 0;
        }
        while (true) {
            if (var4_9 >= this.files.size()) {
                throw var2_6;
            }
            var5_11 = (Record)this.files.get(var4_9);
            if (!var5_11.src.delete()) {
                var5_11.src.deleteOnExit();
            }
            ++var4_9;
        }
lbl-1000:
        // 1 sources

        {
            var3_8 = null;
            var4_10 = 0;
        }
        while (true) {
            if (var4_10 >= this.files.size()) {
                var1_1.log("");
                return;
            }
            var5_12 = (Record)this.files.get(var4_10);
            if (!var5_12.src.delete()) {
                var5_12.src.deleteOnExit();
            }
            ++var4_10;
        }
    }

    private final void tryManifestTransfer(ProvCx provCx) throws Exception {
        if (this.manifests == null) {
            return;
        }
        PlatformManifest platformManifest = provCx.session().getPlatformManifest();
        if (platformManifest == null || !platformManifest.implementsScheme("m")) {
            provCx.log("\nPlatform does not support manifest transfer");
            return;
        }
        if (ManifestDb.isSingleZipTransfer((PlatformManifest)platformManifest)) {
            this.transferSingleZip(provCx);
        } else {
            this.transferMultiZip(provCx);
        }
    }

    private final void transferSingleZip(ProvCx provCx) throws Exception {
        provCx.log("\nTransferring manifests as single zip");
        ManifestDb manifestDb = provCx.env().manifestDb();
        Buf buf = new Buf();
        ZipOutputStream zipOutputStream = new ZipOutputStream(buf.getOutputStream());
        int n = 0;
        while (n < this.manifests.length) {
            this.putKitManifest(zipOutputStream, manifestDb, this.manifests[n]);
            ++n;
        }
        zipOutputStream.close();
        buf.seek(0);
        provCx.fileTransfer().putFile(SoxFile.make((Buf)buf), "m:m.zip");
        provCx.log("Wrote m:m.zip");
    }

    private final void transferMultiZip(ProvCx provCx) throws Exception {
        provCx.log("\nTransferring manifests as multiple zips");
        ManifestDb manifestDb = provCx.env().manifestDb();
        int n = 0;
        while (n < this.manifests.length) {
            Buf buf = new Buf();
            ZipOutputStream zipOutputStream = new ZipOutputStream(buf.getOutputStream());
            String string = this.putKitManifest(zipOutputStream, manifestDb, this.manifests[n]);
            zipOutputStream.close();
            buf.seek(0);
            provCx.fileTransfer().putFile(SoxFile.make((Buf)buf), "m:" + string);
            provCx.log("Wrote " + string);
            ++n;
        }
    }

    private final String putKitManifest(ZipOutputStream zipOutputStream, ManifestDb manifestDb, KitDb.KitSummary kitSummary) throws Exception {
        KitPart kitPart = kitSummary.getKitPart();
        KitManifest kitManifest = manifestDb.extractManifest(kitPart);
        String string = kitPart + ".xml";
        zipOutputStream.putNextEntry(new ZipEntry(string));
        XWriter xWriter = new XWriter((OutputStream)zipOutputStream);
        kitManifest.encodeXml(xWriter);
        xWriter.flush();
        zipOutputStream.closeEntry();
        return string;
    }

    public void register(File file, String string) {
        this.files.add((Object)new Record(file, string));
    }

    public void registerManifests(KitDb.KitSummary[] kitSummaryArray) {
        this.manifests = kitSummaryArray;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        Class clazz = class$com$tridium$sedonaProvisioning$tooltasks$TransferFiles$Record;
        if (clazz == null) {
            clazz = class$com$tridium$sedonaProvisioning$tooltasks$TransferFiles$Record = TransferFiles.class("[Lcom.tridium.sedonaProvisioning.tooltasks.TransferFiles$Record;", false);
        }
        this.files = new Array(clazz);
    }

    public TransferFiles() {
        this.this();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Record {
        public final File src;
        public final String destUri;

        public boolean isApp() {
            return "app.sab".equals(this.destUri);
        }

        public boolean isScode() {
            return "kits.scode".equals(this.destUri);
        }

        public boolean isAppOrScode() {
            boolean bl = false;
            if (this.isApp() || this.isScode()) {
                bl = true;
            }
            return bl;
        }

        public Record(File file, String string) {
            this.src = file;
            this.destUri = string;
        }
    }
}

