/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jen6lp;

import com.tridium.jen6lp.util.Mac154Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.ByteArrayUtil;
import javax.baja.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BMac154DeviceAddress
extends BSimple {
    public static final BMac154DeviceAddress DEFAULT = new BMac154DeviceAddress(0, -1, -1);
    public static final Type TYPE;
    private int extUpper;
    private int extLower;
    private int shortAddr;
    private int hashCode;
    static /* synthetic */ Class class$com$tridium$jen6lp$BMac154DeviceAddress;

    public static final BMac154DeviceAddress make(int n) {
        return new BMac154DeviceAddress(n, -1, -1);
    }

    public static final BMac154DeviceAddress make(int n, int n2) {
        return new BMac154DeviceAddress(-1, n, n2);
    }

    public static final BMac154DeviceAddress make(Mac154Address mac154Address) {
        return new BMac154DeviceAddress(mac154Address.getShortAddr(), mac154Address.getExtAddrUpper(), mac154Address.getExtAddrLower());
    }

    public static final BMac154DeviceAddress make(byte[] byArray, byte[] byArray2) {
        if (byArray.length != 4 || byArray2.length != 4) {
            throw new IllegalArgumentException();
        }
        int n = ByteArrayUtil.readInt((byte[])byArray, (int)0);
        int n2 = ByteArrayUtil.readInt((byte[])byArray2, (int)0);
        return new BMac154DeviceAddress(-1, n, n2);
    }

    public static final BMac154DeviceAddress make(byte[] byArray) {
        if (byArray.length != 8) {
            throw new IllegalArgumentException();
        }
        int n = ByteArrayUtil.readInt((byte[])byArray, (int)0);
        int n2 = ByteArrayUtil.readInt((byte[])byArray, (int)4);
        return new BMac154DeviceAddress(-1, n, n2);
    }

    public final int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception exception) {
            return System.identityHashCode((Object)this);
        }
    }

    public final boolean equals(Object object) {
        if (!(object instanceof BMac154DeviceAddress)) {
            return false;
        }
        BMac154DeviceAddress bMac154DeviceAddress = (BMac154DeviceAddress)((Object)object);
        if (bMac154DeviceAddress.shortAddr != this.shortAddr) {
            return false;
        }
        if (bMac154DeviceAddress.extUpper != this.extUpper) {
            return false;
        }
        return bMac154DeviceAddress.extLower == this.extLower;
    }

    public final String toString(Context context) {
        if (this.shortAddr != -1) {
            return String.valueOf(this.shortAddr);
        }
        return TextUtil.intToHexString((int)this.extUpper) + ':' + TextUtil.intToHexString((int)this.extLower);
    }

    public final String toOrdString() {
        if (this.shortAddr != -1) {
            return "MAC" + String.valueOf(this.shortAddr);
        }
        return "MAC" + TextUtil.intToHexString((int)this.extUpper) + '_' + TextUtil.intToHexString((int)this.extLower);
    }

    public final void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.shortAddr);
        dataOutput.writeInt(this.extUpper);
        dataOutput.writeInt(this.extLower);
    }

    public final BObject decode(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        int n3 = dataInput.readInt();
        return new BMac154DeviceAddress(n, n2, n3);
    }

    public final String encodeToString() {
        if (this.shortAddr != -1) {
            return String.valueOf(this.shortAddr);
        }
        return Integer.toHexString(this.extUpper) + ':' + Integer.toHexString(this.extLower);
    }

    public final BObject decodeFromString(String string) {
        int n;
        int n2;
        int n3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        String string2 = stringTokenizer.nextToken();
        String string3 = null;
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 != null) {
            n3 = -1;
            n2 = (int)Long.parseLong(string2, 16);
            n = (int)Long.parseLong(string3, 16);
        } else {
            n = -1;
            n2 = -1;
            n3 = Integer.parseInt(string2);
        }
        return new BMac154DeviceAddress(n3, n2, n);
    }

    public final boolean isShortAddr() {
        boolean bl = false;
        if (this.shortAddr != -1) {
            bl = true;
        }
        return bl;
    }

    public final int getShortAddr() {
        return this.shortAddr;
    }

    public final int getExtAddrUpper() {
        return this.extUpper;
    }

    public final int getExtAddrLower() {
        return this.extLower;
    }

    public final String getIpv6Address() {
        if (this.isShortAddr()) {
            throw new IllegalStateException("Cannot use on short address form");
        }
        String string = TextUtil.intToHexString((int)(this.extLower & (char)-1), (int)4);
        String string2 = TextUtil.intToHexString((int)(this.extLower >> 16 & (char)-1), (int)4);
        return "fe80:0000:0000:0000:0215:8d00:" + string2 + ':' + string;
    }

    public final Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hashCode = -1;
    }

    private BMac154DeviceAddress(int n, int n2, int n3) {
        this.this();
        this.extUpper = n2;
        this.extLower = n3;
        this.shortAddr = n;
    }

    static {
        Class clazz = class$com$tridium$jen6lp$BMac154DeviceAddress;
        if (clazz == null) {
            clazz = class$com$tridium$jen6lp$BMac154DeviceAddress = BMac154DeviceAddress.class("[Lcom.tridium.jen6lp.BMac154DeviceAddress;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

