/*
 * Decompiled with CFR 0.152.
 */
package sedonac.ast;

import java.util.ArrayList;
import sedonac.Location;
import sedonac.ast.AstNode;
import sedonac.ast.AstVisitor;
import sedonac.ast.AstWriter;
import sedonac.ast.LocalScope;
import sedonac.ast.Stmt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Block
extends AstNode
implements LocalScope {
    public ArrayList stmts;

    public boolean isEmpty() {
        boolean bl = false;
        if (this.stmts.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public Stmt[] stmts() {
        return this.stmts.toArray(new Stmt[this.stmts.size()]);
    }

    public Stmt.LocalDef[] getLocals() {
        ArrayList<Stmt> arrayList = new ArrayList<Stmt>();
        int n = 0;
        while (n < this.stmts.size()) {
            Stmt stmt = (Stmt)this.stmts.get(n);
            if (stmt instanceof Stmt.LocalDef) {
                arrayList.add(stmt);
            }
            ++n;
        }
        return arrayList.toArray(new Stmt.LocalDef[arrayList.size()]);
    }

    public Stmt.LocalDef resolveLocal(String string) {
        int n = 0;
        while (n < this.stmts.size()) {
            Stmt stmt = (Stmt)this.stmts.get(n);
            Stmt.LocalDef localDef = Stmt.LocalDef.isLocal(stmt, string);
            if (localDef != null) {
                return localDef;
            }
            ++n;
        }
        return null;
    }

    public int maxStack() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.stmts.size()) {
            Stmt stmt = (Stmt)this.stmts.get(n2);
            n = Math.max(n, stmt.maxStack());
            ++n2;
        }
        return n;
    }

    public boolean isExit() {
        if (this.stmts.size() == 0) {
            return false;
        }
        return ((Stmt)this.stmts.get(this.stmts.size() - 1)).isExit();
    }

    public void add(Stmt stmt) {
        this.stmts.add(stmt);
    }

    public void add(int n, Stmt stmt) {
        this.stmts.add(n, stmt);
    }

    public void walk(AstVisitor astVisitor) {
        astVisitor.enterBlock(this);
        int n = 0;
        while (n < this.stmts.size()) {
            ((Stmt)this.stmts.get(n)).walk(astVisitor);
            ++n;
        }
        astVisitor.exitBlock(this);
    }

    public void write(AstWriter astWriter) {
        this.write(astWriter, true);
    }

    public void write(AstWriter astWriter, boolean bl) {
        if (bl) {
            astWriter.indent().w("{").nl();
        }
        ++astWriter.indent;
        Stmt[] stmtArray = this.stmts();
        int n = 0;
        while (n < stmtArray.length) {
            Stmt stmt = stmtArray[n];
            if (stmt.label != null) {
                astWriter.indent().w(stmt.label).w(": ").nl();
            }
            stmt.write(astWriter);
            ++n;
        }
        --astWriter.indent;
        if (bl) {
            astWriter.indent().w("}").nl();
        }
    }

    private final /* synthetic */ void this() {
        this.stmts = new ArrayList();
    }

    public Block(Location location) {
        super(location);
        this.this();
    }
}

