/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.util.HashMap;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.ast.KitDef;
import sedonac.ast.MethodDef;
import sedonac.ast.NativeDef;
import sedonac.ast.SlotDef;
import sedonac.namespace.NativeId;

public class ResolveNatives
extends CompilerStep {
    public void run() {
        Object object;
        MethodDef[] methodDefArray;
        KitDef kitDef = this.compiler.ast;
        String string = kitDef.name + "::";
        NativeDef[] nativeDefArray = kitDef.natives;
        if (nativeDefArray == null) {
            nativeDefArray = new NativeDef[]{};
        }
        this.log.debug("  ResolveNatives [" + nativeDefArray.length + ']');
        HashMap<NativeId, NativeId> hashMap = new HashMap<NativeId, NativeId>();
        boolean[] blArray = new boolean[nativeDefArray.length];
        int n = 0;
        while (n < nativeDefArray.length) {
            methodDefArray = nativeDefArray[n];
            String string2 = methodDefArray.qname;
            object = methodDefArray.id;
            if (hashMap.get(object) != null) {
                this.err("Duplicate native id '" + object + '\'', methodDefArray.loc);
                blArray[n] = true;
            } else {
                hashMap.put((NativeId)object, (NativeId)object);
                if (!string2.startsWith(string)) {
                    this.err("Invalid kit for native method '" + string2 + '\'', methodDefArray.loc);
                    blArray[n] = true;
                } else {
                    MethodDef methodDef = (MethodDef)this.ns.resolveMethod(string2);
                    if (methodDef != null) {
                        if (!methodDef.isNative()) {
                            this.err("Method is not native '" + string2 + '\'', methodDefArray.loc);
                            blArray[n] = true;
                        } else if (methodDef.nativeId != null) {
                            this.err("Native method '" + string2 + "' assigned multiple ids", methodDefArray.loc);
                            blArray[n] = true;
                        } else {
                            methodDef.nativeId = object;
                            blArray[n] = true;
                        }
                    }
                }
            }
            ++n;
        }
        n = 0;
        while (n < nativeDefArray.length) {
            if (!blArray[n]) {
                this.err("Native method not found '" + nativeDefArray[n].qname + '\'', nativeDefArray[n].loc);
            }
            ++n;
        }
        n = 0;
        while (n < kitDef.types.length) {
            methodDefArray = kitDef.types[n].methodDefs();
            int n2 = 0;
            while (n2 < methodDefArray.length) {
                object = methodDefArray[n2];
                if (((SlotDef)object).isNative() && ((MethodDef)object).nativeId == null) {
                    this.err("Native method not assigned id '" + ((MethodDef)object).qname + '\'', ((MethodDef)object).loc);
                }
                ++n2;
            }
            ++n;
        }
    }

    public ResolveNatives(Compiler compiler) {
        super(compiler);
    }
}

