/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import sedona.util.TextUtil;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;

public class WriteImage
extends CompilerStep {
    public void run() {
        String string = this.compiler.input.getName();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        string = string + ".scode";
        File file = this.compiler.outDir;
        if (file == null) {
            file = this.compiler.input.getParentFile();
        }
        File file2 = new File(file, string);
        byte[] byArray = this.compiler.image.code;
        this.log.info("  WriteImage [" + file2 + "] (" + byArray.length + " bytes)");
        try {
            file.mkdirs();
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            ((OutputStream)bufferedOutputStream).write(byArray);
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Cannot write image file", new Location(file2));
        }
        int n2 = this.compiler.dataSize;
        int n3 = this.compiler.image.code.length;
        this.log.info("  +----------------------------------");
        this.log.info("  |  Data:   " + TextUtil.kb((int)n2));
        this.log.info("  |  Code:   " + TextUtil.kb((int)n3));
        this.log.info("  |  Total:  " + TextUtil.kb((int)(n2 + n3)));
        this.log.info("  +----------------------------------");
    }

    public WriteImage(Compiler compiler) {
        super(compiler);
    }
}

