/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.dasp;

import com.tridium.nsedona.dasp.BTraceSettings;
import com.tridium.nsedona.dasp.DaspTunnel;
import com.tridium.nsedona.dasp.TunnelSession;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.agent.AgentList;
import javax.baja.sedona.dasp.BRouteHandler;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class BDaspTunnel
extends BAbstractService {
    public static final Property port = BDaspTunnel.newProperty((int)0, (int)1876, null);
    public static final Property authenticateWithUserService = BDaspTunnel.newProperty((int)0, (boolean)true, null);
    public static final Property traceSettings = BDaspTunnel.newProperty((int)5, (BValue)BTraceSettings.DEFAULT, null);
    public static final Action fwAction = BDaspTunnel.newAction((int)4, (BValue)new BVector(), null);
    public static final Type TYPE;
    private static Type[] serviceTypes;
    private static final BIcon icon;
    private DaspTunnel tunnel;
    private final HashMap routerCache;
    static /* synthetic */ Class class$com$tridium$nsedona$dasp$BDaspTunnel;
    static /* synthetic */ Class class$javax$baja$sedona$dasp$BRouteHandler;

    public final int getPort() {
        return this.getInt(port);
    }

    public final void setPort(int n) {
        this.setInt(port, n, null);
    }

    public final boolean getAuthenticateWithUserService() {
        return this.getBoolean(authenticateWithUserService);
    }

    public final void setAuthenticateWithUserService(boolean bl) {
        this.setBoolean(authenticateWithUserService, bl, null);
    }

    public final BTraceSettings getTraceSettings() {
        return (BTraceSettings)this.get(traceSettings);
    }

    public final void setTraceSettings(BTraceSettings bTraceSettings) {
        this.set(traceSettings, (BValue)bTraceSettings, null);
    }

    public final BValue fwAction(BVector bVector) {
        return this.invoke(fwAction, (BValue)bVector, null);
    }

    public final Type getType() {
        return TYPE;
    }

    public final synchronized BRouteHandler getRouteHandler(String string) {
        if (!this.routerCache.containsKey(string)) {
            Class clazz = class$javax$baja$sedona$dasp$BRouteHandler;
            if (clazz == null) {
                clazz = class$javax$baja$sedona$dasp$BRouteHandler = BDaspTunnel.class("[Ljavax.baja.sedona.dasp.BRouteHandler;", false);
            }
            BRouteHandler[] bRouteHandlerArray = (BRouteHandler[])this.getChildren(clazz);
            BRouteHandler bRouteHandler = null;
            int n = 0;
            while (n < bRouteHandlerArray.length) {
                if (bRouteHandlerArray[n].canRoute(string)) {
                    bRouteHandler = bRouteHandlerArray[n];
                    bRouteHandler.fw(9900, this.tunnel, null, null, null);
                    break;
                }
                ++n;
            }
            this.routerCache.put(string, bRouteHandler);
        }
        return (BRouteHandler)((Object)this.routerCache.get(string));
    }

    private final synchronized void removeFromRouterCache(BRouteHandler bRouteHandler) {
        Object[] objectArray = this.routerCache.keySet().toArray();
        int n = 0;
        while (n < objectArray.length) {
            if (this.routerCache.get(objectArray[n]) == bRouteHandler) {
                this.routerCache.remove(objectArray[n]);
            }
            ++n;
        }
    }

    public final Type[] getServiceTypes() {
        return serviceTypes;
    }

    public final void serviceStarted() {
        this.serviceStopped();
        if (this.isDisabled()) {
            return;
        }
        this.tunnel = new DaspTunnel(this);
        this.tunnel.setTrace(this.getTraceSettings());
        this.tunnel.start(this.getPort());
    }

    public final void serviceStopped() {
        if (this.tunnel != null) {
            this.tunnel.stop();
            this.tunnel = null;
        }
        this.routerCache.clear();
        this.configOk();
    }

    protected final void enabled() {
        this.serviceStarted();
    }

    protected final void disabled() {
        this.serviceStopped();
    }

    public final void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property == port) {
            this.serviceStarted();
        } else if (property == traceSettings) {
            this.tunnel.setTrace(this.getTraceSettings());
        }
    }

    public final void started() throws Exception {
        super.started();
    }

    public final void checkAdd(String string, BValue bValue, int n, BFacets bFacets, Context context) {
        super.checkAdd(string, bValue, n, bFacets, context);
        if (!this.isRunning()) {
            return;
        }
        if (bValue.getType().is(BRouteHandler.TYPE) && this.isOperational()) {
            throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "tunnel.addErr");
        }
    }

    public final void checkRemove(Property property, Context context) {
        super.checkRemove(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BRouteHandler.TYPE) && this.isOperational()) {
            throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "tunnel.remErr");
        }
    }

    public final void added(Property property, Context context) {
        super.added(property, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BRouteHandler.TYPE)) {
            this.removeFromRouterCache(null);
        }
    }

    public final void removed(Property property, BValue bValue, Context context) {
        super.removed(property, bValue, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BRouteHandler.TYPE)) {
            this.removeFromRouterCache((BRouteHandler)bValue);
        }
    }

    public final AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("workbench:PropertySheet");
        return agentList;
    }

    public final BValue doFwAction(BVector bVector) {
        String string = bVector.get("op").toString();
        BVector bVector2 = new BVector();
        if (string.equals("listSessions")) {
            TunnelSession[] tunnelSessionArray = this.tunnel.listSessions();
            Arrays.sort(tunnelSessionArray, new SessionComparator());
            int n = 0;
            while (n < tunnelSessionArray.length) {
                BVector bVector3 = new BVector();
                bVector3.add("id", (BValue)BInteger.make((int)tunnelSessionArray[n].tunnelId));
                bVector3.add("c", (BValue)BString.make((String)tunnelSessionArray[n].clientAddr.getAddress().toString()));
                bVector3.add("s", (BValue)BString.make((String)tunnelSessionArray[n].route.address));
                bVector2.add("s" + n, (BValue)bVector3);
                ++n;
            }
        }
        return bVector2;
    }

    public final void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        if (!this.isRunning()) {
            return;
        }
        TunnelSession[] tunnelSessionArray = this.tunnel.listSessions();
        if (tunnelSessionArray.length == 0) {
            return;
        }
        Arrays.sort(tunnelSessionArray, new SessionComparator());
        spyWriter.startTable(true);
        spyWriter.trTitle((Object)"Tunnel Sessions", 6);
        spyWriter.w((Object)"<tr>").th((Object)"Type").th((Object)"Tunnel Session Id").th((Object)"Client").th((Object)"Route to").th((Object)"Uptime").th((Object)"Idletime").w((Object)"</tr>\n");
        int n = 0;
        while (n < tunnelSessionArray.length) {
            TunnelSession tunnelSession = tunnelSessionArray[n];
            spyWriter.tr((Object)tunnelSession.route.type, (Object)Integer.toHexString(tunnelSession.tunnelId), (Object)tunnelSession.clientAddr, (Object)tunnelSession.route.address, (Object)this.duration(tunnelSession.uptime()), (Object)this.duration(tunnelSession.idletime()));
            ++n;
        }
        spyWriter.endTable();
    }

    private final String duration(long l) {
        if (l < 1000L) {
            return l + "ms";
        }
        if (l < 60000L) {
            return l / 1000L + "sec " + this.duration(l % 1000L);
        }
        if (l < 3600000L) {
            return l / 60000L + "min " + this.duration(l % 60000L);
        }
        if (l < 86400000L) {
            return l / 3600000L + "hr " + this.duration(l % 3600000L);
        }
        return l / 86400000L + "day" + this.duration(l % 86400000L);
    }

    public final BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.routerCache = new HashMap(3);
    }

    public BDaspTunnel() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$nsedona$dasp$BDaspTunnel;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$dasp$BDaspTunnel = BDaspTunnel.class("[Lcom.tridium.nsedona.dasp.BDaspTunnel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        serviceTypes = new Type[]{TYPE};
        icon = BIcon.make((String)"module://nsedona/rc/daspTunnel.png");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SessionComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            TunnelSession tunnelSession = (TunnelSession)object;
            TunnelSession tunnelSession2 = (TunnelSession)object2;
            int n = tunnelSession.route.type.compareTo(tunnelSession2.route.type);
            if (n != 0) {
                return n;
            }
            n = tunnelSession.clientAddr.getAddress().toString().compareTo(tunnelSession2.clientAddr.getAddress().toString());
            if (n != 0) {
                return n;
            }
            return tunnelSession.tunnelId - tunnelSession2.tunnelId;
        }

        SessionComparator() {
        }
    }
}

