/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.kitmgr;

import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.env.SedonaEnv;
import com.tridium.nsedona.kitmgr.ManagerVerifier;
import com.tridium.nsedona.util.NSedonaUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Stack;
import javax.baja.util.Array;
import javax.baja.util.IFilter;
import sedona.Component;
import sedona.Depend;
import sedona.Kit;
import sedona.KitPart;
import sedona.Schema;
import sedona.offline.OfflineApp;
import sedona.platform.PlatformDbException;
import sedona.platform.PlatformManifest;
import sedona.sox.KitVersion;
import sedona.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class KitManagerModel {
    protected final OfflineApp app;
    protected final SedonaEnv env;
    protected final KitDb kitDb;
    protected final HashMap nativeDepends;
    protected final HashMap appChecksums;
    protected final HashSet appRequired;
    protected final LinkedHashMap kits;
    private boolean checkNativeDependencies;
    private KitVersion[] currentKits;
    private String[] sortedKits;
    static /* synthetic */ Class class$sedona$Depend;
    static /* synthetic */ Class class$com$tridium$nsedona$env$KitDb$KitSummary;

    protected PlatformManifest platformManifest() throws Exception {
        return null;
    }

    protected KitVersion[] getCurrentKits() throws Exception {
        if (this.currentKits == null) {
            this.currentKits = new KitVersion[this.app.schema.kits.length];
            int n = 0;
            while (n < this.currentKits.length) {
                Kit kit = this.app.schema.kits[n];
                KitDb.KitSummary[] kitSummaryArray = this.kitDb.list(kit.name);
                Version version = new Version("0");
                int n2 = 0;
                while (n2 < kitSummaryArray.length) {
                    KitDb.KitSummary kitSummary = kitSummaryArray[n2];
                    if (kitSummary.checksum() == kit.checksum && kitSummary.version().compareTo((Object)version) > 0) {
                        version = kitSummaryArray[n2].version();
                    }
                    ++n2;
                }
                this.currentKits[n] = new KitVersion(kit.name, kit.checksum, version);
                ++n;
            }
        }
        return this.currentKits;
    }

    public void load() throws Exception {
        this.analyzePlatformManifest();
        this.analyzeApp();
        this.analyzeKitDb();
    }

    public void reset() {
        Iterator iterator = this.kits.keySet().iterator();
        while (iterator.hasNext()) {
            KitSet kitSet = this.kitset(iterator.next().toString());
            kitSet.desired = kitSet.origDesired;
        }
    }

    private final void analyzePlatformManifest() throws Exception {
        this.nativeDepends.clear();
        this.checkNativeDependencies = true;
        PlatformManifest platformManifest = this.platformManifest();
        if (platformManifest == null) {
            this.checkNativeDependencies = false;
            return;
        }
        this.log("Analyzing platform manifest " + platformManifest.id);
        if (platformManifest == null) {
            throw new PlatformDbException("Could not load platform manifest for " + platformManifest.id);
        }
        int n = 0;
        while (n < platformManifest.nativeKits.length) {
            this.nativeDepends.put(platformManifest.nativeKits[n].name(), platformManifest.nativeKits[n]);
            ++n;
        }
    }

    private final void analyzeApp() {
        Kit[] kitArray;
        this.log("Analyzing app");
        this.appRequired.clear();
        this.appChecksums.clear();
        Stack<Object> stack = new Stack<Object>();
        stack.push(this.app);
        while (!stack.isEmpty()) {
            kitArray = (Kit[])stack.pop();
            Kit kit = kitArray.type.kit;
            this.appRequired.add(kit.name);
            Component[] componentArray = kitArray.getChildren();
            int n = 0;
            while (n < componentArray.length) {
                stack.push(componentArray[n]);
                ++n;
            }
        }
        kitArray = this.app.schema.kits;
        int n = 0;
        while (n < kitArray.length) {
            if (this.appRequired.contains(kitArray[n].name)) {
                int n2 = 0;
                while (n2 < kitArray[n].manifest.depends.length) {
                    this.appRequired.add(kitArray[n].manifest.depends[n2].name());
                    ++n2;
                }
            }
            ++n;
        }
        this.appChecksums.clear();
        n = 0;
        while (n < kitArray.length) {
            this.appChecksums.put(kitArray[n].name, kitArray[n].manifest.part());
            ++n;
        }
    }

    private final void analyzeKitDb() throws Exception {
        KitRec[] kitRecArray;
        KitDb.KitSummary[] kitSummaryArray;
        this.log("Analyzing kit database");
        this.kits.clear();
        this.sortedKits = null;
        String[] stringArray = this.kitDb.kits();
        int n = 0;
        while (n < stringArray.length) {
            this.log("Analyzing " + stringArray[n], (double)(n + 1) / (double)stringArray.length * 100.0);
            HashMap<Version, KitRec> hashMap = new HashMap<Version, KitRec>();
            kitSummaryArray = this.kitDb.list(stringArray[n]);
            int n2 = 0;
            while (n2 < kitSummaryArray.length) {
                KitRec kitRec;
                KitDb.KitSummary kitSummary = kitSummaryArray[n2];
                KitRec kitRec2 = new KitRec(kitSummary, this.kitDb);
                if (this.checkNativeDependencies && kitRec2.hasNatives()) {
                    kitRec = (Depend)this.nativeDepends.get(kitRec2.kitName());
                    if (kitRec == null) {
                        kitRec2.markUnsupported("Platform does not implement natives for this kit");
                    } else if (!kitRec.match(kitSummary.version(), kitSummary.checksum())) {
                        kitRec2.markUnsupported("Does not meet nativeKit dependency: " + kitRec);
                    }
                }
                if ((kitRec = (KitRec)hashMap.get(kitSummary.version())) == null || kitRec.kitSummary.buildTime() < kitSummary.buildTime()) {
                    hashMap.put(kitSummary.version(), kitRec2);
                }
                ++n2;
            }
            kitRecArray = hashMap.values().toArray(new KitRec[hashMap.size()]);
            this.kits.put(stringArray[n], new KitSet(stringArray[n], kitRecArray));
            ++n;
        }
        KitVersion[] kitVersionArray = this.kits.values().iterator();
        while (kitVersionArray.hasNext()) {
            this.resolve((KitSet)kitVersionArray.next());
        }
        kitVersionArray = this.getCurrentKits();
        int n3 = 0;
        while (n3 < kitVersionArray.length) {
            kitSummaryArray = kitVersionArray[n3];
            kitRecArray = (KitRec[])this.kits.get(kitSummaryArray.name);
            if (kitRecArray != null) {
                kitRecArray.current = kitSummaryArray;
                kitRecArray.desired = kitRecArray.getRec(kitSummaryArray.version);
                if (kitRecArray.desired != null && !kitRecArray.desired.isSupported()) {
                    kitRecArray.desired = null;
                }
                if (kitRecArray.desired == null) {
                    kitRecArray.desired = kitRecArray.getLatestSupported();
                }
                kitRecArray.origDesired = kitRecArray.desired;
            }
            ++n3;
        }
    }

    private final void resolve(KitSet kitSet) {
        if (kitSet.resolved) {
            return;
        }
        KitRec[] kitRecArray = kitSet.kits;
        int n = 0;
        while (n < kitRecArray.length) {
            KitRec kitRec = kitRecArray[n];
            Depend[] dependArray = kitRec.depends();
            int n2 = 0;
            while (n2 < dependArray.length) {
                Depend depend = dependArray[n2];
                KitSet kitSet2 = (KitSet)this.kits.get(depend.name());
                if (kitSet2 == null) {
                    kitRec.markUnsupported("Depends on kit not in local kit database: " + depend.name());
                } else {
                    this.resolve(kitSet2);
                    boolean bl = false;
                    KitRec[] kitRecArray2 = kitSet2.getSupportedKits();
                    int n3 = 0;
                    while (n3 < kitRecArray2.length) {
                        if (depend.match(kitRecArray2[n3].kitSummary.version(), kitRecArray2[n3].kitSummary.checksum())) {
                            bl = true;
                            break;
                        }
                        ++n3;
                    }
                    if (!bl) {
                        kitRec.markUnsupported("Depends on unsupported kit: " + depend);
                    }
                }
                ++n2;
            }
            ++n;
        }
        kitSet.resolved = true;
    }

    public int size() {
        return this.kits.size();
    }

    public Version getInstalledVersion(String string) {
        KitSet kitSet = this.kitset(string);
        return kitSet.current == null ? null : kitSet.current.version;
    }

    public int getInstalledChecksum(String string) {
        KitSet kitSet = this.kitset(string);
        return kitSet.current == null ? -1 : kitSet.current.checksum;
    }

    public Version getLatestVersion(String string) {
        KitRec kitRec = this.kitset(string).getLatest();
        return kitRec == null ? null : kitRec.kitSummary.version();
    }

    public Version getDesiredVersion(String string) {
        KitSet kitSet = this.kitset(string);
        return kitSet.desired == null ? null : kitSet.desired.kitSummary.version();
    }

    public int getDesiredChecksum(String string) {
        KitSet kitSet = this.kitset(string);
        return kitSet.desired == null ? -1 : kitSet.desired.kitSummary.checksum();
    }

    public void setDesiredVersion(String string, Version version) {
        KitSet kitSet = this.kitset(string);
        kitSet.desired = kitSet.getRec(version);
    }

    public KitVersion[] getAvailableVersions(String string) {
        KitSet kitSet = this.kitset(string);
        KitVersion[] kitVersionArray = new KitVersion[kitSet.kits.length];
        int n = 0;
        while (n < kitSet.kits.length) {
            KitDb.KitSummary kitSummary = kitSet.kits[n].kitSummary;
            kitVersionArray[n] = new KitVersion(kitSummary.name(), kitSummary.checksum(), kitSummary.version());
            ++n;
        }
        return kitVersionArray;
    }

    public Depend[] getUnmetDependencies(String string) {
        Class clazz = class$sedona$Depend;
        if (clazz == null) {
            clazz = class$sedona$Depend = KitManagerModel.class("[Lsedona.Depend;", false);
        }
        Array array = new Array(clazz);
        KitSet kitSet = this.kitset(string);
        if (kitSet.desired == null) {
            return (Depend[])array.trim();
        }
        int n = 0;
        while (n < kitSet.desired.depends().length) {
            Depend depend = kitSet.desired.depends()[n];
            KitSet kitSet2 = this.kitset(depend.name());
            if (kitSet2 == null || kitSet2.desired == null || !depend.match(kitSet2.desired.kitSummary.version())) {
                array.add((Object)depend);
            }
            ++n;
        }
        return (Depend[])array.sort(new Comparator(){

            public final int compare(Object object, Object object2) {
                Depend depend = (Depend)object;
                Depend depend2 = (Depend)object2;
                if (depend.name().equals("sys")) {
                    return -1;
                }
                if (depend2.name().equals("sys")) {
                    return 1;
                }
                return depend.name().compareTo(depend2.name());
            }
        }).trim();
    }

    public boolean isKitSupported(String string) {
        return this.kitset(string).hasSupported();
    }

    public boolean isKitRequiredByApp(String string) {
        return this.appRequired.contains(string);
    }

    public final String[] getSortedKits() {
        if (this.sortedKits != null) {
            return this.sortedKits;
        }
        this.sortedKits = this.kits.keySet().toArray(new String[this.kits.size()]);
        Arrays.sort(this.sortedKits, new Comparator(){

            public final int compare(Object object, Object object2) {
                if (object.equals("sys")) {
                    return -1;
                }
                if (object2.equals("sys")) {
                    return 1;
                }
                return ((String)object).compareTo((String)object2);
            }
        });
        Arrays.sort(this.sortedKits, new Comparator(){

            public final int compare(Object object, Object object2) {
                boolean bl;
                boolean bl2 = false;
                if (((KitSet)KitManagerModel.this.kits.get((Object)object)).current != null) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                boolean bl4 = false;
                if (((KitSet)KitManagerModel.this.kits.get((Object)object2)).current != null) {
                    bl4 = bl = true;
                }
                if (bl3 && !bl) {
                    return -1;
                }
                if (!bl3 && bl) {
                    return 1;
                }
                return 0;
            }
        });
        Arrays.sort(this.sortedKits, new Comparator(){

            public final int compare(Object object, Object object2) {
                int n;
                boolean bl = ((KitSet)KitManagerModel.this.kits.get(object)).hasSupported();
                int n2 = 0;
                if (((KitSet)KitManagerModel.this.kits.get((Object)object)).current != null) {
                    n2 = 1;
                }
                int n3 = n2;
                boolean bl2 = ((KitSet)KitManagerModel.this.kits.get(object2)).hasSupported();
                int n4 = 0;
                if (((KitSet)KitManagerModel.this.kits.get((Object)object2)).current != null) {
                    n4 = n = 1;
                }
                if (bl && !bl2) {
                    return n + -1;
                }
                if (!bl && bl2) {
                    return 1 - n3;
                }
                return 0;
            }
        });
        return this.sortedKits;
    }

    public ManagerVerifier.VerifyItem[] verify() {
        return ManagerVerifier.verify(this);
    }

    public KitDb.KitSummary[] commit() {
        Class clazz = class$com$tridium$nsedona$env$KitDb$KitSummary;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$env$KitDb$KitSummary = KitManagerModel.class("[Lcom.tridium.nsedona.env.KitDb$KitSummary;", false);
        }
        Array array = new Array(clazz);
        Iterator iterator = this.kits.keySet().iterator();
        while (iterator.hasNext()) {
            KitSet kitSet = this.kitset((String)iterator.next());
            if (kitSet.desired == null) continue;
            array.add((Object)kitSet.desired.kitSummary);
        }
        return (KitDb.KitSummary[])array.trim();
    }

    public Schema commitSchema() {
        KitDb.KitSummary[] kitSummaryArray = this.commit();
        KitPart[] kitPartArray = new KitPart[kitSummaryArray.length];
        int n = 0;
        while (n < kitSummaryArray.length) {
            kitPartArray[n] = kitSummaryArray[n].getKitPart();
            ++n;
        }
        try {
            return Schema.load((KitPart[])kitPartArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void autoselect(KitSet kitSet) {
        KitRec kitRec = kitSet.desired;
        if (kitRec == null) {
            throw new IllegalStateException();
        }
        Depend[] dependArray = kitRec.depends();
        int n = 0;
        while (n < dependArray.length) {
            if (this.getDesiredVersion(dependArray[n].name()) == null) {
                KitSet kitSet2 = this.kitset(dependArray[n].name());
                kitSet2.setDesired(dependArray[n]);
            }
            ++n;
        }
    }

    public final KitSet kitset(String string) {
        KitSet kitSet = (KitSet)this.kits.get(string);
        if (kitSet == null) {
            kitSet = new KitSet(string, new KitRec[0]);
            this.kits.put(string, kitSet);
        }
        return kitSet;
    }

    protected void log(String string) {
    }

    protected void log(String string, double d) {
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.nativeDepends = new HashMap(3);
        this.appChecksums = new HashMap(7);
        this.appRequired = new HashSet(7);
        this.kits = new LinkedHashMap(17);
        this.checkNativeDependencies = false;
        this.currentKits = null;
        this.sortedKits = null;
    }

    public KitManagerModel(OfflineApp offlineApp, SedonaEnv sedonaEnv) {
        this.this();
        this.app = offlineApp;
        this.env = sedonaEnv;
        this.kitDb = new CachingDb(sedonaEnv.kitDb());
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class KitSet {
        public final String kitName;
        public final KitRec[] kits;
        public KitVersion current;
        public KitRec desired;
        KitRec origDesired;
        boolean resolved;

        public KitRec getRec(Version version) {
            int n = 0;
            while (n < this.kits.length) {
                if (this.kits[n].kitSummary.version().equals((Object)version)) {
                    return this.kits[n];
                }
                ++n;
            }
            return null;
        }

        public KitRec[] getSupportedKits() {
            return (KitRec[])new Array((Object[])this.kits).filter(new IFilter(){

                public final boolean accept(Object object) {
                    return ((KitRec)object).isSupported();
                }
            }).trim();
        }

        public boolean hasSupported() {
            int n = 0;
            while (n < this.kits.length) {
                if (this.kits[n].isSupported()) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        public KitRec getLatestSupported() {
            KitRec[] kitRecArray = this.getSupportedKits();
            return kitRecArray.length == 0 ? null : kitRecArray[0];
        }

        public KitRec getLatest() {
            return this.kits.length == 0 ? null : this.kits[0];
        }

        public void setDesired(Depend depend) {
            if (!depend.name().equals(this.kitName)) {
                throw new IllegalStateException("depend kit: " + depend.name() + " != " + this.kitName);
            }
        }

        void dump() {
            System.out.println("Kit: " + this.kitName);
            if (this.current != null) {
                System.out.println("  installed = " + this.current);
            }
            if (this.desired != null) {
                System.out.println("  desired = " + this.desired.kitSummary.version());
            }
            int n = 0;
            while (n < this.kits.length) {
                System.out.println("  " + this.kits[n]);
                ++n;
            }
        }

        private final /* synthetic */ void this() {
            this.current = null;
            this.desired = null;
            this.origDesired = null;
            this.resolved = false;
        }

        public KitSet(String string, KitRec[] kitRecArray) {
            this.this();
            this.kitName = string;
            Arrays.sort(kitRecArray);
            this.kits = kitRecArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class KitRec
    implements Comparable {
        public final KitDb.KitSummary kitSummary;
        private final KitDb db;
        private Array errors;
        static /* synthetic */ Class class$java$lang$String;

        public boolean hasNatives() {
            return this.kitSummary.hasNatives();
        }

        public Depend[] depends() {
            return this.kitSummary.depends();
        }

        private final void checkDepends() {
            Depend[] dependArray = this.depends();
            int n = 0;
            while (n < dependArray.length) {
                block5: {
                    try {
                        KitDb.KitSummary[] kitSummaryArray = this.db.list(dependArray[n].name());
                        int n2 = 0;
                        while (n2 < kitSummaryArray.length) {
                            if (!dependArray[n].match(kitSummaryArray[n2].version(), kitSummaryArray[n2].checksum())) {
                                ++n2;
                                continue;
                            }
                            break block5;
                        }
                    }
                    catch (Exception exception) {}
                    this.markUnsupported("Missing dependency " + dependArray[n]);
                }
                ++n;
            }
        }

        public String kitName() {
            return this.kitSummary.name();
        }

        public void markUnsupported(String string) {
            this.errors.add((Object)string);
        }

        public boolean isSupported() {
            return this.errors.isEmpty();
        }

        public String[] errors() {
            return (String[])this.errors.trim();
        }

        public int compareTo(Object object) {
            KitRec kitRec = (KitRec)object;
            int n = this.kitName().compareTo(kitRec.kitName());
            n = this.kitName().compareTo(kitRec.kitName());
            if (n == 0 && (n = -this.kitSummary.version().compareTo((Object)kitRec.kitSummary.version())) == 0) {
                long l = this.kitSummary.buildTime() - kitRec.kitSummary.buildTime();
                n = l == 0L ? 0 : (l < 0L ? 1 : -1);
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.isSupported() ? (char)'+' : '-').append(' ').append(this.kitSummary.fileName()).append(this.hasNatives() ? " [native]" : " ");
            if (!this.isSupported()) {
                stringBuffer.append(this.errors.last());
            }
            return stringBuffer.toString();
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            Class clazz = class$java$lang$String;
            if (clazz == null) {
                clazz = class$java$lang$String = KitRec.class("[Ljava.lang.String;", false);
            }
            this.errors = new Array(clazz);
        }

        public KitRec(KitDb.KitSummary kitSummary, KitDb kitDb) {
            this.this();
            this.kitSummary = kitSummary;
            this.db = kitDb;
            try {
                NSedonaUtil.checkLicense(kitSummary.name());
            }
            catch (Exception exception) {
                this.markUnsupported("Not licensed: " + exception.getMessage());
            }
            this.checkDepends();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class CachingDb
    extends KitDb {
        private KitDb db;
        private String[] kits;
        private HashMap summaryMap;

        public String[] kits() {
            if (this.kits == null) {
                this.kits = this.db.kits();
            }
            return this.kits;
        }

        public KitDb.KitSummary[] list(String string) throws Exception {
            KitDb.KitSummary[] kitSummaryArray = (KitDb.KitSummary[])this.summaryMap.get(string);
            if (kitSummaryArray == null) {
                kitSummaryArray = this.db.list(string);
                this.summaryMap.put(string, kitSummaryArray);
            }
            return kitSummaryArray;
        }

        public boolean extractKit(Depend depend, OutputStream outputStream) throws Exception {
            throw new UnsupportedOperationException("why are you extracting kits in the kit manager?");
        }

        public void installKit(String string, int n, Version version, InputStream inputStream) throws Exception {
            throw new UnsupportedOperationException("why are you installing kits in the kit manager?");
        }

        private final /* synthetic */ void this() {
            this.kits = null;
            this.summaryMap = new HashMap();
        }

        public CachingDb(KitDb kitDb) {
            super(kitDb.env);
            this.this();
            this.db = kitDb;
        }
    }
}

