/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.sox;

import com.tridium.nsedona.dasp.TunneledDaspSocket;
import com.tridium.nsedona.sox.BSoxSession;
import com.tridium.nsedona.sox.NSoxClient;
import java.net.InetAddress;
import javax.baja.log.Log;
import javax.baja.naming.BIpHost;
import sedona.dasp.DaspAcceptor;
import sedona.dasp.DaspSocket;
import sedona.sox.SoxClient;

public class NSoxSocket {
    private static final Object defLock = new Object();
    private static NSoxSocket def = null;
    static Log log = Log.getLog((String)"sedona.sox.session");
    public final DaspSocket daspSocket;
    private final boolean isTunneled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NSoxSocket getDefault() throws Exception {
        Object object = defLock;
        synchronized (object) {
            if (def == null) {
                def = new NSoxSocket(-1, null, 14);
                log.message("NSoxSocket default opened on port " + NSoxSocket.def.daspSocket.port());
            }
            return def;
        }
    }

    public static NSoxSocket make(BSoxSession bSoxSession) throws Exception {
        if (bSoxSession == null || bSoxSession.getRoutes() == null) {
            return NSoxSocket.getDefault();
        }
        return new NSoxSocket(bSoxSession);
    }

    public SoxClient makeSoxClient(BIpHost bIpHost, int n, String string, String string2) throws Exception {
        return this.makeSoxClient(bIpHost.getInetAddress(), n, string, string2);
    }

    public SoxClient makeSoxClient(InetAddress inetAddress, int n, String string, String string2) throws Exception {
        if (this.daspSocket.queuingMode() != 14) {
            throw new IllegalStateException("cannot open sox client with socket queuing mode");
        }
        return new NSoxClient(this.daspSocket, inetAddress, n, string, string2);
    }

    public void close() {
        this.daspSocket.close();
    }

    private NSoxSocket(int n, DaspAcceptor daspAcceptor, int n2) throws Exception {
        this.daspSocket = DaspSocket.open((int)n, (DaspAcceptor)daspAcceptor, (int)n2);
        this.isTunneled = false;
    }

    private NSoxSocket(BSoxSession bSoxSession) throws Exception {
        this.daspSocket = new TunneledDaspSocket(bSoxSession);
        this.isTunneled = true;
    }
}

