/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nsedona.ui.daemon;

import com.tridium.nsedona.env.LocalSedonaEnv;
import com.tridium.nsedona.env.SedonaEnv;
import com.tridium.nsedona.ui.daemon.BSedonaEnvManager;
import com.tridium.nsedona.ui.daemon.ImportCommand;
import com.tridium.nsedona.ui.daemon.UnifiedFileSpace;
import com.tridium.platform.daemon.task.DaemonSessionTask;
import com.tridium.platform.daemon.task.DaemonSessionTaskListener;
import com.tridium.platform.ui.util.AsyncCommand;
import com.tridium.platform.ui.util.CommandUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BEnvTable
extends BTreeTable {
    private static final Lexicon lex;
    private static final BImage Directory;
    private static final BImage Manifest;
    private static final BImage Kit;
    private static final BImage Par;
    public static final Type TYPE;
    protected final BSedonaEnvManager mgr;
    private UnifiedFileSpace fs;
    private BEnvTable other;
    private FilePath sedonaHome;
    private TransferState state;
    private String filter;
    final BToolBar toolbar;
    Delete deleteCommand;
    TransferMark transferMark;
    SelectMissing missingCommand;
    static /* synthetic */ Class class$com$tridium$nsedona$ui$daemon$BEnvTable;
    static /* synthetic */ Class class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;

    private final void updateCommands() {
        boolean bl = this.getTransferState().isEmpty();
        this.deleteCommand.setEnabled(bl ^ true);
        this.transferMark.setEnabled(bl ^ true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(UnifiedFileSpace unifiedFileSpace, BEnvTable bEnvTable) {
        this.fs = unifiedFileSpace;
        this.other = bEnvTable;
        this.sedonaHome = unifiedFileSpace.getSedonaHome();
        String string = unifiedFileSpace.isLocalFileSpace() ? "remote" : "local";
        BImage bImage = unifiedFileSpace.isLocalFileSpace() ? BImage.make((BIcon)BIcon.std((String)"arrowRight.png")) : BImage.make((BIcon)BIcon.std((String)"arrowLeft.png"));
        this.transferMark = new TransferMark(string, bImage);
        this.toolbar.add("missing", (Command)this.missingCommand);
        if (unifiedFileSpace.isLocalFileSpace()) {
            this.toolbar.add("import", (Command)new ImportCommand(this));
        }
        this.toolbar.add(null, (BValue)new BSeparator());
        this.toolbar.add("delete", (Command)this.deleteCommand);
        try {
            this.mgr.getWbShell().enterBusy();
            Model model = new Model();
            this.setModel((TableModel)model);
            this.reload();
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.updateCommands();
            this.mgr.getWbShell().exitBusy();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.updateCommands();
        }
        this.mgr.getWbShell().exitBusy();
    }

    public void filter(String string) {
        this.filter = string;
        ((Model)this.getTreeTableModel()).filter();
    }

    public final void reload() {
        this.reload(ReloadSet.reloadAll());
    }

    public void reload(ReloadSet reloadSet) {
        ((Model)this.getTreeTableModel()).reload(reloadSet);
    }

    public Command getTransferCommand() {
        return this.transferMark;
    }

    public BToolBar getCommandToolbar() {
        return this.toolbar;
    }

    public final UnifiedFileSpace getUnifiedFileSpace() {
        return this.fs;
    }

    public SedonaEnv getSedonaEnv() {
        if (this.fs.isLocalFileSpace()) {
            return new LocalSedonaEnv();
        }
        throw new UnsupportedOperationException("not implemented for platform daemon yet");
    }

    public TransferState getTransferState() {
        return this.state;
    }

    public void setTransferState(TransferState transferState) {
        this.state = transferState;
        this.state.setTable((BTable)this);
    }

    public TransferItem[] getTransferItems() {
        Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem = BEnvTable.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$TransferItem;", false);
        }
        Array array = new Array(clazz);
        EnvNode[] envNodeArray = this.getTransferState().getMarkedNodes();
        int n = 0;
        while (n < envNodeArray.length) {
            Object[] objectArray = envNodeArray[n].getTransferItems();
            if (objectArray.length == 0) {
                System.out.println(" >> WARNING: null transfer item???");
            } else {
                array.addAll(objectArray);
            }
            ++n;
        }
        return (TransferItem[])array.trim();
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.toolbar = new BToolBar();
        this.deleteCommand = new Delete();
        this.missingCommand = new SelectMissing();
    }

    public BEnvTable() {
        this.this();
        throw new UnsupportedOperationException("not valid for this component");
    }

    public BEnvTable(BSedonaEnvManager bSedonaEnvManager) {
        super((TreeTableModel)new EmptyModel());
        this.this();
        this.setTransferState(new TransferState(bSedonaEnvManager));
        this.setController((TableController)new Controller());
        this.setCellRenderer((TableCellRenderer)new Renderer());
        this.mgr = bSedonaEnvManager;
    }

    static {
        Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable = BEnvTable.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable;", false);
        }
        lex = Lexicon.make((Class)clazz);
        Directory = BImage.make((BIcon)BIcon.std((String)"folder.png"));
        Manifest = BImage.make((BIcon)BIcon.std((String)"files/xml.png"));
        Kit = BImage.make((BIcon)BIcon.std((String)"module.png"));
        Par = BImage.make((BIcon)BIcon.std((String)"files/zip.png"));
        Class clazz2 = class$com$tridium$nsedona$ui$daemon$BEnvTable;
        if (clazz2 == null) {
            clazz2 = class$com$tridium$nsedona$ui$daemon$BEnvTable = BEnvTable.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable;", false);
        }
        TYPE = Sys.loadType((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class TransferState
    extends BTable.TableSupport {
        private BSedonaEnvManager mgr;
        private Set marked;

        public boolean isEmpty() {
            return this.marked.isEmpty();
        }

        public void toggleMark(EnvNode envNode) {
            if (!envNode.isTransferable()) {
                return;
            }
            if (!this.marked.remove(envNode)) {
                this.marked.add(envNode);
            }
            this.markChanged();
        }

        public void mark(EnvNode envNode) {
            if (envNode.isTransferable()) {
                if (this.marked.add(envNode)) {
                    this.markChanged();
                }
            } else {
                int n = envNode.getChildCount();
                int n2 = 0;
                while (n2 < n) {
                    this.mark((EnvNode)envNode.getChild(n2));
                    ++n2;
                }
            }
        }

        public void unmark(EnvNode envNode) {
            if (envNode.isTransferable()) {
                if (this.marked.remove(envNode)) {
                    this.markChanged();
                }
            } else {
                int n = envNode.getChildCount();
                int n2 = 0;
                while (n2 < n) {
                    this.unmark((EnvNode)envNode.getChild(n2));
                    ++n2;
                }
            }
        }

        public void clearMark() {
            if (!this.isEmpty()) {
                this.marked.clear();
                this.markChanged();
            }
        }

        public boolean isMarked(EnvNode envNode) {
            return this.marked.contains(envNode);
        }

        public EnvNode[] getMarkedNodes() {
            return this.marked.toArray(new EnvNode[this.marked.size()]);
        }

        private final void markChanged() {
            BEnvTable bEnvTable = (BEnvTable)this.getTable();
            bEnvTable.updateCommands();
            this.getModel().updateTable();
        }

        private final /* synthetic */ void this() {
            this.marked = new HashSet();
        }

        public TransferState(BSedonaEnvManager bSedonaEnvManager) {
            this.this();
            this.mgr = bSedonaEnvManager;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Delete
    extends FileCommand {
        protected void doCommand() throws Exception {
            if (4 == BDialog.confirm((BWidget)this.getOwner(), (Object)"Delete marked files?")) {
                TransferItem[] transferItemArray = BEnvTable.this.getTransferItems();
                BEnvTable.this.fs.delete(transferItemArray, (ICancelHint)BEnvTable.this.mgr, (DaemonSessionTaskListener)BEnvTable.this.mgr);
                BEnvTable.this.getTransferState().clearMark();
                BEnvTable.this.getSelection().deselectAll();
                BEnvTable.this.reload(new ReloadSet(transferItemArray));
            }
        }

        public Delete() {
            super("envTable.delete");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TransferMark
    extends FileCommand {
        public void doCommand() throws Exception {
            TransferItem[] transferItemArray = BEnvTable.this.getTransferItems();
            BEnvTable.this.other.getUnifiedFileSpace().transfer(transferItemArray, (ICancelHint)BEnvTable.this.mgr, (DaemonSessionTaskListener)BEnvTable.this.mgr);
            BEnvTable.this.state.clearMark();
            BEnvTable.this.other.reload(new ReloadSet(transferItemArray));
        }

        public TransferMark(String string, BImage bImage) {
            super((BWidget)BEnvTable.this, lex.getText("envTable.xMark.label", new Object[]{string}), bImage, null, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Model
    extends TreeTableModel {
        final EnvNode[] roots;

        public void filter() {
            int n = 0;
            while (n < this.roots.length) {
                this.roots[n].filter();
                ++n;
            }
            this.updateTreeTable(true);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void reload(ReloadSet reloadSet) {
            DaemonSessionTask daemonSessionTask = new DaemonSessionTask(lex, "envTable.reloadTitle", "envTable.reloadMsg");
            try {
                BEnvTable.this.mgr.taskStarted(daemonSessionTask);
                int n = 0;
                while (true) {
                    block4: {
                        if (n < this.roots.length) break block4;
                        this.filter();
                        break;
                    }
                    BEnvTable.this.mgr.taskUpdated(daemonSessionTask);
                    this.roots[n].reload(reloadSet, (DaemonSessionTaskListener)BEnvTable.this.mgr, daemonSessionTask);
                    ++n;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                BEnvTable.this.mgr.taskFinished(daemonSessionTask);
                throw throwable;
            }
            {
                Object var4_6 = null;
            }
            BEnvTable.this.mgr.taskFinished(daemonSessionTask);
        }

        public Set getAllTransferable() {
            Stack<Object> stack = new Stack<Object>();
            TreeSet<EnvNode> treeSet = new TreeSet<EnvNode>();
            int n = 0;
            while (n < this.roots.length) {
                stack.push(this.roots[n]);
                ++n;
            }
            while (!stack.isEmpty()) {
                EnvNode envNode = (EnvNode)stack.pop();
                if (envNode.isTransferable()) {
                    treeSet.add(envNode);
                    continue;
                }
                int n2 = envNode.children.size();
                int n3 = 0;
                while (n3 < n2) {
                    stack.push(envNode.children.get(n3));
                    ++n3;
                }
            }
            return treeSet;
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeTableNode getRoot(int n) {
            return this.roots[n];
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Model() {
            this.roots = new EnvNode[]{new ManifestNode(this), new KitNode(this), new PlatformNode(this)};
        }
    }

    static class ReloadSet {
        final TreeSet set;

        public static ReloadSet reloadAll() {
            return new ReloadSet(null);
        }

        public boolean needsReload(FilePath filePath) {
            boolean bl = false;
            if (this.set == null || this.set.contains(filePath)) {
                bl = true;
            }
            return bl;
        }

        public ReloadSet(TransferItem[] transferItemArray) {
            if (transferItemArray == null) {
                this.set = null;
            } else {
                this.set = new TreeSet();
                int n = 0;
                while (n < transferItemArray.length) {
                    TransferItem transferItem = transferItemArray[n];
                    FilePath filePath = transferItem.sedonaHomeRelPath;
                    do {
                        this.set.add(filePath);
                    } while ((filePath = filePath.getParent()) != null);
                    ++n;
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static abstract class EnvNode
    extends TreeTableNode
    implements Comparable {
        protected final BIFile file;
        private Array children;
        private Array filtered;
        static /* synthetic */ Class class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode;
        static /* synthetic */ Class class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;

        protected final UnifiedFileSpace ufs() {
            return ((BEnvTable)this.getTable()).getUnifiedFileSpace();
        }

        protected final String getFilter() {
            return ((BEnvTable)this.getTable()).filter;
        }

        public void filter() {
            String string = this.getFilter();
            if (string == null || string.length() == 0) {
                this.filtered = new Array(this.children.trim());
                int n = 0;
                while (n < this.children.size()) {
                    ((EnvNode)this.children.get(n)).filter();
                    ++n;
                }
                return;
            }
            this.filtered.clear();
            int n = 0;
            while (n < this.children.size()) {
                EnvNode envNode = (EnvNode)this.children.get(n);
                if (envNode.isTransferable()) {
                    if (this.accept(envNode.getFilterableName())) {
                        this.filtered.add((Object)envNode);
                    } else {
                        this.transferState().unmark(envNode);
                    }
                } else {
                    envNode.filter();
                    if (envNode.hasChildren()) {
                        this.filtered.add((Object)envNode);
                    }
                }
                ++n;
            }
        }

        public void reload(ReloadSet reloadSet, DaemonSessionTaskListener daemonSessionTaskListener, DaemonSessionTask daemonSessionTask) {
            Object object;
            HashMap<String, EnvNode> hashMap = new HashMap<String, EnvNode>();
            int n = 0;
            while (n < this.children.size()) {
                object = (EnvNode)this.children.get(n);
                hashMap.put(((EnvNode)object).file.getFilePath().toString(), (EnvNode)object);
                ++n;
            }
            TreeSet<EnvNode> treeSet = new TreeSet<EnvNode>();
            if (this.file != null && this.file.isDirectory() && reloadSet.needsReload(this.getRelPath(this.file))) {
                object = this.ufs();
                BIFile[] bIFileArray = ((UnifiedFileSpace)object).getChildren(this.file);
                daemonSessionTask.setMessage("loading: " + this.file.getFilePath());
                daemonSessionTaskListener.taskUpdated(daemonSessionTask);
                Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;
                if (clazz == null) {
                    clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem = EnvNode.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$TransferItem;", false);
                }
                Array array = new Array(clazz);
                int n2 = 0;
                while (n2 < bIFileArray.length) {
                    EnvNode envNode = (EnvNode)hashMap.remove(bIFileArray[n2].getFilePath().toString());
                    if (envNode == null) {
                        envNode = this.newChild(bIFileArray[n2]);
                    }
                    if (!envNode.isTransferable()) {
                        envNode.reload(reloadSet, daemonSessionTaskListener, daemonSessionTask);
                    }
                    if (envNode.isTransferable()) {
                        treeSet.add(envNode);
                    } else if (envNode.hasChildren()) {
                        treeSet.add(envNode);
                    } else {
                        array.add((Object)new TransferItem(envNode.file, this.getRelPath(envNode.file)));
                        System.out.println("Folder identified as empty, will be deleted:  " + bIFileArray[n2].getFilePath().toString());
                    }
                    ++n2;
                }
                Iterator iterator = hashMap.values().iterator();
                while (iterator.hasNext()) {
                    this.transferState().unmark((EnvNode)iterator.next());
                }
                Class clazz2 = class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode;
                if (clazz2 == null) {
                    clazz2 = class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode = EnvNode.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$EnvNode;", false);
                }
                this.children = new Array(clazz2, treeSet);
                this.filtered = new Array(this.children.trim());
                try {
                    if (!array.isEmpty()) {
                        this.ufs().delete((TransferItem[])array.trim(), null, daemonSessionTaskListener);
                    }
                }
                catch (Exception exception) {}
            }
        }

        private final boolean accept(String string) {
            if (string == null) {
                return false;
            }
            String string2 = this.getFilter();
            if (string2 == null || string2.length() == 0) {
                return true;
            }
            boolean bl = false;
            if (string.indexOf(string2) >= 0) {
                bl = true;
            }
            return bl;
        }

        public void expandPath() {
            this.expandPath(true);
        }

        public void expandPath(boolean bl) {
            TreeTableNode[] treeTableNodeArray = this.getPathFromRoot();
            int n = 0;
            while (n < treeTableNodeArray.length) {
                treeTableNodeArray[n].setExpanded(bl);
                ++n;
            }
        }

        protected abstract String getFilterableName();

        protected abstract EnvNode newChild(BIFile var1);

        public Set getTransferable(boolean bl) {
            Array array = bl ? this.filtered : this.children;
            TreeSet<EnvNode> treeSet = new TreeSet<EnvNode>();
            if (this.isTransferable()) {
                treeSet.add(this);
            } else {
                int n = 0;
                while (n < array.size()) {
                    treeSet.addAll(((EnvNode)array.get(n)).getTransferable(bl));
                    ++n;
                }
            }
            return treeSet;
        }

        public TransferItem[] getTransferItems() {
            if (!this.isTransferable()) {
                return null;
            }
            UnifiedFileSpace unifiedFileSpace = this.ufs();
            Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;
            if (clazz == null) {
                clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem = EnvNode.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$TransferItem;", false);
            }
            Array array = new Array(clazz);
            Stack<BIFile> stack = new Stack<BIFile>();
            stack.push(this.file);
            while (!stack.isEmpty()) {
                BIFile bIFile = (BIFile)stack.pop();
                if (bIFile.isDirectory()) {
                    BIFile[] bIFileArray = unifiedFileSpace.getChildren(bIFile);
                    int n = 0;
                    while (n < bIFileArray.length) {
                        stack.add(bIFileArray[n]);
                        ++n;
                    }
                    continue;
                }
                array.add((Object)new TransferItem(bIFile, this.getRelPath(bIFile)));
            }
            return (TransferItem[])array.trim();
        }

        protected FilePath getRelPath(BIFile bIFile) {
            String[] stringArray = bIFile.getFilePath().getNames();
            String[] stringArray2 = this.ufs().getSedonaHome().getNames();
            int n = stringArray2.length;
            FilePath filePath = new FilePath(stringArray[n++]);
            while (n < stringArray.length) {
                filePath = filePath.merge(stringArray[n++]);
            }
            return filePath;
        }

        public boolean isTransferable() {
            return false;
        }

        protected final TransferState transferState() {
            return ((BEnvTable)this.getTable()).getTransferState();
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                return this.file.getFileName();
            }
            return null;
        }

        public boolean hasChildren() {
            boolean bl = false;
            if (this.filtered.size() > 0) {
                bl = true;
            }
            return bl;
        }

        public int getChildCount() {
            return this.filtered.size();
        }

        public TreeTableNode getChild(int n) {
            return (TreeTableNode)this.filtered.get(n);
        }

        public int compareTo(Object object) {
            return this.getValueAt(0).toString().compareTo(((EnvNode)object).getValueAt(0).toString());
        }

        public int hashCode() {
            return this.getValueAt(0).hashCode();
        }

        public boolean equals(Object object) {
            return this.getValueAt(0).equals(((EnvNode)object).getValueAt(0));
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class<?> clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        private final /* synthetic */ void this() {
            Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode;
            if (clazz == null) {
                clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode = EnvNode.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$EnvNode;", false);
            }
            this.children = new Array(clazz);
            Class clazz2 = class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode;
            if (clazz2 == null) {
                clazz2 = class$com$tridium$nsedona$ui$daemon$BEnvTable$EnvNode = EnvNode.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$EnvNode;", false);
            }
            this.filtered = new Array(clazz2);
        }

        public EnvNode(TreeTableModel treeTableModel, BIFile bIFile) {
            super(treeTableModel);
            this.this();
            if (bIFile == null) {
                throw new IllegalStateException();
            }
            this.file = bIFile;
        }

        public EnvNode(EnvNode envNode, BIFile bIFile) {
            super((TreeTableNode)envNode);
            this.this();
            this.file = bIFile;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SelectMissing
    extends FileCommand {
        TreeTableNode[] nodes;

        public void doCommand() throws Exception {
            BEnvTable.this.getSelection().deselectAll();
            TransferState transferState = BEnvTable.this.getTransferState();
            Set set = new TreeSet();
            if (this.nodes == null) {
                set = ((Model)BEnvTable.this.getModel()).getAllTransferable();
                transferState.clearMark();
            } else {
                int n = 0;
                while (n < this.nodes.length) {
                    set.addAll(((EnvNode)this.nodes[n]).getTransferable(true));
                    ++n;
                }
            }
            Set set2 = ((Model)BEnvTable.this.other.getModel()).getAllTransferable();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                EnvNode envNode = (EnvNode)iterator.next();
                if (!set2.contains(envNode)) {
                    envNode.expandPath();
                    transferState.mark(envNode);
                    continue;
                }
                transferState.unmark(envNode);
            }
        }

        public SelectMissing() {
            this((TreeTableNode[])null);
        }

        public SelectMissing(TreeTableNode[] treeTableNodeArray) {
            super("envTable.selMissing");
            this.nodes = treeTableNodeArray;
        }
    }

    static class EmptyModel
    extends TreeTableModel {
        public int getRootCount() {
            return 0;
        }

        public TreeTableNode getRoot(int n) {
            return null;
        }

        public int getColumnCount() {
            return 0;
        }

        public String getColumnName(int n) {
            return null;
        }

        EmptyModel() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Controller
    extends TreeTableController {
        protected EnvNode node(int n) {
            return (EnvNode)this.getTreeTableModel().rowToNode(n);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
        }

        protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
            EnvNode envNode = this.node(n);
            if (envNode != null && envNode.isTransferable()) {
                this.getTreeTable().setMouseCursor(MouseCursor.hand);
            } else {
                this.getTreeTable().setMouseCursor(MouseCursor.normal);
            }
            super.cellEntered(bMouseEvent, n, n2);
        }

        protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
            this.getTreeTable().setMouseCursor(MouseCursor.normal);
            super.cellExited(bMouseEvent, n, n2);
        }

        public void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
            EnvNode envNode = this.node(n);
            if (envNode != null && envNode.isTransferable()) {
                BEnvTable.this.getTransferState().toggleMark(envNode);
                this.getSelection().deselectAll();
                return;
            }
            super.cellPressed(bMouseEvent, n, n2);
        }

        protected BMenu makePopup(TreeTableSubject treeTableSubject) {
            EnvNode envNode = (EnvNode)treeTableSubject.getActiveNode();
            if (envNode == null) {
                return super.makePopup(treeTableSubject);
            }
            if (!envNode.isTransferable()) {
                BMenu bMenu = new BMenu();
                TreeTableNode[] treeTableNodeArray = treeTableSubject.getNodes();
                bMenu.add("markAll", (Command)new MarkAll(treeTableNodeArray));
                bMenu.add("unmarkAll", (Command)new UnmarkAll(treeTableNodeArray));
                bMenu.add("missing", (Command)new SelectMissing(treeTableNodeArray));
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new CollapseTree(treeTableNodeArray));
                bMenu.add(null, (BValue)new BSeparator());
                Transfer transfer = new Transfer();
                transfer.setTransferNodes(treeTableNodeArray);
                bMenu.add("transfer", (Command)transfer);
                return bMenu;
            }
            return super.makePopup(treeTableSubject);
        }

        Controller() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Renderer
    extends TreeTableCellRenderer {
        private final EnvNode node(int n) {
            return (EnvNode)this.getTreeTableModel().rowToNode(n);
        }

        private final boolean isTransferable(TableCellRenderer.Cell cell) {
            EnvNode envNode = this.node(cell.row);
            boolean bl = false;
            if (envNode != null && envNode.isTransferable()) {
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            boolean bl = cell.selected;
            try {
                if (this.isTransferable(cell)) {
                    cell.selected = false;
                }
                super.paintCell(graphics, cell);
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                cell.selected = bl;
                throw throwable;
            }
            {
                Object var5_6 = null;
                cell.selected = bl;
                return;
            }
        }

        Renderer() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Transfer
    extends FileCommand {
        private TreeTableNode[] nodes;

        public void setTransferNodes(TreeTableNode[] treeTableNodeArray) {
            this.nodes = treeTableNodeArray;
        }

        protected void doCommand() throws Exception {
            Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;
            if (clazz == null) {
                clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem = BEnvTable.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$TransferItem;", false);
            }
            Array array = new Array(clazz);
            int n = 0;
            while (n < this.nodes.length) {
                Set set = ((EnvNode)this.nodes[n]).getTransferable(true);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    array.addAll((Object[])((EnvNode)iterator.next()).getTransferItems());
                }
                ++n;
            }
            TransferItem[] transferItemArray = (TransferItem[])array.trim();
            BEnvTable.this.other.getUnifiedFileSpace().transfer(transferItemArray, (ICancelHint)BEnvTable.this.mgr, (DaemonSessionTaskListener)BEnvTable.this.mgr);
            BEnvTable.this.other.reload(new ReloadSet(transferItemArray));
        }

        public Transfer() {
            super("envTable.xDescendants");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    abstract class FileCommand
    extends AsyncCommand {
        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void doInvokeAsync() {
            try {
                try {
                    BEnvTable.this.mgr.getWbShell().enterBusy();
                    this.doCommand();
                }
                catch (Exception exception) {
                    CommandUtil.error((Command)this, (BWidget)BEnvTable.this.mgr, (Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                BEnvTable.this.mgr.getWbShell().exitBusy();
                throw throwable;
            }
            {
                Object var2_4 = null;
            }
            BEnvTable.this.mgr.getWbShell().exitBusy();
        }

        protected abstract void doCommand() throws Exception;

        public FileCommand(String string) {
            super((BWidget)BEnvTable.this, lex, string);
        }

        protected FileCommand(BWidget bWidget, String string, BImage bImage, BAccelerator bAccelerator, String string2) {
            super(bWidget, string, bImage, bAccelerator, string2);
        }
    }

    public static class TransferItem
    implements Comparable {
        public BIFile file;
        public FilePath sedonaHomeRelPath;

        public int compareTo(Object object) {
            return this.sedonaHomeRelPath.getBody().compareTo(((TransferItem)object).sedonaHomeRelPath.getBody());
        }

        public int hashCode() {
            return this.file.getFilePath().toString().hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            TransferItem transferItem = (TransferItem)object;
            return this.file.equals((Object)transferItem.file);
        }

        public String toString() {
            return this.file.getFileName() + ": " + this.sedonaHomeRelPath;
        }

        public TransferItem(BIFile bIFile, FilePath filePath) {
            this.file = bIFile;
            this.sedonaHomeRelPath = filePath;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class CollapseTree
    extends Command {
        TreeTableNode[] nodes;

        public CommandArtifact doInvoke() throws Exception {
            int n = 0;
            while (n < this.nodes.length) {
                ((EnvNode)this.nodes[n]).expandPath(false);
                ++n;
            }
            return null;
        }

        public CollapseTree(TreeTableNode[] treeTableNodeArray) {
            super((BWidget)BEnvTable.this, lex, "envTable.collapseTree");
            this.nodes = treeTableNodeArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class UnmarkAll
    extends Command {
        TreeTableNode[] nodes;

        public CommandArtifact doInvoke() throws Exception {
            TransferState transferState = BEnvTable.this.getTransferState();
            int n = 0;
            while (n < this.nodes.length) {
                transferState.unmark((EnvNode)this.nodes[n]);
                ++n;
            }
            return null;
        }

        public UnmarkAll(TreeTableNode[] treeTableNodeArray) {
            super((BWidget)BEnvTable.this, lex, "envTable.unmarkAll");
            this.nodes = treeTableNodeArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class MarkAll
    extends Command {
        TreeTableNode[] nodes;

        public CommandArtifact doInvoke() throws Exception {
            TransferState transferState = BEnvTable.this.getTransferState();
            int n = 0;
            while (n < this.nodes.length) {
                transferState.mark((EnvNode)this.nodes[n]);
                ++n;
            }
            return null;
        }

        public MarkAll(TreeTableNode[] treeTableNodeArray) {
            super((BWidget)BEnvTable.this, lex, "envTable.markAll");
            this.nodes = treeTableNodeArray;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class PlatformNode
    extends EnvNode {
        private final String platformName;

        protected String getFilterableName() {
            return this.platformName;
        }

        protected EnvNode newChild(BIFile bIFile) {
            return new PlatformNode(this, bIFile);
        }

        public boolean isPlatform() {
            return ".par".equals(this.file.getFileName());
        }

        public boolean isTransferable() {
            return this.isPlatform();
        }

        public TransferItem[] getTransferItems() {
            Object[] objectArray = super.getTransferItems();
            if (objectArray != null) {
                Class clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem;
                if (clazz == null) {
                    clazz = class$com$tridium$nsedona$ui$daemon$BEnvTable$TransferItem = BEnvTable.class("[Lcom.tridium.nsedona.ui.daemon.BEnvTable$TransferItem;", false);
                }
                Array array = new Array(clazz);
                array.addAll(objectArray);
                array.add((Object)new TransferItem(this.file, this.getRelPath(this.file)));
                objectArray = (TransferItem[])array.trim();
            }
            return objectArray;
        }

        public String getPlatformDisplayName() {
            if (!this.isPlatform()) {
                return null;
            }
            TreeTableNode[] treeTableNodeArray = this.getPathFromRoot();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 1;
            while (n < treeTableNodeArray.length - 1) {
                stringBuffer.append(treeTableNodeArray[n].getValueAt(0));
                if (n + 1 < treeTableNodeArray.length - 1) {
                    stringBuffer.append("-");
                }
                ++n;
            }
            stringBuffer.append(".par");
            return stringBuffer.toString();
        }

        public Object getValueAt(int n) {
            if (n == 0) {
                if (this.getParent() == null) {
                    return "platforms";
                }
                if (this.isPlatform()) {
                    return this.platformName;
                }
                return super.getValueAt(n);
            }
            return super.getValueAt(n);
        }

        public BImage getIcon() {
            if (this.isPlatform()) {
                return this.transferState().isMarked(this) ? Par : Par.getDisabledImage();
            }
            return Directory;
        }

        PlatformNode(TreeTableModel treeTableModel) {
            super(treeTableModel, BEnvTable.this.fs.mkdir(BEnvTable.this.sedonaHome.merge("platforms").merge("db")));
            this.platformName = null;
        }

        PlatformNode(EnvNode envNode, BIFile bIFile) {
            super(envNode, bIFile);
            this.platformName = this.getPlatformDisplayName();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class KitNode
    extends EnvNode {
        protected String getFilterableName() {
            return this.file.getFileName();
        }

        protected EnvNode newChild(BIFile bIFile) {
            return new KitNode(this, bIFile);
        }

        public boolean isKit() {
            boolean bl = false;
            if (this.file != null && "kit".equals(this.file.getExtension())) {
                bl = true;
            }
            return bl;
        }

        public boolean isTransferable() {
            return this.isKit();
        }

        public BImage getIcon() {
            if (this.isKit()) {
                return this.transferState().isMarked(this) ? Kit : Kit.getDisabledImage();
            }
            return Directory;
        }

        KitNode(TreeTableModel treeTableModel) {
            super(treeTableModel, BEnvTable.this.fs.mkdir(BEnvTable.this.sedonaHome.merge("kits")));
        }

        KitNode(EnvNode envNode, BIFile bIFile) {
            super(envNode, bIFile);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ManifestNode
    extends EnvNode {
        protected String getFilterableName() {
            return this.file.getFileName();
        }

        protected EnvNode newChild(BIFile bIFile) {
            return new ManifestNode(this, bIFile);
        }

        public boolean isManifest() {
            boolean bl = false;
            if (this.file != null && "xml".equals(this.file.getExtension())) {
                bl = true;
            }
            return bl;
        }

        public boolean isTransferable() {
            return this.isManifest();
        }

        public BImage getIcon() {
            if (this.isManifest()) {
                return this.transferState().isMarked(this) ? Manifest : Manifest.getDisabledImage();
            }
            return Directory;
        }

        public ManifestNode(TreeTableModel treeTableModel) {
            super(treeTableModel, BEnvTable.this.fs.mkdir(BEnvTable.this.sedonaHome.merge("manifests")));
        }

        public ManifestNode(ManifestNode manifestNode, BIFile bIFile) {
            super(manifestNode, bIFile);
        }
    }
}

