/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import sedona.Buf;
import sedona.offline.OfflineApp;
import sedona.util.FileUtil;
import sedona.util.TextUtil;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedonac.Compiler;
import sedonac.CompilerException;
import sedonac.CompilerStep;
import sedonac.Location;

public class ConvertAppFile
extends CompilerStep {
    public void run() {
        XElem xElem = this.compiler.xml;
        File file = this.compiler.input;
        File file2 = this.compiler.outDir;
        if (file2 == null) {
            file2 = file.getParentFile();
        }
        String string = FileUtil.getBase((String)file.getName());
        String string2 = xElem == null ? "sax" : "sab";
        File file3 = new File(file2, string + '.' + string2);
        this.log.info("  ConvertAppFile [" + file + " -> " + file3 + ']');
        OfflineApp offlineApp = null;
        try {
            offlineApp = xElem == null ? OfflineApp.decodeAppBinary((Buf)Buf.readFrom((File)file)) : OfflineApp.decodeAppXml((XElem)xElem);
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (Exception exception) {
            throw this.err(new CompilerException("Cannot load app file", new Location(file), exception));
        }
        try {
            if (xElem == null) {
                offlineApp.encodeAppXml(file3, this.compiler.nochk);
            } else {
                offlineApp.encodeAppBinary().writeTo(file3);
            }
        }
        catch (XException xException) {
            throw this.err(xException);
        }
        catch (Exception exception) {
            throw this.err(new CompilerException("Cannot save app file", new Location(file3), exception));
        }
        this.log.info("  +----------------------------------");
        this.log.info("  |  RAM:   " + TextUtil.kb((int)offlineApp.ramSize()));
        this.log.info("  |  FLASH: " + TextUtil.kb((int)offlineApp.flashSize()));
        this.log.info("  +----------------------------------");
    }

    public ConvertAppFile(Compiler compiler) {
        super(compiler);
    }
}

