/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Properties;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import sedona.Env;
import sedona.platform.NativeManifest;
import sedona.platform.PlatformManifest;
import sedona.util.FileUtil;
import sedona.xml.XContent;
import sedona.xml.XWriter;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.ir.IrMethod;
import sedonac.namespace.NativeId;
import sedonac.namespace.Slot;
import sedonac.platform.PlatformDef;
import sedonac.util.CStrGen;
import sedonac.util.VarResolver;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StagePlatform
extends CompilerStep {
    PlatformManifest manifest;
    File manifestFile;
    HashMap natives;

    public void run() {
        this.log.info("  StagePlatform");
        this.makePlatformManifest(this.compiler.platform);
        this.writeCHeaders();
        this.writeManifest();
        this.writeCPlatformManifest();
        this.quitIfErrors();
    }

    private final void makePlatformManifest(PlatformDef platformDef) {
        this.manifest = new PlatformManifest();
        this.manifest.id = platformDef.idPattern;
        this.manifest.vendor = platformDef.vendor;
        this.manifest.endian = platformDef.endian;
        this.manifest.blockSize = platformDef.blockSize;
        this.manifest.refSize = platformDef.refSize;
        this.manifest.armDouble = platformDef.armDouble;
        this.manifest.debug = platformDef.debug;
        this.manifest.test = platformDef.test;
        this.manifest.nativeKits = platformDef.nativeKits;
        Slot[] slotArray = this.findNativeMethods();
        this.manifest.nativeMethods = new NativeManifest[slotArray.length];
        int n = 0;
        while (n < slotArray.length) {
            this.manifest.nativeMethods[n] = this.toNativeManifest(this.manifest, slotArray[n]);
            ++n;
        }
        Arrays.sort(this.manifest.nativeMethods, new NativeComparator());
        n = 0;
        while (n < platformDef.manifestIncludes.length) {
            this.manifest.manifestIncludes.addContent((XContent)platformDef.manifestIncludes[n]);
            ++n;
        }
        this.resolvePlatformId();
    }

    private final Slot[] findNativeMethods() {
        int n = 0;
        while (n < this.compiler.kits.length) {
            IrKit irKit = this.compiler.kits[n];
            if (irKit.manifest.hasNatives) {
                int n2 = 0;
                while (n2 < irKit.types.length) {
                    Slot[] slotArray = irKit.types[n2].slots();
                    int n3 = 0;
                    while (n3 < slotArray.length) {
                        if (slotArray[n3].isNative()) {
                            this.natives.put(slotArray[n3].qname(), slotArray[n3]);
                        }
                        ++n3;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return this.natives.values().toArray(new Slot[this.natives.size()]);
    }

    private final NativeManifest toNativeManifest(PlatformManifest platformManifest, Slot slot) {
        IrMethod irMethod = (IrMethod)slot;
        return new NativeManifest(platformManifest, irMethod.qname(), irMethod.nativeId.string);
    }

    private final void resolvePlatformId() {
        if (this.manifest.id == null) {
            return;
        }
        Properties properties = new Properties();
        properties.put("stage.nativeChecksum", this.calcNativeCksum());
        try {
            this.manifest.id = new VarResolver(properties).resolve(this.manifest.id);
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage(), "id attribute");
        }
    }

    private final String calcNativeCksum() {
        CRC32 cRC32 = new CRC32();
        int n = 0;
        while (n < this.manifest.nativeMethods.length) {
            NativeManifest nativeManifest = this.manifest.nativeMethods[n];
            cRC32.update(nativeManifest.qname.getBytes());
            cRC32.update(this.toParamsString((IrMethod)this.natives.get(nativeManifest.qname)).getBytes());
            cRC32.update(nativeManifest.nativeId.getBytes());
            ++n;
        }
        return Integer.toHexString((int)cRC32.getValue());
    }

    private final String toParamsString(IrMethod irMethod) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < irMethod.params.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(irMethod.params[n]);
            ++n;
        }
        return stringBuffer.append(':').append(irMethod.returnType()).toString();
    }

    private final void writeCHeaders() {
        if (this.manifest.id == null) {
            return;
        }
        File file = new File(this.compiler.outDir, "sedonaPlatform.h");
        this.log.debug("    Writing [ " + file + " ]");
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("//");
            printWriter.println("// Generated by sedonac " + Env.version);
            printWriter.println("// " + Env.timestamp());
            printWriter.println("//");
            printWriter.println();
            printWriter.println("#ifndef SEDONAC_SEDONA_PLATFORM_H");
            printWriter.println("#define SEDONAC_SEDONA_PLATFORM_H");
            printWriter.println();
            printWriter.println("#define PLATFORM_ID \"" + this.manifest.id + '\"');
            printWriter.println();
            printWriter.println("#endif");
            printWriter.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write sedonaPlatform.h", new Location(file), (Throwable)exception);
        }
    }

    private final void writeManifest() {
        File file = new File(this.compiler.outDir, ".par");
        this.manifestFile = new File(file, "platformManifest.xml");
        this.log.debug("    Writing [ " + this.manifestFile + " ]");
        try {
            XWriter xWriter = new XWriter(this.manifestFile);
            this.manifest.encodeXml(xWriter);
            xWriter.close();
        }
        catch (Exception exception) {
            throw this.err("Cannot write platformManifest.xml", new Location(this.manifestFile), (Throwable)exception);
        }
    }

    private final void writeCPlatformManifest() {
        if (!this.compiler.platform.embedManifest) {
            return;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(this.manifestFile);
            File file = new File(this.compiler.outDir, "pm.zip");
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
            zipOutputStream.putNextEntry(new ZipEntry("platformManifest.xml"));
            FileUtil.pipe((InputStream)fileInputStream, (OutputStream)zipOutputStream);
            ((InputStream)fileInputStream).close();
            zipOutputStream.closeEntry();
            zipOutputStream.close();
            File file2 = new File(this.compiler.outDir, "platformManifest.c");
            CStrGen.toCFile(file, file2, "pm");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw this.err("Failed to write platformManifest.c");
        }
    }

    private final /* synthetic */ void this() {
        this.natives = new HashMap();
    }

    public StagePlatform(Compiler compiler) {
        super(compiler);
        this.this();
    }

    private static class NativeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            NativeId nativeId;
            NativeId nativeId2 = NativeId.parse(null, ((NativeManifest)object).nativeId);
            if (nativeId2.equals(nativeId = NativeId.parse(null, ((NativeManifest)object2).nativeId))) {
                throw new IllegalStateException("Duplicate nativeIds: " + nativeId2 + ' ' + nativeId);
            }
            int n = nativeId2.kitId - nativeId.kitId;
            return n == 0 ? nativeId2.methodId - nativeId.methodId : n;
        }

        private NativeComparator() {
        }
    }
}

