/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet;

import com.tridium.fox.message.FoxMessage;
import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.session.FoxResponse;
import com.tridium.fox.session.InvalidCommandException;
import com.tridium.fox.sys.BFoxChannel;
import com.tridium.nsedona.env.BufCompilerLog;
import com.tridium.nsedona.env.KitDb;
import com.tridium.nsedona.env.LocalSedonaEnv;
import com.tridium.nsedona.env.SedonaEnv;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;
import sedona.Buf;
import sedona.Depend;
import sedona.KitPart;
import sedona.manifest.KitManifest;
import sedona.platform.PlatformDbException;
import sedona.platform.PlatformManifest;
import sedona.util.Version;
import sedona.xml.XElem;
import sedona.xml.XParser;
import sedona.xml.XWriter;
import sedonac.CompilerLog;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BFoxSedonaEnvChannel
extends BFoxChannel {
    public static final Type TYPE;
    protected static final Log log;
    public static final String Channel = "sedonaenv";
    private Map buildMap;
    static /* synthetic */ Class class$com$tridium$sedonanet$BFoxSedonaEnvChannel;

    public Type getType() {
        return TYPE;
    }

    public FoxResponse process(FoxRequest foxRequest) throws Throwable {
        String string = foxRequest.command;
        if ("kits".equals(string)) {
            return this.kits(foxRequest);
        }
        if ("listKits".equals(string)) {
            return this.listKits(foxRequest);
        }
        if ("platformManifest".equals(string)) {
            return this.platformManifest(foxRequest);
        }
        if ("installPar".equals(string)) {
            return this.installPar(foxRequest);
        }
        if ("extractPar".equals(string)) {
            return this.extractPar(foxRequest);
        }
        if ("build".equals(string)) {
            return this.build(foxRequest);
        }
        if ("pollBuild".equals(string)) {
            return this.pollBuild(foxRequest);
        }
        if ("svmUri".equals(string)) {
            return this.svmUri(foxRequest);
        }
        if ("extractKit".equals(string)) {
            return this.extractKit(foxRequest);
        }
        if ("installKit".equals(string)) {
            return this.installKit(foxRequest);
        }
        if ("installManifest".equals(string)) {
            return this.installManifest(foxRequest);
        }
        if ("extractManifest".equals(string)) {
            return this.extractManifest(foxRequest);
        }
        throw new InvalidCommandException(string);
    }

    public PlatformManifest platformManifest(String string) {
        FoxRequest foxRequest = this.makeRequest("platformManifest");
        foxRequest.add("platformId", string);
        PlatformManifest platformManifest = null;
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            byte[] byArray = foxResponse.getBlob("manifest", null);
            if (byArray != null) {
                platformManifest = PlatformManifest.decodeXml((XElem)XParser.make((String)"manifest", (String)new String(byArray)).parse());
            }
        }
        catch (Exception exception) {}
        return platformManifest;
    }

    private final FoxResponse platformManifest(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        PlatformManifest platformManifest = sedonaEnv.platformDb().getPlatformManifest(foxRequest.getString("platformId"));
        if (platformManifest != null) {
            XWriter xWriter = null;
            try {
                Buf buf = new Buf();
                xWriter = new XWriter(buf.getOutputStream());
                platformManifest.encodeXml(xWriter);
                xWriter.close();
                foxResponse.add("manifest", buf.trim());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return foxResponse;
    }

    public String svmUri(String string) {
        FoxRequest foxRequest = this.makeRequest("svmUri");
        foxRequest.add("platformId", string);
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            String string2 = foxResponse.getString("uri", null);
            return string2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private final FoxResponse svmUri(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        String string = foxRequest.getString("platformId");
        String string2 = this.getServerSedonaEnv().platformDb().getSvmUri(string);
        foxResponse.add("uri", string2);
        return foxResponse;
    }

    public void installPar(ZipInputStream zipInputStream) {
        try {
            FoxRequest foxRequest = this.makeRequest("installPar");
            Buf buf = new Buf();
            ZipOutputStream zipOutputStream = new ZipOutputStream(buf.getOutputStream());
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                zipOutputStream.putNextEntry(zipEntry);
                FileUtil.pipe((InputStream)zipInputStream, (OutputStream)zipOutputStream);
                zipInputStream.closeEntry();
                zipOutputStream.closeEntry();
                zipEntry = zipInputStream.getNextEntry();
            }
            zipInputStream.close();
            zipOutputStream.close();
            foxRequest.add("par", buf.trim());
            this.sendSync(foxRequest);
        }
        catch (Exception exception) {
            throw new PlatformDbException((Throwable)exception);
        }
    }

    private final FoxResponse installPar(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        Buf buf = new Buf(foxRequest.getBlob("par"));
        buf.seek(0);
        this.getServerSedonaEnv().platformDb().installPar(new ZipInputStream(buf.getInputStream()));
        return foxResponse;
    }

    public void extractPar(String string, File file) {
        FoxRequest foxRequest = this.makeRequest("extractPar");
        foxRequest.add("id", string);
        try {
            FoxResponse foxResponse = this.sendSync(foxRequest);
            new Buf(foxResponse.getBlob("par")).writeTo(file);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final FoxResponse extractPar(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        String string = foxRequest.getString("id");
        File file = File.createTempFile(string, ".par");
        try {
            sedonaEnv.platformDb().extractPar(string, file);
            foxResponse.add("par", Buf.readFrom((File)file).trim());
            FoxResponse foxResponse2 = foxResponse;
            Object var7_7 = null;
            if (!file.delete()) {
                file.deleteOnExit();
            }
            return foxResponse2;
        }
        catch (Throwable throwable) {
            block3: {
                Object var7_8 = null;
                if (file.delete()) break block3;
                file.deleteOnExit();
            }
            throw throwable;
        }
    }

    public File build(XElem xElem, CompilerLog compilerLog) throws Exception {
        long l;
        FoxRequest foxRequest = this.makeRequest("build");
        Buf buf = new Buf();
        XWriter xWriter = new XWriter(buf.getOutputStream());
        xElem.write(xWriter);
        xWriter.close();
        String string = null;
        String string2 = null;
        if ("sedonaApp".equals(xElem.name())) {
            foxRequest.add("type", "app");
            string = "app-";
            string2 = ".sab";
        } else if ("sedonaCode".equals(xElem.name())) {
            foxRequest.add("type", "scode");
            string = "kits-";
            string2 = ".scode";
        } else {
            throw new UnsupportedOperationException("Don't know how to build: " + xElem.name());
        }
        compilerLog.out.println("Compiling remotely. This could take a few minutes...");
        foxRequest.add("xml", new String(buf.trim()));
        FoxResponse foxResponse = this.sendSync(foxRequest);
        String string3 = foxResponse.getString("buildId", null);
        if (string3 == null) {
            throw new Exception("Remote host did not return a build id.");
        }
        FoxRequest foxRequest2 = this.makeRequest("pollBuild");
        foxRequest2.add("buildId", string3);
        long l2 = l = System.currentTimeMillis();
        long l3 = 3000L;
        while ((foxResponse = this.sendSync(foxRequest2)).getBlob("result", null) == null) {
            long l4 = System.currentTimeMillis();
            long l5 = l4 - l;
            long l6 = l4 - l2;
            if (l6 > 10000L) {
                compilerLog.out.println("  Still compiling...");
                l2 = l4;
            }
            if (l5 > 240000L) {
                throw new Exception("The build is taking a long time. Terminating provisioning");
            }
            Thread.sleep(l3);
        }
        File file = File.createTempFile(string, string2);
        new Buf(foxResponse.getBlob("result")).writeTo(file);
        compilerLog.out.print(foxResponse.getString("log"));
        return file;
    }

    private final FoxResponse build(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        XElem xElem = XParser.make((String)"", (String)foxRequest.getString("xml")).parse();
        String string = foxRequest.getString("type");
        BuildThread buildThread = new BuildThread(xElem, string);
        this.buildMap.put(buildThread.buildId, buildThread);
        buildThread.start();
        foxResponse.add("buildId", buildThread.buildId.encodeToString());
        return foxResponse;
    }

    private final FoxResponse pollBuild(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        BUuid bUuid = BUuid.make((String)foxRequest.getString("buildId"));
        BuildThread buildThread = (BuildThread)this.buildMap.get(bUuid);
        if (!buildThread.isAlive()) {
            foxResponse = buildThread.makeResponse(foxRequest);
            this.buildMap.remove(bUuid);
        }
        return foxResponse;
    }

    public String[] kits() {
        String[] stringArray = new String[]{};
        FoxRequest foxRequest = this.makeRequest("kits");
        try {
            stringArray = this.sendSync(foxRequest).listStrings("k");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringArray;
    }

    private final FoxResponse kits(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        String[] stringArray = sedonaEnv.kitDb().kits();
        int n = 0;
        while (n < stringArray.length) {
            foxResponse.add("k", stringArray[n]);
            ++n;
        }
        return foxResponse;
    }

    public KitDb.KitSummary[] listKits(String string) throws Exception {
        FoxRequest foxRequest = this.makeRequest("listKits");
        foxRequest.add("kit", string);
        FoxResponse foxResponse = this.sendSync(foxRequest);
        FoxTuple[] foxTupleArray = foxResponse.list("k");
        KitDb.KitSummary[] kitSummaryArray = new Summary[foxTupleArray.length];
        int n = 0;
        while (n < foxTupleArray.length) {
            kitSummaryArray[n] = new Summary((FoxMessage)foxTupleArray[n]);
            ++n;
        }
        return kitSummaryArray;
    }

    private final FoxResponse listKits(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        KitDb.KitSummary[] kitSummaryArray = sedonaEnv.kitDb().list(foxRequest.getString("kit"));
        int n = 0;
        while (n < kitSummaryArray.length) {
            FoxMessage foxMessage = new FoxMessage();
            KitDb.KitSummary kitSummary = kitSummaryArray[n];
            foxMessage.add("n", kitSummary.name());
            foxMessage.add("c", kitSummary.checksum());
            foxMessage.add("v", kitSummary.version().toString());
            foxMessage.add("hn", kitSummary.hasNatives());
            foxMessage.add("b", kitSummary.buildTime());
            Depend[] dependArray = kitSummary.depends();
            int n2 = 0;
            while (n2 < dependArray.length) {
                foxMessage.add("d", dependArray[n2].toString());
                ++n2;
            }
            foxResponse.add("k", foxMessage);
            ++n;
        }
        return foxResponse;
    }

    public boolean extractKit(Depend depend, OutputStream outputStream) throws Exception {
        FoxRequest foxRequest = this.makeRequest("extractKit");
        foxRequest.add("depend", depend.toString());
        FoxResponse foxResponse = this.sendSync(foxRequest);
        byte[] byArray = foxResponse.getBlob("kit", null);
        if (byArray == null) {
            return false;
        }
        outputStream.write(byArray, 0, byArray.length);
        return true;
    }

    private final FoxResponse extractKit(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        Depend depend = Depend.parse((String)foxRequest.getString("depend"));
        Buf buf = new Buf();
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        if (sedonaEnv.kitDb().extractKit(depend, buf.getOutputStream())) {
            foxResponse.add("kit", buf.trim());
        }
        return foxResponse;
    }

    private final FoxRequest kitrequest(String string, String string2, int n, Version version) {
        FoxRequest foxRequest = this.makeRequest(string);
        foxRequest.add("kitName", string2);
        foxRequest.add("checksum", n);
        foxRequest.add("version", version.toString());
        return foxRequest;
    }

    public void installKit(String string, int n, Version version, InputStream inputStream) throws Exception {
        FoxRequest foxRequest = this.kitrequest("installKit", string, n, version);
        Buf buf = new Buf();
        FileUtil.pipe((InputStream)inputStream, (OutputStream)buf.getOutputStream());
        foxRequest.add("kit", buf.trim());
        this.sendSync(foxRequest);
    }

    private final FoxResponse installKit(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        String string = foxRequest.getString("kitName");
        int n = foxRequest.getInt("checksum");
        Version version = new Version(foxRequest.getString("version"));
        Buf buf = new Buf(foxRequest.getBlob("kit"));
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        sedonaEnv.kitDb().installKit(string, n, version, buf.getInputStream());
        return foxResponse;
    }

    public KitManifest extractManifest(KitPart kitPart) {
        block3: {
            FoxRequest foxRequest = this.makeRequest("extractManifest");
            foxRequest.add("part", kitPart.key);
            try {
                FoxResponse foxResponse = this.sendSync(foxRequest);
                String string = foxResponse.getString("manifest", null);
                if (string != null) {
                    return KitManifest.fromXml((XElem)XParser.make((String)"manifest", (String)string).parse());
                }
            }
            catch (Exception exception) {
                if (!log.isTraceOn()) break block3;
                log.trace("failed to extract " + kitPart, (Throwable)exception);
            }
        }
        return null;
    }

    private final FoxResponse extractManifest(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        SedonaEnv sedonaEnv = this.getServerSedonaEnv();
        KitManifest kitManifest = sedonaEnv.manifestDb().extractManifest(KitPart.parse((String)foxRequest.getString("part")));
        if (kitManifest != null) {
            Buf buf = new Buf();
            XWriter xWriter = new XWriter(buf.getOutputStream());
            kitManifest.encodeXml(xWriter);
            xWriter.close();
            foxResponse.add("manifest", new String(buf.trim()));
        }
        return foxResponse;
    }

    public boolean installManifest(KitManifest kitManifest) {
        FoxRequest foxRequest = this.makeRequest("installManifest");
        Buf buf = new Buf();
        XWriter xWriter = new XWriter(buf.getOutputStream());
        kitManifest.encodeXml(xWriter);
        xWriter.close();
        foxRequest.add("manifest", buf.trim());
        try {
            return this.sendSync(foxRequest).getBoolean("success", false);
        }
        catch (Exception exception) {
            if (log.isTraceOn()) {
                log.trace("failed to install kit manifest: " + kitManifest, (Throwable)exception);
            }
            return false;
        }
    }

    private final FoxResponse installManifest(FoxRequest foxRequest) throws Exception {
        FoxResponse foxResponse = new FoxResponse(foxRequest);
        Buf buf = new Buf(foxRequest.getBlob("manifest"));
        foxResponse.add("success", this.getServerSedonaEnv().manifestDb().installManifest(buf.getInputStream()));
        return foxResponse;
    }

    private final SedonaEnv getServerSedonaEnv() {
        return new LocalSedonaEnv();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.buildMap = new HashMap();
    }

    public BFoxSedonaEnvChannel() {
        super(Channel);
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$BFoxSedonaEnvChannel;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$BFoxSedonaEnvChannel = BFoxSedonaEnvChannel.class("[Lcom.tridium.sedonanet.BFoxSedonaEnvChannel;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        log = Log.getLog((String)"sedona.foxenv");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class BuildThread
    extends Thread {
        final BUuid buildId;
        final XElem def;
        final String type;
        final BufCompilerLog log;
        File result;
        Exception xErr;

        public void run() {
            block4: {
                this.result = null;
                try {
                    if ("app".equals(this.type)) {
                        this.result = BFoxSedonaEnvChannel.this.getServerSedonaEnv().buildApp(this.def, (CompilerLog)this.log);
                        break block4;
                    }
                    if ("scode".equals(this.type)) {
                        this.result = BFoxSedonaEnvChannel.this.getServerSedonaEnv().buildScode(this.def, (CompilerLog)this.log);
                        break block4;
                    }
                    throw new UnsupportedOperationException("Don't know how to build " + this.type);
                }
                catch (Exception exception) {
                    this.xErr = exception;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public FoxResponse makeResponse(FoxRequest foxRequest) throws Exception {
            FoxResponse foxResponse;
            block3: {
                if (this.xErr != null) {
                    throw this.xErr;
                }
                try {
                    FoxResponse foxResponse2 = new FoxResponse(foxRequest);
                    foxResponse2.add("result", Buf.readFrom((File)this.result).trim());
                    foxResponse2.add("log", this.log.getLogString());
                    foxResponse = foxResponse2;
                    Object var3_4 = null;
                    if (this.result == null) break block3;
                    this.result.delete();
                }
                catch (Throwable throwable) {
                    block4: {
                        Object var3_5 = null;
                        if (this.result == null) break block4;
                        this.result.delete();
                    }
                    throw throwable;
                }
            }
            return foxResponse;
        }

        private final /* synthetic */ void this() {
            this.buildId = BUuid.make();
            this.log = new BufCompilerLog();
        }

        public BuildThread(XElem xElem, String string) {
            this.this();
            this.def = xElem;
            this.type = string;
            this.setName("BuildThread: " + this.buildId);
        }
    }

    private static class Summary
    extends KitDb.KitSummary {
        private final String name;
        private final int checksum;
        private final Version version;
        private final Depend[] depends;
        private final boolean hasNatives;
        private final long buildTime;

        public String name() {
            return this.name;
        }

        public int checksum() {
            return this.checksum;
        }

        public Version version() {
            return this.version;
        }

        public Depend[] depends() {
            return this.depends;
        }

        public boolean hasNatives() {
            return this.hasNatives;
        }

        public long buildTime() {
            return this.buildTime;
        }

        public Summary(FoxMessage foxMessage) throws Exception {
            this.name = foxMessage.getString("n");
            this.checksum = foxMessage.getInt("c");
            this.version = new Version(foxMessage.getString("v"));
            this.hasNatives = foxMessage.getBoolean("hn");
            this.buildTime = foxMessage.getTime("b");
            String[] stringArray = foxMessage.listStrings("d");
            this.depends = new Depend[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                this.depends[n] = Depend.parse((String)stringArray[n]);
                ++n;
            }
        }
    }
}

