/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver;

import com.tridium.nsedona.dasp.DiscoveryDaspSocket;
import com.tridium.nsedona.dasp.HostDaspSocketInterface;
import com.tridium.sedonanet.chopan.BChopanServer;
import com.tridium.sedonanet.driver.BDaspInterfaceInfo;
import com.tridium.sedonanet.driver.BSedonaAddress;
import com.tridium.sedonanet.driver.BSedonaBaseNetwork;
import com.tridium.sedonanet.driver.BSedonaDevice;
import com.tridium.sedonanet.driver.BSedonaDeviceDiscoveryConfig;
import com.tridium.sedonanet.driver.BSedonaDeviceFolder;
import com.tridium.sedonanet.driver.BSedonaLearnDeviceEntry;
import com.tridium.sedonanet.driver.BSedonaLearnDevicesJob;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import sedona.dasp.DaspSocketInterface;
import sedona.dasp.DiscoveredNode;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSedonaNetwork
extends BSedonaBaseNetwork
implements BIService {
    public static final Property chopanServer = BSedonaNetwork.newProperty((int)5, (BValue)new BChopanServer(false), null);
    public static final Action initializeDeviceDiscoveryConfig = BSedonaNetwork.newAction((int)4, null);
    public static final Type TYPE;
    private DiscoveryDaspSocket dds;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BSedonaNetwork;
    static /* synthetic */ Class class$com$tridium$sedonanet$driver$BSedonaLearnDeviceEntry;

    public BSedonaDeviceDiscoveryConfig initializeDeviceDiscoveryConfig() {
        return (BSedonaDeviceDiscoveryConfig)this.invoke(initializeDeviceDiscoveryConfig, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public Type getDeviceType() {
        return BSedonaDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BSedonaDeviceFolder.TYPE;
    }

    public Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "sedonanet");
    }

    public void spy(SpyWriter spyWriter) throws Exception {
        super.spy(spyWriter);
        spyWriter.startProps("SedonaNetwork");
        if (this.dds != null) {
            spyWriter.trTitle((Object)"Discovered Devices", 2);
            DiscoveredNode[] discoveredNodeArray = this.dds.getDiscovered();
            int n = 0;
            while (n < discoveredNodeArray.length) {
                spyWriter.tr((Object)("" + n), (Object)discoveredNodeArray[n]);
                ++n;
            }
        }
        spyWriter.endProps();
    }

    public boolean isDeviceDiscoverySupported() {
        return true;
    }

    public BSedonaDeviceDiscoveryConfig doInitializeDeviceDiscoveryConfig() throws Exception {
        if (this.isFatalFault()) {
            return null;
        }
        try {
            this.dds = DiscoveryDaspSocket.openForDiscovery((int)18760);
            BSedonaDeviceDiscoveryConfig bSedonaDeviceDiscoveryConfig = new BSedonaDeviceDiscoveryConfig();
            DaspSocketInterface[] daspSocketInterfaceArray = this.dds.interfaces();
            int n = 0;
            while (n < daspSocketInterfaceArray.length) {
                HostDaspSocketInterface hostDaspSocketInterface = (HostDaspSocketInterface)daspSocketInterfaceArray[n];
                BDaspInterfaceInfo bDaspInterfaceInfo = new BDaspInterfaceInfo(hostDaspSocketInterface.getName(), hostDaspSocketInterface.getIp(), hostDaspSocketInterface.isIPv6());
                bSedonaDeviceDiscoveryConfig.add("interface?", (BValue)bDaspInterfaceInfo);
                ++n;
            }
            return bSedonaDeviceDiscoveryConfig;
        }
        catch (Exception exception) {
            this.getLog().message("Sedona Device Discovery Initialization failed:" + exception, (Throwable)exception);
            throw exception;
        }
    }

    public BOrd doSubmitDeviceDiscoveryJob(BSedonaDeviceDiscoveryConfig bSedonaDeviceDiscoveryConfig, Context context) {
        if (this.isFatalFault()) {
            return null;
        }
        if (this.dds == null) {
            return null;
        }
        BOrd bOrd = new BSedonaLearnDevicesJob(this.dds, bSedonaDeviceDiscoveryConfig, this).submit(context);
        return bOrd;
    }

    public BSedonaLearnDeviceEntry[] getDiscoveredDevices() throws Exception {
        if (this.dds != null) {
            Class clazz = class$com$tridium$sedonanet$driver$BSedonaLearnDeviceEntry;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$driver$BSedonaLearnDeviceEntry = BSedonaNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaLearnDeviceEntry;", false);
            }
            Array array = new Array(clazz);
            DiscoveredNode[] discoveredNodeArray = this.dds.getDiscovered();
            int n = 0;
            while (n < discoveredNodeArray.length) {
                array.add((Object)new BSedonaLearnDeviceEntry(new BSedonaAddress(discoveredNodeArray[n].addr().getHostAddress(), this.dds.getTargetPort()), discoveredNodeArray[n].platformId()));
                ++n;
            }
            return (BSedonaLearnDeviceEntry[])array.trim();
        }
        return null;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.dds = null;
    }

    public BSedonaNetwork() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$driver$BSedonaNetwork;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$driver$BSedonaNetwork = BSedonaNetwork.class("[Lcom.tridium.sedonanet.driver.BSedonaNetwork;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }
}

