/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.driver.comm;

import com.tridium.sedonanet.driver.BSedonaBaseDevice;
import com.tridium.sedonanet.driver.comm.SedByteArrayUtil;
import java.io.EOFException;
import java.io.IOException;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import sedona.Buf;

public class SoxMessage
extends Buf {
    public static final int voidId = 0;
    public static final int boolId = 1;
    public static final int byteId = 2;
    public static final int shortId = 3;
    public static final int intId = 4;
    public static final int longId = 5;
    public static final int floatId = 6;
    public static final int doubleId = 7;
    public static final int bufId = 8;
    public static final int errorId = 255;
    public static final int MAX_PACKET_SIZE = 512;
    public BSedonaBaseDevice device;

    public static SoxMessage make(BSedonaBaseDevice bSedonaBaseDevice, byte[] byArray, int n) {
        SoxMessage soxMessage = new SoxMessage(byArray, n);
        soxMessage.device = bSedonaBaseDevice;
        return soxMessage;
    }

    public static SoxMessage make(int n) {
        SoxMessage soxMessage = new SoxMessage();
        soxMessage.u1(n);
        soxMessage.u1(99);
        return soxMessage;
    }

    public static SoxMessage makeResponse(SoxMessage soxMessage) {
        SoxMessage soxMessage2 = new SoxMessage();
        soxMessage2.u1(Character.toUpperCase((char)soxMessage.getCommand()));
        soxMessage2.u1(soxMessage.getReplyNum());
        return soxMessage2;
    }

    public BSimple readValue() throws IOException {
        return this.readValue(this.read());
    }

    public BSimple readValue(int n) throws IOException {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return BBoolean.make((boolean)this.bool());
            }
            case 2: {
                return BDouble.make((double)this.u1());
            }
            case 3: {
                return BDouble.make((double)this.u2());
            }
            case 4: {
                return BDouble.make((double)this.i4());
            }
            case 5: {
                return BDouble.make((double)this.i8());
            }
            case 6: {
                return BDouble.make((double)this.f4());
            }
            case 7: {
                return BDouble.make((double)this.f8());
            }
            case 8: {
                int n2 = this.u2();
                if (n2 == 0) {
                    return BString.DEFAULT;
                }
                return BString.make((String)this.str(n2));
            }
        }
        throw new IllegalStateException("Unknown value type " + (char)n);
    }

    public String str(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.u1();
                if (n3 == 0) {
                    bl = true;
                }
                if (!bl) {
                    stringBuffer.append((char)n3);
                }
                ++n2;
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Found fewer than " + n + " bytes, got partial string '" + stringBuffer.toString() + '\'');
            eOFException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public void writeValue(BSimple bSimple, int n) throws IOException {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.bool(((BBoolean)bSimple).getBoolean());
                break;
            }
            case 2: {
                this.u1((int)((BDouble)bSimple).getDouble());
                break;
            }
            case 3: {
                this.u2((int)((BDouble)bSimple).getDouble());
                break;
            }
            case 4: {
                this.i4((int)((BDouble)bSimple).getDouble());
                break;
            }
            case 5: {
                this.i8((long)((BDouble)bSimple).getDouble());
                break;
            }
            case 6: {
                this.f4((float)((BDouble)bSimple).getDouble());
                break;
            }
            case 7: {
                this.f8(((BDouble)bSimple).getDouble());
                break;
            }
            case 8: {
                String string = ((BString)bSimple).getString();
                this.u2(string.length() + 1);
                this.str(string);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown value type " + (char)n);
            }
        }
    }

    void setReplyNum(int n) {
        if (n > 255) {
            throw new IllegalStateException();
        }
        this.bytes[1] = (byte)(n & 0xFF);
    }

    int getReplyNum() {
        return this.bytes[1] & 0xFF;
    }

    public boolean isRequest() {
        boolean bl = false;
        if (this.bytes[0] >= 97 && this.bytes[0] <= 122) {
            bl = true;
        }
        return bl;
    }

    public boolean isFailed() {
        boolean bl = false;
        if (this.bytes[0] == 33) {
            bl = true;
        }
        return bl;
    }

    public int getCommand() {
        return this.bytes[0];
    }

    public String toString() {
        String string = this.device == null ? "null" : this.device.toPathString();
        return "SoxMessage [device=" + string + ']' + SedByteArrayUtil.toString(this.bytes, this.size);
    }

    private SoxMessage() {
        super(512);
    }

    private SoxMessage(byte[] byArray, int n) {
        super(n);
        System.arraycopy(byArray, 0, this.bytes, 0, n);
        this.size = n;
    }
}

