/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.migrate;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.LinkedList;
import javax.baja.file.FileUtil;
import javax.baja.io.ValueDocDecoder;
import javax.baja.io.ValueDocEncoder;
import javax.baja.log.Log;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.util.TextUtil;
import javax.baja.xml.XContent;
import javax.baja.xml.XElem;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class MigrateBog {
    protected final File input;
    protected final File stubbed;
    static /* synthetic */ Class class$java$io$File;

    public final void convert() throws Exception {
        this.log("\nMigrating " + this.input.getAbsolutePath() + " ...");
        this.stubBog();
        this.migrateBog();
    }

    protected void log(String string) {
        System.out.println(string);
    }

    private final void stubBog() throws Exception {
        XElem xElem = ((ValueDocDecoder.BogElement)new ValueDocDecoder(this.input).parse()).getXmlElement();
        LinkedList<XElem> linkedList = new LinkedList<XElem>();
        linkedList.add(xElem);
        while (!linkedList.isEmpty()) {
            XElem xElem2 = (XElem)linkedList.removeFirst();
            this.stub(xElem2);
            XElem[] xElemArray = xElem2.elems();
            int n = 0;
            while (n < xElemArray.length) {
                linkedList.add(xElemArray[n]);
                ++n;
            }
        }
        xElem.write(this.stubbed);
    }

    private final void stub(XElem xElem) throws Exception {
        String string = xElem.get("t", null);
        if (string == null) {
            return;
        }
        String[] stringArray = TextUtil.split((String)string, (char)':');
        if ("sn".equals(stringArray[0])) {
            if ("SedonaNetwork".equals(stringArray[1])) {
                this.stubSedonaNetwork(xElem);
                this.stubSedonaNetworkFolders(xElem);
            } else if (this.isSedonaDevice(stringArray)) {
                this.stubSedonaDevice(xElem);
                this.migrateDeviceAddress(xElem);
            } else if ("SedonaTuningPolicy".equals(stringArray[1])) {
                this.migrateTuningPolicy(xElem);
            } else if (!this.stubMiscNSedona(xElem, stringArray[1])) {
                xElem.setAttr("m", "nsed=nsedona");
                xElem.setAttr("t", "nsed:" + stringArray[1]);
            }
        } else {
            this.doStub(xElem, stringArray[0], stringArray[1]);
        }
    }

    protected void stubSedonaNetwork(XElem xElem) {
        xElem.setAttr("m", "sn=sedonanet");
        xElem.setAttr("t", "sn:SedonaNetwork");
    }

    private final boolean stubSedonaNetworkFolders(XElem xElem) {
        String string = xElem.get("t", null);
        if (string == null) {
            return false;
        }
        String[] stringArray = TextUtil.split((String)string, (char)':');
        XElem[] xElemArray = xElem.elems();
        boolean bl = false;
        int n = 0;
        while (n < xElemArray.length) {
            bl |= this.stubSedonaNetworkFolders(xElemArray[n]);
            ++n;
        }
        if ("b".equals(stringArray[0]) && ("Folder".equals(stringArray[1]) || "UnrestrictedFolder".equals(stringArray[1])) && bl) {
            this.stubSedonaNetworkFolder(xElem);
        }
        boolean bl2 = false;
        if (bl || this.isSedonaDevice(stringArray)) {
            bl2 = true;
        }
        return bl2;
    }

    private final boolean isSedonaDevice(String[] stringArray) {
        boolean bl = false;
        if ("sn".equals(stringArray[0]) && "SedonaDevice".equals(stringArray[1])) {
            bl = true;
        }
        return bl;
    }

    protected void stubSedonaNetworkFolder(XElem xElem) {
        xElem.setAttr("m", "sn=sedonanet");
        xElem.setAttr("t", "sn:SedonaDeviceFolder");
    }

    protected void stubSedonaDevice(XElem xElem) {
        xElem.setAttr("m", "sn=sedonanet");
        xElem.setAttr("t", "sn:SedonaDevice");
    }

    protected void migrateDeviceAddress(XElem xElem) {
        XElem[] xElemArray = xElem.elems("p");
        int n = 0;
        while (n < xElemArray.length) {
            if ("address".equals(xElemArray[n].get("n"))) {
                XElem xElem2 = xElemArray[n];
                String[] stringArray = TextUtil.split((String)xElem2.get("v"), (char)':');
                xElem2.removeAttr("v");
                xElem2.addContent((XContent)new XElem("p").addAttr("n", "ip").addAttr("v", stringArray[0])).addContent((XContent)new XElem("p").addAttr("n", "soxPort").addAttr("v", stringArray[1]));
                break;
            }
            ++n;
        }
    }

    protected void migrateTuningPolicy(XElem xElem) {
        XElem[] xElemArray = xElem.elems("p");
        int n = 0;
        while (n < xElemArray.length) {
            if ("pointComm".equals(xElemArray[n].get("n"))) {
                XElem xElem2 = xElemArray[n];
                xElem2.setAttr("n", "commType");
                xElem2.removeAttr("t");
                int n2 = Integer.parseInt(xElem2.get("v").substring(0, 1));
                switch (n2) {
                    case 0: {
                        xElem2.setAttr("v", "soxEvent");
                        break;
                    }
                    case 1: {
                        xElem2.setAttr("v", "chopan");
                        break;
                    }
                    case 2: {
                        xElem2.setAttr("v", "soxPolled");
                        break;
                    }
                    default: {
                        xElem2.setAttr("v", "soxEvent");
                        break;
                    }
                }
                break;
            }
            ++n;
        }
    }

    protected boolean stubMiscNSedona(XElem xElem, String string) {
        if ("SedonaDeviceFolder".equals(string) || "SedonaTuningPolicyMap".equals(string) || "SedonaPollScheduler".equals(string) || "SedonaCommConfig".equals(string) || "SedonaPointDeviceExt".equals(string) || "SedonaProxyExt".equals(string)) {
            xElem.setAttr("m", "sn=sedonanet");
            xElem.setAttr("t", "sn:" + string);
            return true;
        }
        return false;
    }

    protected void doStub(XElem xElem, String string, String string2) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void migrateBog() throws Exception {
        BComponent bComponent = new ValueDocDecoder(this.stubbed).decodeDocument().asComponent();
        this.scanStubbedStation(bComponent);
        this.doMigration();
        File file = this.input.getParentFile();
        File file2 = new File(file, "preMigrate_" + this.input.getName());
        FileUtil.move((File)this.input, (File)file2);
        this.log("Backed up original bog as: " + file2.getAbsolutePath());
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(this.input);
        valueDocEncoder.setZipped(true);
        try {
            valueDocEncoder.encodeDocument((BValue)bComponent);
            this.log("Success! Migrated bog: " + this.input.getAbsolutePath());
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            valueDocEncoder.close();
            throw throwable;
        }
        {
            Object var6_7 = null;
        }
        valueDocEncoder.close();
    }

    private final void scanStubbedStation(BComponent bComponent) {
        LinkedList<BComponent> linkedList = new LinkedList<BComponent>();
        linkedList.add(bComponent);
        while (!linkedList.isEmpty()) {
            BComponent bComponent2 = (BComponent)linkedList.removeFirst();
            if (this.scanned(bComponent2)) break;
            BComponent[] bComponentArray = bComponent2.getChildComponents();
            int n = 0;
            while (n < bComponentArray.length) {
                linkedList.add(bComponentArray[n]);
                ++n;
            }
        }
        linkedList.clear();
    }

    protected boolean scanned(BComponent bComponent) {
        return true;
    }

    protected void doMigration() throws Exception {
    }

    public static void main(String[] stringArray) throws Exception {
        try {
            if (stringArray.length == 0) {
                MigrateBog.usage("Missing bog file argument");
            }
            MigrateBog.migrate(new File(stringArray[0]));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(2);
        }
        System.exit(0);
    }

    public static void usage(String string) {
        if (string != null) {
            System.err.println("ERROR: " + string);
        }
        System.out.println("  MigrateBog <bog>\n");
        System.exit(1);
    }

    private static final void migrate(File file) throws Exception {
        Object object;
        Object object2;
        Object object3;
        XElem xElem = ((ValueDocDecoder.BogElement)new ValueDocDecoder(file).parse()).getXmlElement();
        LinkedList<XElem> linkedList = new LinkedList<XElem>();
        linkedList.add(xElem);
        boolean bl = false;
        while (!linkedList.isEmpty()) {
            object3 = (XElem)linkedList.removeFirst();
            object2 = object3.get("t", null);
            if (object2 != null && "jennic".equals((object = TextUtil.split((String)object2, (char)':'))[0]) && "Jennic6LowpanBridgeService".equals(object[1])) {
                bl = true;
                break;
            }
            object = object3.elems();
            int n = 0;
            while (n < ((XElem[])object).length) {
                linkedList.add(object[n]);
                ++n;
            }
        }
        object3 = null;
        if (bl) {
            object2 = Sys.loadClass((String)"jen6lp", (String)"com.tridium.jen6lp.migrate.MigrateJen6lpBog");
            if (object2 == null) {
                System.err.println("Cannot migrate jennic bog files");
                System.exit(3);
            }
            Class[] classArray = new Class[1];
            Class clazz = class$java$io$File;
            if (clazz == null) {
                clazz = class$java$io$File = MigrateBog.class("[Ljava.io.File;", false);
            }
            classArray[0] = clazz;
            object = ((Class)object2).getConstructor(classArray);
            object3 = (MigrateBog)((Constructor)object).newInstance(file);
            System.out.println("\n** Converting Sedona network to Jen6lp Sedona network **");
        } else {
            object3 = new MigrateBog(file);
        }
        ((MigrateBog)object3).convert();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public MigrateBog(File file) {
        this.input = file;
        this.stubbed = new File(file.getParentFile(), "stub_" + file.getName());
        this.stubbed.deleteOnExit();
        Log.getLog((String)"sys.xml").setSeverity(3);
    }
}

