/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sedonanet.ui.manifest;

import com.tridium.sedonanet.ui.manifest.BManifestManager;
import com.tridium.sedonanet.ui.manifest.Db;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.XmlParser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;
import sedona.Env;
import sedona.KitPart;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BManifestBrowser
extends BSplitPane {
    public static final Type TYPE;
    private static final File dir;
    static final BImage viewIcon;
    static final BImage syncIcon;
    public static final File kitdir;
    public static final Lexicon lex;
    public SelectionListener selectionListener;
    Db db;
    Db other;
    BList kitList;
    KitModel kitModel;
    BList manifestList;
    ManifestModel manifestModel;
    BTextField kitFilter;
    BTextField manifestFilter;
    static /* synthetic */ Class class$com$tridium$sedonanet$ui$manifest$BManifestBrowser;
    static /* synthetic */ Class class$com$tridium$sedonanet$ui$manifest$Db$Manifest;

    public Type getType() {
        return TYPE;
    }

    BWidget makePane(String string, BTextField bTextField, BList bList, String string2) {
        BImage bImage = BImage.make((String)"module://icons/x16/filter.png");
        BImage bImage2 = BImage.make((String)"module://icons/x16/clear.png");
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("c", (Command)new ReflectCommand((BWidget)this, "Clear filter", bImage2, string2));
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnCount(3);
        bGridPane.setStretchColumn(1);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.add(null, (BValue)new BBorderPane((BWidget)new BLabel(bImage), 0.0, (double)4, 0.0, 0.0));
        bGridPane.add(null, (BValue)bTextField);
        bGridPane.add(null, (BValue)bToolBar);
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BLabel(string));
        bEdgePane.setBottom((BWidget)bGridPane);
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setTop((BWidget)new BBorderPane((BWidget)bEdgePane, 10.0, (double)2, 10.0, (double)2));
        bEdgePane2.setCenter((BWidget)bList);
        return bEdgePane2;
    }

    public void clearKitFilter() {
        this.kitFilter.setText("");
    }

    public void clearManifestFilter() {
        this.manifestFilter.setText("");
    }

    public int getSelectionCount() {
        return this.manifestList.getSelection().getItemCount();
    }

    public Db.Manifest[] getSelection() {
        Object[] objectArray = this.manifestList.getSelectedItems();
        Db.Manifest[] manifestArray = new Db.Manifest[objectArray.length];
        System.arraycopy(objectArray, 0, manifestArray, 0, manifestArray.length);
        return manifestArray;
    }

    public void changeDb(Db db) {
        if (this.db == db) {
            return;
        }
        this.db = db;
        this.kitModel.rebuild();
    }

    static boolean accept(String string, String string2) {
        boolean bl = false;
        if (string2.indexOf(string) >= 0) {
            bl = true;
        }
        return bl;
    }

    private final boolean noKitDir(BWidget bWidget) {
        if (!kitdir.exists()) {
            BDialog.error((BWidget)bWidget, (String)lex.getText("ManifestManager.genFromKits.title"), (Object)lex.getText("ManifestManager.genFromKits.noKitDir"));
            return true;
        }
        return false;
    }

    private final void generateManifests(Object[] objectArray, BWidget bWidget) {
        String string = "Manifests generated for kits:";
        try {
            int n = 0;
            while (n < objectArray.length) {
                Db.Kit kit = (Db.Kit)objectArray[n];
                string = this.generateForKit(kit) ? string + '\n' + kit.name + " - ok" : string + '\n' + kit.name + " - FAILED";
                ++n;
            }
        }
        catch (Exception exception) {
            BDialog.error((BWidget)bWidget, (String)lex.getText("ManifestManager.genFromKits.title"), (Object)lex.getText("ManifestManager.genFromKits.exception"), (Throwable)exception);
        }
        BDialog.message((BWidget)bWidget, (Object)string);
        this.db.reload();
        this.kitModel.rebuild(false);
    }

    Db.Kit[] buildAllKits() {
        File[] fileArray = kitdir.listFiles();
        Db.Kit[] kitArray = new Db.Kit[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            kitArray[n] = new Db.Kit(this.db, fileArray[n].getName());
            ++n;
        }
        return kitArray;
    }

    boolean generateForKit(Db.Kit kit) throws Exception {
        boolean bl = true;
        int n = kit.name.length();
        File file = new File(kitdir, kit.name);
        if (!file.exists() || !file.isDirectory()) {
            return false;
        }
        File[] fileArray = file.listFiles(new KitFilter());
        int n2 = 0;
        while (n2 < fileArray.length) {
            File file2;
            String string = fileArray[n2].getName();
            int n3 = (int)Long.parseLong(string.substring(n + 1, string.indexOf("-", n + 2)), 16);
            KitManifest kitManifest = ManifestDb.load((KitPart)new KitPart(kit.name, n3));
            boolean bl2 = false;
            if (kitManifest != null) {
                bl2 = true;
            }
            bl &= bl2;
            if (kitManifest != null && !(file2 = new File(dir, kitManifest.name + File.separator + kitManifest.name + '-' + kitManifest.checksum + ".xml")).exists()) {
                ManifestDb.save((KitManifest)kitManifest);
            }
            ++n2;
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        BFrame bFrame = new BFrame("ManifestBrowser");
        bFrame.setContent((BWidget)new BManifestBrowser(Db.makeLocal(), null, false));
        bFrame.open(100.0, 100.0, 600.0, 600.0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.kitList = new BList();
        this.kitModel = new KitModel();
        this.manifestList = new BList();
        this.manifestModel = new ManifestModel();
        this.kitFilter = new BTextField("", 4);
        this.manifestFilter = new BTextField("", 4);
    }

    BManifestBrowser(Db db, Db db2, boolean bl) {
        this.this();
        this.db = db;
        this.other = db2;
        this.kitList.setModel((ListModel)this.kitModel);
        this.kitList.setController((ListController)new KitController());
        this.kitList.setSelection((ListSelection)new KitSelection());
        this.kitFilter.setModel(new TextModel(){

            protected final void textModified() {
                super.textModified();
                BManifestBrowser.this.kitModel.rebuild();
            }
        });
        this.manifestList.setModel((ListModel)this.manifestModel);
        this.manifestList.setController((ListController)new ManifestController());
        this.manifestList.setSelection((ListSelection)new ManifestSelection());
        this.manifestFilter.setModel(new TextModel(){

            protected final void textModified() {
                super.textModified();
                BManifestBrowser.this.manifestModel.rebuild();
            }
        });
        this.setWidget1(this.makePane("Manifests", this.kitFilter, this.kitList, "clearKitFilter"));
        this.setWidget2(this.makePane("Checksums", this.manifestFilter, this.manifestList, "clearManifestFilter"));
        if (bl && kitdir.exists()) {
            Db.Kit[] kitArray = this.buildAllKits();
            int n = 0;
            while (n < kitArray.length) {
                try {
                    this.generateForKit(kitArray[n]);
                }
                catch (Exception exception) {}
                ++n;
            }
        }
        this.kitModel.rebuild();
    }

    static {
        Class clazz = class$com$tridium$sedonanet$ui$manifest$BManifestBrowser;
        if (clazz == null) {
            clazz = class$com$tridium$sedonanet$ui$manifest$BManifestBrowser = BManifestBrowser.class("[Lcom.tridium.sedonanet.ui.manifest.BManifestBrowser;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        dir = new File(Env.home, "manifests");
        viewIcon = BImage.make((String)"module://icons/x16/magnifyingGlass.png");
        syncIcon = BImage.make((String)"module://icons/x16/sync.png");
        kitdir = new File(Env.home, "kits");
        lex = Lexicon.make((String)"sedonanet");
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KitModel
    extends ListModel {
        ArrayList filtered;

        public int getItemCount() {
            return this.filtered.size();
        }

        public Object getItem(int n) {
            return this.filtered.get(n);
        }

        void rebuild(boolean bl) {
            String string = BManifestBrowser.this.kitFilter.getText();
            this.filtered.clear();
            Db.Kit[] kitArray = BManifestBrowser.this.db.kits();
            int n = 0;
            while (n < kitArray.length) {
                if (BManifestBrowser.accept(string, kitArray[n].name)) {
                    this.filtered.add(kitArray[n]);
                }
                ++n;
            }
            this.updateList();
            if (bl) {
                BManifestBrowser.this.kitList.getSelection().deselectAll();
            }
            BManifestBrowser.this.manifestModel.rebuild();
        }

        void rebuild() {
            this.rebuild(true);
        }

        private final /* synthetic */ void this() {
            this.filtered = new ArrayList();
        }

        public KitModel() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class KitFilter
    implements FilenameFilter {
        public boolean accept(File file, String string) {
            boolean bl = false;
            if (file.getParentFile().equals(kitdir) && string.endsWith(".kit")) {
                bl = true;
            }
            return bl;
        }

        KitFilter() {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ManifestModel
    extends ListModel {
        ArrayList items;

        public int getItemCount() {
            return this.items.size();
        }

        public Object getItem(int n) {
            return this.items.get(n);
        }

        void rebuild() {
            Object[] objectArray = BManifestBrowser.this.kitList.getSelectedItems();
            String string = BManifestBrowser.this.manifestFilter.getText();
            this.items.clear();
            int n = 0;
            while (n < objectArray.length) {
                Db.Manifest[] manifestArray = ((Db.Kit)objectArray[n]).manifests;
                int n2 = 0;
                while (n2 < manifestArray.length) {
                    if (BManifestBrowser.accept(string, manifestArray[n2].toString())) {
                        this.items.add(manifestArray[n2]);
                    }
                    ++n2;
                }
                ++n;
            }
            this.updateList();
            BManifestBrowser.this.manifestList.getSelection().deselectAll();
        }

        private final /* synthetic */ void this() {
            this.items = new ArrayList();
        }

        public ManifestModel() {
            this.this();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KitController
    extends ListController {
        protected void popup(BMouseEvent bMouseEvent, int n) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new SelectAllCommand(BManifestBrowser.this.kitList));
            bMenu.add(null, (Command)new DeselectAllCommand(BManifestBrowser.this.kitList));
            if (BManifestBrowser.this.db.isLocal()) {
                bMenu.add(null, (Command)new GenerateFromKitsCommand(BManifestBrowser.this.kitList));
                bMenu.add(null, (Command)new GenerateAllCommand(BManifestBrowser.this.kitList));
            }
            if (!BManifestBrowser.this.db.isReadonly()) {
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new DeleteManifest(BManifestBrowser.this.kitList));
            }
            bMenu.open(bMouseEvent);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KitSelection
    extends ListSelection {
        public void updateList() {
            super.updateList();
            BManifestBrowser.this.manifestModel.rebuild();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ManifestController
    extends ListController {
        protected void popup(BMouseEvent bMouseEvent, int n) {
            Db.Manifest manifest = null;
            if (n >= 0) {
                manifest = (Db.Manifest)BManifestBrowser.this.manifestList.getItem(n);
            }
            BMenu bMenu = new BMenu();
            bMenu.add(null, (Command)new SelectMissingCommand((BWidget)BManifestBrowser.this.manifestList));
            bMenu.add(null, (Command)new SelectAllCommand(BManifestBrowser.this.manifestList));
            bMenu.add(null, (Command)new DeselectAllCommand(BManifestBrowser.this.manifestList));
            if (!BManifestBrowser.this.db.isReadonly() && manifest != null) {
                bMenu.add(null, (BValue)new BSeparator());
                bMenu.add(null, (Command)new DeleteManifest(BManifestBrowser.this.manifestList));
            }
            bMenu.add(null, (BValue)new BSeparator());
            bMenu.add(null, (Command)new ViewXmlCommand((BWidget)BManifestBrowser.this.manifestList, manifest));
            bMenu.open(bMouseEvent);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ManifestSelection
    extends ListSelection {
        public void updateList() {
            super.updateList();
            if (BManifestBrowser.this.selectionListener != null) {
                try {
                    BManifestBrowser.this.selectionListener.selectionChanged();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    static interface SelectionListener {
        public void selectionChanged();
    }

    static class Info
    extends KitPart {
        final File file;

        Info(String string, int n) {
            super(string, n);
            this.file = new File(dir, string + File.separator + this.key + ".xml");
        }

        Info(KitManifest kitManifest) {
            this(kitManifest.name, kitManifest.checksum);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ViewXmlCommand
    extends Command {
        Db.Manifest manifest;

        public CommandArtifact doInvoke() throws Exception {
            String string = BManifestBrowser.this.db.read(this.manifest);
            BTextEditorPane bTextEditorPane = new BTextEditorPane("", 40, 80, true);
            bTextEditorPane.getEditor().setParser((TextParser)new XmlParser());
            bTextEditorPane.getEditor().setText(string);
            BDialog.open((BWidget)this.getOwner(), (String)this.manifest.toString(), (Object)bTextEditorPane, (int)1);
            return null;
        }

        ViewXmlCommand(BWidget bWidget, Db.Manifest manifest) {
            super(bWidget, "View XML");
            this.icon = viewIcon;
            this.manifest = manifest;
            if (manifest == null) {
                this.setEnabled(false);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class SelectMissingCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BManifestBrowser.this.manifestList.getSelection().deselectAll();
            int n = 0;
            while (n < BManifestBrowser.this.manifestModel.getItemCount()) {
                Db.Manifest manifest = (Db.Manifest)BManifestBrowser.this.manifestModel.getItem(n);
                if (!BManifestBrowser.this.other.contains(manifest)) {
                    BManifestBrowser.this.manifestList.getSelection().select(n);
                }
                ++n;
            }
            return null;
        }

        SelectMissingCommand(BWidget bWidget) {
            super(bWidget, "Select Missing");
            this.icon = syncIcon;
            if (BManifestBrowser.this.other == null) {
                this.setEnabled(false);
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GenerateFromKitsCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            if (BManifestBrowser.this.noKitDir(this.getOwner())) {
                return null;
            }
            BList bList = (BList)this.getOwner();
            Object[] objectArray = bList.getSelectedItems();
            if (objectArray.length == 0) {
                int n = BDialog.confirm((BWidget)this.getOwner(), (Object)lex.getText("ManifestManager.genFromKits.confirm"));
                if (n == 4) {
                    objectArray = BManifestBrowser.this.buildAllKits();
                } else {
                    return null;
                }
            }
            BManifestBrowser.this.generateManifests(objectArray, this.getOwner());
            return null;
        }

        GenerateFromKitsCommand(BList bList) {
            super((BWidget)bList, lex, "ManifestManager.genFromKits");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class GenerateAllCommand
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            if (BManifestBrowser.this.noKitDir(this.getOwner())) {
                return null;
            }
            BManifestBrowser.this.generateManifests(BManifestBrowser.this.buildAllKits(), this.getOwner());
            return null;
        }

        GenerateAllCommand(BList bList) {
            super((BWidget)bList, lex, "ManifestManager.regenAll");
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class DeleteManifest
    extends Command {
        public CommandArtifact doInvoke() {
            BList bList = (BList)this.getOwner();
            Class clazz = class$com$tridium$sedonanet$ui$manifest$Db$Manifest;
            if (clazz == null) {
                clazz = class$com$tridium$sedonanet$ui$manifest$Db$Manifest = BManifestBrowser.class("[Lcom.tridium.sedonanet.ui.manifest.Db$Manifest;", false);
            }
            Array array = new Array(clazz);
            Object[] objectArray = bList.getSelectedItems();
            if (bList == BManifestBrowser.this.kitList) {
                if (8 == BDialog.confirm((BWidget)BManifestBrowser.this, (String)"Delete manifests?", (Object)"Delete all manifests for selected kits?")) {
                    return null;
                }
                int n = 0;
                while (n < objectArray.length) {
                    array.addAll((Object[])((Db.Kit)objectArray[n]).manifests);
                    ++n;
                }
            } else {
                if (8 == BDialog.confirm((BWidget)BManifestBrowser.this, (String)"Delete manifests?", (Object)"Delete selected manifests?")) {
                    return null;
                }
                array.addAll(objectArray);
            }
            BProgressDialog.open((BWidget)BManifestBrowser.this, (String)"Delete manifests", (BProgressDialog.Worker)new DeleteWorker(BManifestBrowser.this.db, (Db.Manifest[])array.trim()), (BImage)BManifestManager.clockIcon);
            BManifestBrowser.this.db.reload();
            KitModel kitModel = BManifestBrowser.this.kitModel;
            boolean bl = false;
            if (bList == BManifestBrowser.this.kitList) {
                bl = true;
            }
            kitModel.rebuild(bl);
            return null;
        }

        public DeleteManifest(BList bList) {
            super((BWidget)bList, UiLexicon.bajaui().module, "commands.delete");
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        private class DeleteWorker
        extends BProgressDialog.Worker {
            Db.Manifest[] manifests;
            boolean cancelled;

            public void doRun() throws Exception {
                int n = this.manifests.length;
                int n2 = 0;
                while (n2 < n) {
                    if (this.cancelled) {
                        return;
                    }
                    Db.Manifest manifest = this.manifests[n2];
                    int n3 = (int)((double)n2 * 100.0 / (double)n);
                    this.updateProgress(n3, "Deleting \"" + manifest + "\"...");
                    BManifestBrowser.this.db.delete(manifest);
                    ++n2;
                }
            }

            public void doCancel() {
                this.cancelled = true;
            }

            public DeleteWorker(Db db, Db.Manifest[] manifestArray) {
                this.manifests = manifestArray;
            }
        }
    }

    static class DeselectAllCommand
    extends Command {
        public CommandArtifact doInvoke() {
            ((BList)this.getOwner()).getSelection().deselectAll();
            return null;
        }

        DeselectAllCommand(BList bList) {
            super((BWidget)bList, UiLexicon.bajaui().module, "commands.deselectAll");
        }
    }

    static class SelectAllCommand
    extends Command {
        public CommandArtifact doInvoke() {
            ((BList)this.getOwner()).getSelection().selectAll();
            return null;
        }

        SelectAllCommand(BList bList) {
            super((BWidget)bList, UiLexicon.bajaui().module, "commands.selectAll");
        }
    }
}

