/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.wb.jenser.tool;

import com.tridium.platJen6lp.BJen6lpPlatformService;
import com.tridium.platJen6lp.IWbJen6lpTool;
import com.tridium.platJen6lp.serial.BSerialJen6lpPlatformService;
import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.wb.jenser.tool.BWbJenserCfg;
import com.tridium.wb.jenser.tool.SerialHelper;
import com.tridium.wb.jenser.tool.ports.BWbJenserPort;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.serial.BISerialService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.workbench.tool.BWbService;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BWbJenserTool
extends BWbService
implements IWbJen6lpTool {
    public static final Topic stateChanged = BWbJenserTool.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    static final int STOPPED = 0;
    static final int STARTING = 1;
    static final int RUNNING = 2;
    static final int STOPPING = 3;
    static final int FAILED = 4;
    static final BImage stoppedIcon;
    static final BImage startingIcon;
    static final BImage runningIcon;
    static final BImage stoppingIcon;
    static final BImage failedIcon;
    public static final Log log;
    BSerialPortPlatformService serialService;
    BJen6lpPlatformService jen6lpPlatformService;
    BWbJenserCfg config;
    int state;
    boolean licensed;
    boolean stopAdapters;
    static /* synthetic */ Class class$com$tridium$wb$jenser$tool$BWbJenserTool;

    public void fireStateChanged(BValue bValue) {
        this.fire(stateChanged, bValue, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BWbJenserCfg getJenserConfig() {
        return this.config;
    }

    void loadConfig() throws Exception {
        if (this.config == null) {
            this.config = BWbJenserCfg.load(this);
        }
        this.config.rationalize();
        this.config.dump();
    }

    public void serviceStarted() throws Exception {
        this.updateState(1);
        super.serviceStarted();
        Runnable runnable = new Runnable(){

            public final void run() {
                try {
                    this.checkLicense();
                    this.installSerialPortService();
                    this.installJen6lpPlatformService();
                    BWbJenserTool.this.loadConfig();
                    this.autoStartPorts();
                    BWbJenserTool.this.updateState(2);
                }
                catch (Exception exception) {
                    BWbJenserTool.this.updateState(4);
                    log.error("Start failed.", (Throwable)exception);
                }
            }

            private final void checkLicense() throws Exception {
                Sys.getLicenseManager().checkFeature("tridium", "jennic");
                BWbJenserTool.this.licensed = true;
            }

            private final void installJen6lpPlatformService() throws Exception {
                BWbJenserTool.this.jen6lpPlatformService = (BSerialJen6lpPlatformService)BSerialJen6lpPlatformService.TYPE.getInstance();
                BWbJenserTool.this.jen6lpPlatformService.serviceStarted();
                BWbJenserTool.this.jen6lpPlatformService.start();
                BWbJenserTool.this.jen6lpPlatformService.checkPropertiesLoaded();
            }

            final void installSerialPortService() throws Exception {
                BWbJenserTool.this.serialService = SerialHelper.getSerialService();
                log.message("Started platform serial service: " + BWbJenserTool.this.serialService.getType());
            }

            final void autoStartPorts() throws Exception {
                BWbJenserPort[] bWbJenserPortArray = BWbJenserTool.this.config.getJenserPorts();
                int n = 0;
                while (n < bWbJenserPortArray.length) {
                    try {
                        bWbJenserPortArray[n].autostart();
                    }
                    catch (Exception exception) {
                        log.error("Failed to start port " + bWbJenserPortArray[n].getPortName(), (Throwable)exception);
                    }
                    ++n;
                }
            }
        };
        new Thread(runnable, "JenserStartSerialServices").start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void serviceStopped() throws Exception {
        block12: {
            block10: {
                block11: {
                    super.serviceStopped();
                    try {
                        try {
                            this.updateState(3);
                            if (this.config == null) {
                                Object var2_1 = null;
                                if (this.config == null) break block10;
                                break block11;
                            }
                            BWbJenserPort[] bWbJenserPortArray = this.config.getJenserPorts();
                            int n = 0;
                            while (n < bWbJenserPortArray.length) {
                                if (!bWbJenserPortArray[n].isCoordinator() || this.stopAdapters) {
                                    log.message("Stopping " + (Object)((Object)bWbJenserPortArray[n]));
                                    bWbJenserPortArray[n].stopSerialPort();
                                }
                                ++n;
                            }
                            break block12;
                        }
                        catch (Exception exception) {
                            log.error("Stop failed.", (Throwable)exception);
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        if (this.config != null) {
                            this.config.save();
                            this.config = null;
                        }
                        this.updateState(0);
                        throw throwable;
                    }
                }
                this.config.save();
                this.config = null;
            }
            this.updateState(0);
            return;
        }
        Object var2_3 = null;
        if (this.config != null) {
            this.config.save();
            this.config = null;
        }
        this.updateState(0);
    }

    public BJen6lpPlatformService getJen6lpPlatformService() {
        return this.jen6lpPlatformService;
    }

    public BISerialService getSerialService() {
        return this.serialService;
    }

    public BIcon getIcon() {
        return icon;
    }

    synchronized BImage stateToIcon() {
        switch (this.state) {
            case 0: {
                return stoppedIcon;
            }
            case 1: {
                return startingIcon;
            }
            case 2: {
                return runningIcon;
            }
            case 3: {
                return stoppingIcon;
            }
            case 4: {
                return failedIcon;
            }
        }
        return failedIcon;
    }

    synchronized void updateState(int n) {
        this.state = n;
        this.fireStateChanged(null);
    }

    synchronized boolean isStartable() {
        boolean bl = false;
        if (this.state == 0 || this.state == 4) {
            bl = true;
        }
        return bl;
    }

    synchronized boolean isStoppable() {
        boolean bl = false;
        if (this.state == 2) {
            bl = true;
        }
        return bl;
    }

    public synchronized boolean isToolRunning() {
        boolean bl = false;
        if (this.state == 2) {
            bl = true;
        }
        return bl;
    }

    synchronized boolean isStopped() {
        boolean bl = false;
        if (this.state == 0) {
            bl = true;
        }
        return bl;
    }

    synchronized boolean isFailed() {
        boolean bl = false;
        if (this.state == 4) {
            bl = true;
        }
        return bl;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.state = 0;
        this.licensed = false;
        this.stopAdapters = false;
    }

    public BWbJenserTool() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$wb$jenser$tool$BWbJenserTool;
        if (clazz == null) {
            clazz = class$com$tridium$wb$jenser$tool$BWbJenserTool = BWbJenserTool.class("[Lcom.tridium.wb.jenser.tool.BWbJenserTool;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"jennic.png");
        stoppedIcon = BImage.make((String)"module://icons/x16/shapes/circleRed.png");
        startingIcon = BImage.make((String)"module://icons/x16/clock.png");
        runningIcon = BImage.make((String)"module://icons/x16/shapes/circleGreen.png");
        stoppingIcon = BImage.make((String)"module://icons/x16/clock.png");
        failedIcon = BImage.make((String)"module://icons/x16/error.png");
        log = Log.getLog((String)"sedona.wbSerialJennic.tool");
    }
}

