/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.IOException;
import sedona.Buf;
import sedona.Env;
import sedona.Value;

public final class Double
extends Value {
    public static Double NULL = new Double(java.lang.Double.NaN);
    public static Double ZERO = new Double(0.0);
    public final double val;

    public static final Double make(double d) {
        if (d == 0.0) {
            return ZERO;
        }
        if (java.lang.Double.isNaN(d)) {
            return NULL;
        }
        return new Double(d);
    }

    public final boolean isNull() {
        return java.lang.Double.isNaN(this.val);
    }

    public final int typeId() {
        return 7;
    }

    public final int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.val);
        return (int)(l ^ l >>> 32);
    }

    public final boolean equals(Object object) {
        if (object instanceof Double) {
            return Double.equals(this.val, ((Double)object).val);
        }
        return false;
    }

    public static final boolean equals(double d, double d2) {
        if (java.lang.Double.isNaN(d)) {
            return java.lang.Double.isNaN(d2);
        }
        boolean bl = false;
        if (d == d2) {
            bl = true;
        }
        return bl;
    }

    public final String encodeString() {
        if (this.isNull()) {
            return "null";
        }
        return Env.doubleFormat(this.val);
    }

    public final Value decodeString(String string) {
        if (string.equals("null")) {
            return NULL;
        }
        return Double.make(java.lang.Double.parseDouble(string));
    }

    public final void encodeBinary(Buf buf) {
        buf.f8(this.val);
    }

    public final Value decodeBinary(Buf buf) throws IOException {
        return Double.make(buf.f8());
    }

    private Double(double d) {
        this.val = d;
    }
}

