/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.ui.datetime;

import com.tridium.nsedona.sys.BSedonaComponent;
import com.tridium.nsedona.ui.datetime.BRwTimeZoneFE;
import com.tridium.nsedona.ui.datetime.TimeUtil;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sedona.sys.BSedonaBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.timezone.TimeZoneException;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.wizard.BWizardHeader;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;
import javax.baja.workbench.view.BWbView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIsmaDateTimeServiceView
extends BWbComponentView {
    public static final Action onTimeZoneModified = BIsmaDateTimeServiceView.newAction((int)4, null);
    public static final Type TYPE;
    static BFont bold;
    static final Lexicon lex;
    BTextField curTime;
    BWbFieldEditor desiredTime;
    BTextField curTimeZone;
    BWbFieldEditor desiredTimeZone;
    BTextField curOffset;
    BTextField desiredOffset;
    BTextField curMode;
    ToggleCommandGroup desiredMode;
    ToggleCommand modeOs;
    ToggleCommand modeConfig;
    boolean toggleModified;
    BWbFieldEditor DSTOffset;
    BListDropDown DSTStartWeek;
    BListDropDown DSTStartDay;
    BListDropDown DSTStartMonth;
    BWbFieldEditor DSTStartHour;
    BListDropDown DSTStopWeek;
    BListDropDown DSTStopDay;
    BListDropDown DSTStopMonth;
    BWbFieldEditor DSTStopHour;
    static /* synthetic */ Class class$com$gc5$ui$datetime$BIsmaDateTimeServiceView;

    public void onTimeZoneModified() {
        this.invoke(onTimeZoneModified, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        BGridPane bGridPane;
        BEdgePane bEdgePane;
        BTimeZone bTimeZone;
        String string;
        BSedonaComponent bSedonaComponent = (BSedonaComponent)bObject;
        long l = bSedonaComponent.getLong(bSedonaComponent.getProperty("nanos"));
        int n = bSedonaComponent.getInt(bSedonaComponent.getProperty("utcOffset"));
        boolean bl = ((BSedonaBoolean)bSedonaComponent.get("osUtcOffset")).getBoolean();
        BAbsTime bAbsTime = null;
        try {
            string = bSedonaComponent.getString(bSedonaComponent.getProperty("tz"));
            bTimeZone = TimeZoneDatabase.getTimeZone((String)string);
            if (bTimeZone != null && bTimeZone.getUtcOffset() == n) {
                bAbsTime = BAbsTime.make((long)(l / 1000000L + TimeUtil.epochMillis), (BTimeZone)bTimeZone);
            }
        }
        catch (TimeZoneException timeZoneException) {}
        if (bAbsTime == null) {
            bAbsTime = BAbsTime.make((long)(l / 1000000L + TimeUtil.epochMillis));
        }
        this.curTime = new BTextField("", 24, false);
        this.desiredTime = BWbFieldEditor.makeFor((BObject)bAbsTime, (Context)context);
        this.linkTo((BComponent)this.desiredTime, (Slot)BWbFieldEditor.pluginModified, (Slot)BWbView.setModified);
        this.curTimeZone = new BTextField("", 24, false);
        this.desiredTimeZone = new BRwTimeZoneFE();
        this.linkTo((BComponent)this.desiredTimeZone, (Slot)BWbFieldEditor.pluginModified, (Slot)onTimeZoneModified);
        this.curOffset = new BTextField("", 6, false);
        this.desiredOffset = new BTextField("", 6, false);
        this.curMode = new BTextField("", 24, false);
        this.modeOs = new ToggleCommand((BWidget)this, "Use System Offset");
        this.modeConfig = new ToggleCommand((BWidget)this, "Use Configured Offset");
        this.desiredMode = new ToggleCommandGroup(){

            public final void selected(ToggleCommand toggleCommand) {
                BIsmaDateTimeServiceView.this.setModified();
                BIsmaDateTimeServiceView.this.toggleModified = true;
            }
        };
        this.desiredMode.add(this.modeOs);
        this.desiredMode.add(this.modeConfig);
        string = new BGridPane();
        string.add(null, (BValue)new BRadioButton(this.modeOs));
        string.add(null, (BValue)new BRadioButton(this.modeConfig));
        this.desiredTime.loadValue((BObject)bAbsTime, context);
        this.desiredTimeZone.loadValue((BObject)bAbsTime.getTimeZone(), context);
        this.desiredTimeZone.setReadonly(bl);
        if (bl) {
            this.modeOs.setSelected(true);
        } else {
            this.modeConfig.setSelected(true);
        }
        this.toggleModified = false;
        this.doOnTimeZoneModified();
        this.updateCurrent();
        bTimeZone = new BGridPane();
        bTimeZone.setColumnCount(3);
        bTimeZone.setValign(BValign.top);
        bTimeZone.setHalign(BHalign.left);
        bTimeZone.setColumnGap(10.0);
        bTimeZone.setRowGap(10.0);
        bTimeZone.add(null, (BValue)new BLabel(""));
        bTimeZone.add(null, (BValue)new BLabel("Current", bold));
        bTimeZone.add(null, (BValue)new BLabel("Desired", bold));
        bTimeZone.add(null, (BValue)new BLabel("Current Time", bold));
        bTimeZone.add(null, (BValue)this.curTime);
        bTimeZone.add(null, (BValue)this.desiredTime);
        bTimeZone.add(null, (BValue)new BLabel("Time Zone", bold));
        bTimeZone.add(null, (BValue)this.curTimeZone);
        bTimeZone.add(null, (BValue)this.desiredTimeZone);
        bTimeZone.add(null, (BValue)new BLabel("UTC Offset", bold));
        bTimeZone.add(null, (BValue)this.curOffset);
        bTimeZone.add(null, (BValue)this.desiredOffset);
        bTimeZone.add(null, (BValue)new BLabel("UTC Offset Mode", bold));
        bTimeZone.add(null, (BValue)this.curMode);
        bTimeZone.add(null, (BValue)string);
        bTimeZone.add(null, (BValue)new BLabel(""));
        bTimeZone.add(null, (BValue)new BLabel(""));
        bTimeZone.add(null, (BValue)new BButton((Command)new WbTime((BWidget)this)));
        BGridPane bGridPane2 = new BGridPane();
        bGridPane2.setColumnCount(2);
        bGridPane2.setValign(BValign.top);
        bGridPane2.setHalign(BHalign.left);
        bGridPane2.setColumnGap(10.0);
        bGridPane2.setRowGap(10.0);
        try {
            boolean bl2 = ((BSedonaBoolean)bSedonaComponent.get("DSTStatus")).getBoolean();
            bGridPane2.add(null, (BValue)new BLabel("DST Status", bold));
            bGridPane2.add(null, (BValue)new BLabel(bl2 ? "Summer Time" : "Standard Time"));
            int n2 = bSedonaComponent.getInt(bSedonaComponent.getProperty("DaylightSavingTimeOffset"));
            this.DSTOffset = BWbFieldEditor.makeFor((BObject)BInteger.DEFAULT, (Context)context);
            this.DSTOffset.loadValue((BObject)BInteger.make((int)n2));
            this.linkTo((BComponent)this.DSTOffset, (Slot)BWbFieldEditor.pluginModified, (Slot)BWbView.setModified);
            bGridPane2.add(null, (BValue)new BLabel("DST Offset", bold));
            bGridPane2.add(null, (BValue)this.DSTOffset);
            bEdgePane = new BGridPane();
            bEdgePane.setColumnCount(6);
            bEdgePane.setValign(BValign.top);
            bEdgePane.setHalign(BHalign.left);
            bEdgePane.setColumnGap(10.0);
            bEdgePane.setRowGap(10.0);
            this.DSTStartWeek = new BListDropDown();
            bGridPane = (BEnumRange)bSedonaComponent.getProperty("DSTStartWeek").getFacets().get("range");
            int n3 = 0;
            while (n3 < bGridPane.getOrdinals().length) {
                this.DSTStartWeek.getList().addItem((Object)bGridPane.get(n3));
                ++n3;
            }
            this.DSTStartWeek.setSelectedIndex(((BDynamicEnum)bSedonaComponent.get("DSTStartWeek")).getOrdinal());
            this.linkTo((BComponent)this.DSTStartWeek, (Slot)BListDropDown.valueModified, (Slot)BWbView.setModified);
            bEdgePane.add(null, (BValue)this.DSTStartWeek);
            this.DSTStartDay = new BListDropDown();
            bGridPane = (BEnumRange)bSedonaComponent.getProperty("DSTStartDay").getFacets().get("range");
            n3 = 0;
            while (n3 < bGridPane.getOrdinals().length) {
                this.DSTStartDay.getList().addItem((Object)bGridPane.get(n3));
                ++n3;
            }
            this.DSTStartDay.setSelectedIndex(((BDynamicEnum)bSedonaComponent.get("DSTStartDay")).getOrdinal());
            this.linkTo((BComponent)this.DSTStartDay, (Slot)BListDropDown.valueModified, (Slot)BWbView.setModified);
            bEdgePane.add(null, (BValue)this.DSTStartDay);
            bEdgePane.add(null, (BValue)new BLabel("of"));
            this.DSTStartMonth = new BListDropDown();
            bGridPane = (BEnumRange)bSedonaComponent.getProperty("DSTStartMonth").getFacets().get("range");
            n3 = 0;
            while (n3 < bGridPane.getOrdinals().length) {
                this.DSTStartMonth.getList().addItem((Object)bGridPane.get(n3));
                ++n3;
            }
            this.DSTStartMonth.setSelectedIndex(((BDynamicEnum)bSedonaComponent.get("DSTStartMonth")).getOrdinal());
            this.linkTo((BComponent)this.DSTStartMonth, (Slot)BListDropDown.valueModified, (Slot)BWbView.setModified);
            bEdgePane.add(null, (BValue)this.DSTStartMonth);
            bEdgePane.add(null, (BValue)new BLabel("at"));
            n3 = bSedonaComponent.getInt(bSedonaComponent.getProperty("DSTStartHour"));
            this.DSTStartHour = BWbFieldEditor.makeFor((BObject)BInteger.DEFAULT, (Context)context);
            this.DSTStartHour.loadValue((BObject)BInteger.make((int)n3));
            this.linkTo((BComponent)this.DSTStartHour, (Slot)BWbFieldEditor.pluginModified, (Slot)BWbView.setModified);
            bEdgePane.add(null, (BValue)this.DSTStartHour);
            bGridPane2.add(null, (BValue)new BLabel("DST Start", bold));
            bGridPane2.add(null, (BValue)bEdgePane);
            BGridPane bGridPane3 = new BGridPane();
            bGridPane3.setColumnCount(6);
            bGridPane3.setValign(BValign.top);
            bGridPane3.setHalign(BHalign.left);
            bGridPane3.setColumnGap(10.0);
            bGridPane3.setRowGap(10.0);
            this.DSTStopWeek = new BListDropDown();
            bGridPane = (BEnumRange)bSedonaComponent.getProperty("DSTStopWeek").getFacets().get("range");
            int n4 = 0;
            while (n4 < bGridPane.getOrdinals().length) {
                this.DSTStopWeek.getList().addItem((Object)bGridPane.get(n4));
                ++n4;
            }
            this.DSTStopWeek.setSelectedIndex(((BDynamicEnum)bSedonaComponent.get("DSTStopWeek")).getOrdinal());
            this.linkTo((BComponent)this.DSTStopWeek, (Slot)BListDropDown.valueModified, (Slot)BWbView.setModified);
            bGridPane3.add(null, (BValue)this.DSTStopWeek);
            this.DSTStopDay = new BListDropDown();
            bGridPane = (BEnumRange)bSedonaComponent.getProperty("DSTStopDay").getFacets().get("range");
            n4 = 0;
            while (n4 < bGridPane.getOrdinals().length) {
                this.DSTStopDay.getList().addItem((Object)bGridPane.get(n4));
                ++n4;
            }
            this.DSTStopDay.setSelectedIndex(((BDynamicEnum)bSedonaComponent.get("DSTStopDay")).getOrdinal());
            this.linkTo((BComponent)this.DSTStopDay, (Slot)BListDropDown.valueModified, (Slot)BWbView.setModified);
            bGridPane3.add(null, (BValue)this.DSTStopDay);
            bGridPane3.add(null, (BValue)new BLabel("of"));
            this.DSTStopMonth = new BListDropDown();
            bGridPane = (BEnumRange)bSedonaComponent.getProperty("DSTStopMonth").getFacets().get("range");
            n4 = 0;
            while (n4 < bGridPane.getOrdinals().length) {
                this.DSTStopMonth.getList().addItem((Object)bGridPane.get(n4));
                ++n4;
            }
            this.DSTStopMonth.setSelectedIndex(((BDynamicEnum)bSedonaComponent.get("DSTStopMonth")).getOrdinal());
            this.linkTo((BComponent)this.DSTStopMonth, (Slot)BListDropDown.valueModified, (Slot)BWbView.setModified);
            bGridPane3.add(null, (BValue)this.DSTStopMonth);
            bGridPane3.add(null, (BValue)new BLabel("at"));
            n4 = bSedonaComponent.getInt(bSedonaComponent.getProperty("DSTStopHour"));
            this.DSTStopHour = BWbFieldEditor.makeFor((BObject)BInteger.DEFAULT, (Context)context);
            this.DSTStopHour.loadValue((BObject)BInteger.make((int)n4));
            this.linkTo((BComponent)this.DSTStopHour, (Slot)BWbFieldEditor.pluginModified, (Slot)BWbView.setModified);
            bGridPane3.add(null, (BValue)this.DSTStopHour);
            bGridPane2.add(null, (BValue)new BLabel("DST Stop", bold));
            bGridPane2.add(null, (BValue)bGridPane3);
        }
        catch (Exception exception) {}
        BGridPane bGridPane4 = new BGridPane();
        bGridPane4.setColumnCount(1);
        bGridPane4.setValign(BValign.top);
        bGridPane4.setHalign(BHalign.left);
        bGridPane4.setColumnGap(10.0);
        bGridPane4.setRowGap(10.0);
        bGridPane4.add(null, (BValue)bTimeZone);
        bGridPane4.add(null, (BValue)bGridPane2);
        BWizardHeader bWizardHeader = new BWizardHeader(BImage.make((String)"module://icons/x32/clock.png"), "DateTimeService", "Manage system clock for device");
        bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)bWizardHeader);
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)bGridPane4));
        bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton(this.getWbShell().getRefreshCommand()));
        bGridPane.add(null, (BValue)new BButton(this.getWbShell().getSaveCommand()));
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bEdgePane, BBorder.inset, BInsets.make((double)0.0)));
        bEdgePane2.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, (double)5, (double)5, 0.0, (double)5));
        this.setContent((BWidget)bEdgePane2);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        int n;
        int n2;
        BSedonaComponent bSedonaComponent = (BSedonaComponent)bObject;
        try {
            int n3 = ((BInteger)this.DSTOffset.saveValue(context)).getInt();
            bSedonaComponent.setInt(bSedonaComponent.getProperty("DaylightSavingTimeOffset"), n3);
            int n4 = this.DSTStartWeek.getSelectedIndex();
            bSedonaComponent.set(bSedonaComponent.getProperty("DSTStartWeek"), (BValue)BInteger.make((int)n4));
            int n5 = this.DSTStartDay.getSelectedIndex();
            bSedonaComponent.set(bSedonaComponent.getProperty("DSTStartDay"), (BValue)BInteger.make((int)n5));
            n2 = this.DSTStartMonth.getSelectedIndex();
            bSedonaComponent.set(bSedonaComponent.getProperty("DSTStartMonth"), (BValue)BInteger.make((int)n2));
            n = ((BInteger)this.DSTStartHour.saveValue(context)).getInt();
            bSedonaComponent.setInt(bSedonaComponent.getProperty("DSTStartHour"), n);
            int n6 = this.DSTStopWeek.getSelectedIndex();
            bSedonaComponent.set(bSedonaComponent.getProperty("DSTStopWeek"), (BValue)BInteger.make((int)n6));
            int n7 = this.DSTStopDay.getSelectedIndex();
            bSedonaComponent.set(bSedonaComponent.getProperty("DSTStopDay"), (BValue)BInteger.make((int)n7));
            int n8 = this.DSTStopMonth.getSelectedIndex();
            bSedonaComponent.set(bSedonaComponent.getProperty("DSTStopMonth"), (BValue)BInteger.make((int)n8));
            int n9 = ((BInteger)this.DSTStopHour.saveValue(context)).getInt();
            bSedonaComponent.setInt(bSedonaComponent.getProperty("DSTStopHour"), n9);
        }
        catch (Exception exception) {}
        if (this.desiredTime.isModified() || this.toggleModified) {
            BAbsTime bAbsTime = (BAbsTime)this.desiredTime.saveValue(context);
            long l = (bAbsTime.getMillis() - TimeUtil.epochMillis) * 1000000L;
            if (l < 0L) {
                throw new CannotSaveException("Desired time is before the Sedona epoch: " + TimeUtil.epoch);
            }
            n2 = ((BSedonaBoolean)bSedonaComponent.get("osUtcOffset")).getBoolean();
            if (n2 == 0) {
                n = bAbsTime.getTimeZoneOffset() / 1000;
                bSedonaComponent.setInt(bSedonaComponent.getProperty("utcOffset"), n);
                bSedonaComponent.setString(bSedonaComponent.getProperty("tz"), bAbsTime.getTimeZone().getId());
            }
            n = this.modeOs.isSelected();
            bSedonaComponent.set(bSedonaComponent.getProperty("osUtcOffset"), (BValue)BSedonaBoolean.make(n != 0));
            this.desiredTimeZone.setReadonly(n != 0);
            if (n2 == 0 && n != 0) {
                bSedonaComponent.setString(bSedonaComponent.getProperty("tz"), "");
            }
            bSedonaComponent.invoke(bSedonaComponent.getAction("setSysClock"), (BValue)BLong.make((long)l));
            this.updateCurrent();
        }
        this.toggleModified = false;
        return bSedonaComponent;
    }

    public void doOnTimeZoneModified() throws Exception {
        BTimeZone bTimeZone = (BTimeZone)this.desiredTimeZone.saveValue();
        BAbsTime bAbsTime = (BAbsTime)this.desiredTime.saveValue();
        bAbsTime = BAbsTime.make((long)bAbsTime.getMillis(), (BTimeZone)bTimeZone);
        this.desiredTime.loadValue((BObject)bAbsTime);
        int n = bAbsTime.getTimeZoneOffset() / 1000;
        this.desiredOffset.setText(BIsmaDateTimeServiceView.toOffsetStr(n));
        this.toggleModified = true;
        this.setModified();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        this.updateCurrent();
    }

    public void updateCurrent() {
        BSedonaComponent bSedonaComponent = (BSedonaComponent)this.getCurrentValue();
        int n = bSedonaComponent.getInt(bSedonaComponent.getProperty("utcOffset"));
        boolean bl = ((BSedonaBoolean)bSedonaComponent.get(bSedonaComponent.getProperty("osUtcOffset"))).getBoolean();
        this.curTime.setText(BIsmaDateTimeServiceView.toTimeStr(bSedonaComponent));
        String string = bSedonaComponent.getString(bSedonaComponent.getProperty("tz"));
        if (string == null) {
            string = "";
        }
        this.curTimeZone.setText(string);
        this.curOffset.setText(BIsmaDateTimeServiceView.toOffsetStr(n));
        this.curMode.setText(bl ? "Using System Offset" : "Using Configured Offset");
    }

    public static String toOffsetStr(int n) {
        String string;
        String string2 = string = n > 0 ? "+" : "-";
        if (n % 3600 == 0) {
            return string + n / 3600 + " hr";
        }
        return string + n + " sec";
    }

    public static String toTimeStr(BSedonaComponent bSedonaComponent) {
        try {
            int n = bSedonaComponent.getInt(bSedonaComponent.getProperty("hour"));
            int n2 = bSedonaComponent.getInt(bSedonaComponent.getProperty("minute"));
            int n3 = bSedonaComponent.getInt(bSedonaComponent.getProperty("second"));
            int n4 = bSedonaComponent.getInt(bSedonaComponent.getProperty("year"));
            int n5 = bSedonaComponent.getInt(bSedonaComponent.getProperty("month"));
            int n6 = bSedonaComponent.getInt(bSedonaComponent.getProperty("day"));
            int n7 = bSedonaComponent.getInt(bSedonaComponent.getProperty("dayOfWeek"));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(n6).append('-');
            try {
                stringBuffer.append(BMonth.make((int)(n5 - 1)).getShortDisplayTag(null));
            }
            catch (Exception exception) {
                stringBuffer.append(n5);
            }
            stringBuffer.append('-').append(n4).append(' ');
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n).append(':');
            if (n2 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n2).append(':');
            if (n3 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n3).append(' ');
            try {
                stringBuffer.append(BWeekday.make((int)n7).getShortDisplayTag(null));
            }
            catch (Exception exception) {}
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "Error";
        }
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.toggleModified = false;
    }

    public BIsmaDateTimeServiceView() {
        this.this();
    }

    static {
        Class clazz = class$com$gc5$ui$datetime$BIsmaDateTimeServiceView;
        if (clazz == null) {
            clazz = class$com$gc5$ui$datetime$BIsmaDateTimeServiceView = BIsmaDateTimeServiceView.class("[Lcom.gc5.ui.datetime.BIsmaDateTimeServiceView;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        bold = Theme.widget().getBoldText();
        Class clazz2 = class$com$gc5$ui$datetime$BIsmaDateTimeServiceView;
        if (clazz2 == null) {
            clazz2 = class$com$gc5$ui$datetime$BIsmaDateTimeServiceView = BIsmaDateTimeServiceView.class("[Lcom.gc5.ui.datetime.BIsmaDateTimeServiceView;", false);
        }
        lex = Lexicon.make((Class)clazz2);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class WbTime
    extends Command {
        public CommandArtifact doInvoke() throws Exception {
            BIsmaDateTimeServiceView.this.desiredTime.loadValue((BObject)BAbsTime.now());
            if (BIsmaDateTimeServiceView.this.modeConfig.isSelected()) {
                BIsmaDateTimeServiceView.this.desiredTimeZone.loadValue((BObject)BTimeZone.getLocal());
                BIsmaDateTimeServiceView.this.onTimeZoneModified();
            }
            BIsmaDateTimeServiceView.this.setModified();
            return null;
        }

        public WbTime(BWidget bWidget) {
            super(bWidget, lex, "cmd.wbtime");
        }
    }
}

