/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.ui.history;

import com.gc5.ui.history.FileItem;
import com.tridium.nsedona.sys.BSedonaComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.baja.gx.BImage;
import javax.baja.sys.BDynamicEnum;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import sedona.Schema;
import sedona.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileItemModel
extends TableModel {
    TableSelection selection;
    private int fileSize;
    private BSedonaComponent service;
    private ArrayList items = new ArrayList();
    static /* synthetic */ Class class$com$tridium$nsedona$sys$BSedonaComponent;

    public synchronized FileItemModel load(BSedonaComponent bSedonaComponent) {
        Schema schema = bSedonaComponent.s().type.schema;
        Type type = schema.type("iSMA_controlApi::PstoreFile");
        this.service = bSedonaComponent;
        this.items.clear();
        Class clazz = class$com$tridium$nsedona$sys$BSedonaComponent;
        if (clazz == null) {
            clazz = class$com$tridium$nsedona$sys$BSedonaComponent = FileItemModel.class("[Lcom.tridium.nsedona.sys.BSedonaComponent;", false);
        }
        BSedonaComponent[] bSedonaComponentArray = (BSedonaComponent[])bSedonaComponent.getChildren(clazz);
        int n = 0;
        while (n < bSedonaComponentArray.length) {
            BSedonaComponent bSedonaComponent2 = bSedonaComponentArray[n];
            if (bSedonaComponent2.s().type.is(type)) {
                this.items.add(new FileItem().load(bSedonaComponent2));
            }
            ++n;
        }
        this.updateRows();
        return this;
    }

    public FileItemModel reload() {
        return this.load(this.service);
    }

    public FileItem get(int n) {
        return (FileItem)this.items.get(n);
    }

    public FileItem[] selected() {
        int[] nArray = this.selection.getRows();
        FileItem[] fileItemArray = new FileItem[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            fileItemArray[n] = this.get(nArray[n]);
            ++n;
        }
        return fileItemArray;
    }

    public int fileSize() {
        return this.fileSize;
    }

    public int size() {
        return this.items.size();
    }

    public int toRow(FileItem fileItem) {
        return this.items.indexOf(fileItem);
    }

    public BSedonaComponent[] selectedComponents() {
        int[] nArray = this.selection.getRows();
        BSedonaComponent[] bSedonaComponentArray = new BSedonaComponent[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            bSedonaComponentArray[n] = this.get((int)nArray[n]).c;
            ++n;
        }
        return bSedonaComponentArray;
    }

    public int getRowCount() {
        return this.items.size();
    }

    public int getColumnCount() {
        return 9;
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public BImage getRowIcon(int n) {
        if (n < 0 || n >= this.items.size()) {
            return null;
        }
        return this.get((int)n).icon;
    }

    public void sortByColumn(final int n, final boolean bl) {
        Collections.sort(this.items, new Comparator(){

            public final int compare(Object object, Object object2) {
                Comparable comparable = FileItemModel.this.getValue((FileItem)object, n);
                Comparable comparable2 = FileItemModel.this.getValue((FileItem)object2, n);
                return bl ? comparable.compareTo(comparable2) : comparable2.compareTo(comparable);
            }
        });
        this.updateRows();
    }

    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return "Name";
            }
            case 1: {
                return "Description";
            }
            case 2: {
                return "Type";
            }
            case 3: {
                return "Interval";
            }
            case 4: {
                return "Deadband";
            }
            case 5: {
                return "Fault Cause";
            }
            case 6: {
                return "Offset";
            }
            case 7: {
                return "Size";
            }
            case 8: {
                return "Capacity";
            }
        }
        return "???";
    }

    public Object getValueAt(int n, int n2) {
        if (n < 0 || n >= this.items.size()) {
            return "???";
        }
        FileItem fileItem = this.get(n);
        return this.getValue(fileItem, n2);
    }

    public Comparable getValue(FileItem fileItem, int n) {
        switch (n) {
            case 0: {
                return fileItem.c.getName();
            }
            case 1: {
                return new String(fileItem.description);
            }
            case 2: {
                return fileItem.c.s().type.qname;
            }
            case 3: {
                return new Integer(fileItem.interval);
            }
            case 4: {
                return new Float(fileItem.deadband);
            }
            case 5: {
                return FileItemModel.status(fileItem.c);
            }
            case 6: {
                return new Integer(fileItem.offset);
            }
            case 7: {
                return new Integer(fileItem.size);
            }
            case 8: {
                return new Integer(fileItem.capacity);
            }
        }
        return "???";
    }

    public boolean isSelected(FileItem fileItem) {
        return this.selection.isSelected(fileItem.row);
    }

    private final void updateRows() {
        int n = 0;
        while (n < this.size()) {
            this.get((int)n).row = n;
            ++n;
        }
    }

    public static String status(BSedonaComponent bSedonaComponent) {
        if (bSedonaComponent.getProperty("status") != null) {
            switch (((BDynamicEnum)bSedonaComponent.get("status")).getOrdinal()) {
                case 0: {
                    return "{Ok}";
                }
                case 1: {
                    return "{Inactive}";
                }
                case 2: {
                    return "{Bad Parent}";
                }
                case 3: {
                    return "{Service Error}";
                }
                case 4: {
                    return "{Bad Offset}";
                }
                case 5: {
                    return "{Bad Size}";
                }
                case 6: {
                    return "{Duplicate Range}";
                }
                case 7: {
                    return "{Format Error}";
                }
            }
            return "{Unknown}";
        }
        return "{Unknown}";
    }

    public static String sizeStr(int n) {
        return String.valueOf(n);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

