/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.util;

import com.gc5.util.TextUtil;
import com.gc5.util.TimeUtil;
import com.tridium.data.BDataTable;
import com.tridium.nsedona.sox.BSoxSession;
import com.tridium.nsedona.sys.BSedonaComponent;
import java.io.IOException;
import javax.baja.collection.BITable;
import javax.baja.data.BIDataValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.timezone.TimeZoneException;
import javax.baja.util.Array;
import sedona.Buf;
import sedona.Constants;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class AlarmUtil
implements Constants {
    static /* synthetic */ Class class$com$gc5$util$AlarmUtil$AlarmRecord;

    public static BITable makeTable(BSedonaComponent bSedonaComponent, Context context) throws Exception {
        Class clazz;
        if (context == null) {
            context = new BasicContext(context);
        }
        SoxClient soxClient = ((BSoxSession)bSedonaComponent.getSession()).getClient();
        SoxComponent soxComponent = soxClient.loadApp();
        SoxComponent soxComponent2 = null;
        SoxComponent soxComponent3 = null;
        SoxComponent[] soxComponentArray = soxComponent.children();
        int n = 0;
        while (n < soxComponentArray.length) {
            if (soxComponentArray[n] != null && soxComponentArray[n].type.toString().equalsIgnoreCase("iSMA_control::Services")) {
                soxComponent2 = soxComponentArray[n];
            }
            if (soxComponentArray[n] != null && soxComponentArray[n].type.toString().equalsIgnoreCase("datetime::DateTimeServiceStd")) {
                soxComponent3 = soxComponentArray[n];
            }
            ++n;
        }
        soxComponentArray = soxComponent2.children();
        n = 0;
        while (n < soxComponentArray.length) {
            if (soxComponentArray[n] != null && soxComponentArray[n].type.toString().equalsIgnoreCase("datetime::DateTimeServiceStd")) {
                soxComponent3 = soxComponentArray[n];
            }
            ++n;
        }
        soxClient.subscribe(soxComponent3, 7);
        n = soxComponent3.getInt("utcOffset") * 1000;
        boolean bl = soxComponent3.getBool("osUtcOffset");
        String string = soxComponent3.getStr("tz");
        BTimeZone bTimeZone = null;
        try {
            bTimeZone = TimeZoneDatabase.getTimeZone((String)string);
        }
        catch (TimeZoneException timeZoneException) {
            System.out.println("No Timezone found.");
        }
        Buf buf = soxClient.readPstoreFile((SoxComponent)bSedonaComponent.s());
        buf.seek(0);
        int n2 = buf.u2();
        if (n2 != 49182) {
            throw new IOException("Invalid magic number 0x" + Integer.toHexString(n2));
        }
        buf.skipBytes(2);
        int n3 = buf.i4();
        buf.seek(80);
        BDataTable bDataTable = new BDataTable();
        bDataTable.addColumn("sourceName", "Source Name", BString.TYPE, 0, context.getFacets());
        bDataTable.addColumn("sourcePath", "Source Path", BString.TYPE, 0, context.getFacets());
        bDataTable.addColumn("nanos", "Update Timestamp", BAbsTime.TYPE, 0, BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)context.getFacets()));
        bDataTable.addColumn("toNormalNanos", "Normal Timestamp", BAbsTime.TYPE, 0, BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)context.getFacets()));
        bDataTable.addColumn("toOffNormalNanos", "OffNormal Timestamp", BAbsTime.TYPE, 0, BFacets.make((BFacets)BFacets.make((String)"showSeconds", (boolean)true), (BFacets)context.getFacets()));
        bDataTable.addColumn("offnormalValue", "Offnormal Value", BString.TYPE, 0, context.getFacets());
        bDataTable.addColumn("alarmClass", "Alarm Class", BString.TYPE, 0, context.getFacets());
        bDataTable.addColumn("alarmState", "Alarm State", BString.TYPE, 0, context.getFacets());
        bDataTable.addColumn("message", "Alarm Message", BString.TYPE, 0, context.getFacets());
        boolean bl2 = false;
        long l = 0L;
        int n4 = 0;
        Class clazz2 = class$com$gc5$util$AlarmUtil$AlarmRecord;
        if (clazz2 == null) {
            clazz2 = class$com$gc5$util$AlarmUtil$AlarmRecord = AlarmUtil.class("[Lcom.gc5.util.AlarmUtil$AlarmRecord;", false);
        }
        Array array = new Array(clazz2);
        int n5 = 0;
        while (buf.available() >= 80) {
            block25: {
                long l2 = buf.i8();
                if (l2 <= 0L) break;
                long l3 = buf.i8();
                long l4 = buf.i8();
                int n6 = buf.i4();
                String string2 = "";
                String string3 = "";
                int n7 = 3;
                String string4 = "";
                SoxComponent soxComponent4 = null;
                try {
                    soxComponent4 = soxClient.load(n6);
                }
                catch (Exception exception) {
                    buf.seek((n5 + 1) * 80 + 80);
                    break block25;
                }
                if (soxComponent4 != null && !soxComponent4.type.toString().endsWith("AlarmExt")) {
                    buf.seek((n5 + 1) * 80 + 80);
                } else {
                    if (soxComponent4 == null) {
                        string2 = "N/A";
                        string3 = "N/A";
                        n7 = 3;
                        string4 = "N/A";
                    } else {
                        string2 = soxComponent4.parent().name();
                        string3 = soxComponent4.parent().path();
                        n7 = soxComponent4.getInt("alarmClass");
                        string4 = soxComponent4.type.name;
                    }
                    n4 = string4.equals("OutOfRangeAlarmExt") ? 1 : (string4.equals("BooleanChangeOfStateAlarmExt") ? 0 : 2);
                    int n8 = buf.i4();
                    int n9 = buf.u2();
                    int n10 = buf.u2();
                    int n11 = buf.u2();
                    byte[] byArray = new byte[n11];
                    buf.read(byArray, 0, n11);
                    buf.seek((n5 + 1) * 80 + 80);
                    array.add((Object)new AlarmRecord(l2, l3, l4, string2, string3, n4, n8, n7, n9, n10, n11, byArray));
                }
            }
            ++n5;
        }
        if ((clazz = class$com$gc5$util$AlarmUtil$AlarmRecord) == null) {
            clazz = class$com$gc5$util$AlarmUtil$AlarmRecord = AlarmUtil.class("[Lcom.gc5.util.AlarmUtil$AlarmRecord;", false);
        }
        Array array2 = new Array(clazz);
        array2.addAll(array.copy());
        bDataTable.startRows();
        int n12 = 0;
        while (n12 < array2.size()) {
            AlarmRecord alarmRecord = (AlarmRecord)array2.get(n12);
            bDataTable.startRow();
            bDataTable.set((BIDataValue)BString.make((String)alarmRecord.sourceName), null);
            bDataTable.set((BIDataValue)BString.make((String)alarmRecord.sourcePath), null);
            if (bTimeZone != null && bTimeZone.getUtcOffset() == n) {
                bDataTable.set((BIDataValue)BAbsTime.make((long)alarmRecord.nanos, (BTimeZone)bTimeZone), null);
            } else {
                bDataTable.set((BIDataValue)BAbsTime.make((long)alarmRecord.nanos), null);
            }
            if (bTimeZone != null && bTimeZone.getUtcOffset() == n) {
                bDataTable.set((BIDataValue)BAbsTime.make((long)alarmRecord.toNormalNanos, (BTimeZone)bTimeZone), null);
            } else {
                bDataTable.set((BIDataValue)BAbsTime.make((long)alarmRecord.toNormalNanos), null);
            }
            if (bTimeZone != null && bTimeZone.getUtcOffset() == n) {
                bDataTable.set((BIDataValue)BAbsTime.make((long)alarmRecord.toOffNormalNanos, (BTimeZone)bTimeZone), null);
            } else {
                bDataTable.set((BIDataValue)BAbsTime.make((long)alarmRecord.toOffNormalNanos), null);
            }
            bDataTable.set((BIDataValue)BString.make((String)alarmRecord.offNormalValue), null);
            bDataTable.set((BIDataValue)BString.make((String)alarmRecord.alarmClass), null);
            bDataTable.set((BIDataValue)BString.make((String)alarmRecord.alarmState), null);
            bDataTable.set((BIDataValue)BString.make((String)alarmRecord.message), null);
            bDataTable.endRow();
            ++n12;
        }
        bDataTable.endRows();
        bDataTable.setTableFacets(BFacets.make((String)"title", (String)bSedonaComponent.s().name()));
        return bDataTable.sort(bDataTable.getColumns().get("nanos"), false);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class AlarmRecord {
        public final long nanos;
        public final long toNormalNanos;
        public final long toOffNormalNanos;
        public final String sourceName;
        public final String sourcePath;
        public final String offNormalValue;
        public final String alarmClass;
        public final String alarmState;
        public final String txState;
        public final String message;

        public AlarmRecord(long l, long l2, long l3, String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, byte[] byArray) {
            this.nanos = TimeUtil.epochMillis + l / 1000000L;
            this.toNormalNanos = TimeUtil.epochMillis + l2 / 1000000L;
            this.toOffNormalNanos = TimeUtil.epochMillis + l3 / 1000000L;
            this.sourceName = string;
            this.sourcePath = string2;
            switch (n) {
                case 0: {
                    this.offNormalValue = n2 != 0 ? "True" : "False";
                    break;
                }
                case 1: {
                    this.offNormalValue = Float.toString(Float.intBitsToFloat(n2));
                    break;
                }
                default: {
                    this.offNormalValue = "N/A";
                }
            }
            switch (n3) {
                case 0: {
                    this.alarmClass = "Life Safety";
                    break;
                }
                case 1: {
                    this.alarmClass = "Critical";
                    break;
                }
                case 2: {
                    this.alarmClass = "Maintenance";
                    break;
                }
                default: {
                    this.alarmClass = "N/A";
                }
            }
            switch (n4) {
                case 0: {
                    this.alarmState = "Fault";
                    break;
                }
                case 1: {
                    this.alarmState = "High Limit";
                    break;
                }
                case 2: {
                    this.alarmState = "Low Limit";
                    break;
                }
                case 3: {
                    this.alarmState = "Normal";
                    break;
                }
                case 4: {
                    this.alarmState = "Offnormal";
                    break;
                }
                default: {
                    this.alarmState = "N/A";
                }
            }
            switch (n5) {
                case 0: {
                    this.txState = "Idle";
                    break;
                }
                case 1: {
                    this.txState = "Unaccepted";
                    break;
                }
                case 2: {
                    this.txState = "Accepted";
                    break;
                }
                case 3: {
                    this.txState = "Completed";
                    break;
                }
                default: {
                    this.txState = "N/A";
                }
            }
            StringBuffer stringBuffer = new StringBuffer("");
            int n7 = 0;
            while (n7 < n6 - 1) {
                stringBuffer.append(TextUtil.byteToChar(byArray[n7] & 0xFF, '?'));
                ++n7;
            }
            this.message = stringBuffer.toString();
        }
    }
}

