/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.comm;

import com.gc5.BIsmaSoxDevice;
import com.gc5.comm.FileTransfer;
import com.gc5.comm.SoxComponent;
import com.gc5.comm.SoxMsg;
import com.gc5.comm.SoxUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import sedona.Buf;
import sedona.Component;
import sedona.Env;
import sedona.Kit;
import sedona.KitPart;
import sedona.Link;
import sedona.Schema;
import sedona.Slot;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.dasp.DaspSession;
import sedona.manifest.KitManifest;
import sedona.manifest.ManifestDb;
import sedona.manifest.ManifestZipUtil;
import sedona.sox.KitVersion;
import sedona.sox.SoxException;
import sedona.sox.SoxFile;
import sedona.sox.VersionInfo;
import sedona.util.Version;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class SoxClient {
    public boolean traceMsg;
    public boolean traceXferStats;
    DaspSession session;
    String closeCause;
    boolean allTreeEvents;
    SoxComponent[] cache;
    private FileTransfer fileTransfer;
    volatile boolean closing;
    private Vector listeners;
    private SoxUtil util;
    BIsmaSoxDevice device;
    SoxMsg[] requests;
    SoxMsg[] responses;
    private final Object subscribeSyncLock;

    public DaspSession session() {
        return this.session;
    }

    public boolean isClosed() {
        DaspSession daspSession = this.session;
        if (daspSession == null) {
            return true;
        }
        if (daspSession.isClosed()) {
            this.closeCause = daspSession.closeCause();
            return true;
        }
        return false;
    }

    public synchronized Schema readSchema() throws Exception {
        if (this.util.schema != null) {
            return this.util.schema;
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(118);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(86);
        int n = soxMsg2.u1();
        KitPart[] kitPartArray = new KitPart[n];
        int n2 = 0;
        while (n2 < n) {
            kitPartArray[n2] = new KitPart(soxMsg2.str(), soxMsg2.i4());
            ++n2;
        }
        this.util.schema = this.loadSchema(kitPartArray);
        return this.util.schema;
    }

    private final Schema loadSchema(KitPart[] kitPartArray) throws Exception {
        try {
            return Schema.load((KitPart[])kitPartArray);
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            this.tryResolveMissing(missingKitManifestException.parts);
            return Schema.load((KitPart[])kitPartArray);
        }
    }

    private final void tryResolveMissing(KitPart[] kitPartArray) throws Exception {
        int n;
        KitManifest[] kitManifestArray = null;
        Buf buf = new Buf();
        try {
            this.getFile("m:m.zip", SoxFile.make((Buf)buf), null, null);
            kitManifestArray = ManifestZipUtil.extract((Buf)buf, (KitPart[])kitPartArray);
        }
        catch (Exception exception) {}
        if (kitManifestArray == null) {
            kitManifestArray = new KitManifest[kitPartArray.length];
            n = 0;
            while (n < kitPartArray.length) {
                buf = new Buf();
                try {
                    this.getFile("m:" + kitPartArray[n] + ".xml", SoxFile.make((Buf)buf), null, null);
                    kitManifestArray[n] = ManifestZipUtil.extract((Buf)buf, (KitPart)kitPartArray[n]);
                }
                catch (Exception exception) {
                    kitManifestArray[n] = null;
                }
                ++n;
            }
        }
        n = 0;
        while (n < kitManifestArray.length) {
            if (kitManifestArray[n] != null) {
                ManifestDb.save((KitManifest)kitManifestArray[n]);
            }
            ++n;
        }
    }

    public synchronized VersionInfo readVersion() throws Exception {
        if (this.util.version != null) {
            return this.util.version;
        }
        Schema schema = this.readSchema();
        SoxMsg soxMsg = SoxMsg.prepareReq(121);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(89);
        String string = soxMsg2.str();
        int n = soxMsg2.u1();
        KitVersion[] kitVersionArray = new KitVersion[schema.kits.length];
        int n2 = 0;
        while (n2 < kitVersionArray.length) {
            Kit kit = schema.kits[n2];
            Version version = new Version(soxMsg2.str());
            kitVersionArray[n2] = new KitVersion(kit.name, kit.checksum, version);
            ++n2;
        }
        this.util.version = new VersionInfo(string, n, kitVersionArray);
        n2 = soxMsg2.u1();
        int n3 = 0;
        while (n3 < n2) {
            this.util.version.props.put(soxMsg2.str(), soxMsg2.str());
            ++n3;
        }
        return this.util.version;
    }

    public synchronized Value readProp(SoxComponent soxComponent, Slot slot) throws Exception {
        this.checkMine(soxComponent);
        return this.readProp(soxComponent.id(), slot);
    }

    public synchronized Value readProp(int n, Slot slot) throws Exception {
        SoxMsg soxMsg = SoxMsg.prepareReq(114);
        soxMsg.u2(n);
        soxMsg.u1(slot.id);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(82);
        soxMsg2.u2();
        soxMsg2.u1();
        int n2 = soxMsg2.u1();
        Str str = slot.isAsStr() ? Str.make((String)"") : Value.defaultForType((int)n2);
        return str.decodeBinary((Buf)soxMsg2);
    }

    public synchronized SoxComponent loadApp() throws Exception {
        return this.load(0);
    }

    public synchronized SoxComponent load(int n) throws Exception {
        if (n < 0) {
            return null;
        }
        if (this.cache(n) != null) {
            return this.cache(n);
        }
        return this.load(new int[]{n})[0];
    }

    public synchronized SoxComponent[] load(int[] nArray) throws Exception {
        return this.load(nArray, true);
    }

    public synchronized SoxComponent[] load(int[] nArray, boolean bl) throws Exception {
        int n;
        this.readSchema();
        int n2 = nArray.length;
        SoxComponent[] soxComponentArray = new SoxComponent[n2];
        ArrayList<SoxMsg> arrayList = new ArrayList<SoxMsg>();
        int n3 = 0;
        while (n3 < n2) {
            n = nArray[n3];
            soxComponentArray[n3] = this.cache(n);
            if (soxComponentArray[n3] == null) {
                arrayList.add(SoxMsg.makeUpdateRequest(n, 116));
            }
            ++n3;
        }
        if (arrayList.size() == 0) {
            return soxComponentArray;
        }
        SoxMsg[] soxMsgArray = this.requests(arrayList.toArray(new SoxMsg[arrayList.size()]));
        n = 0;
        while (n < soxMsgArray.length) {
            SoxMsg soxMsg = soxMsgArray[n];
            if (bl || !soxMsg.isError()) {
                soxMsg.checkResponse(67);
                this.applyToCache(soxMsg);
            }
            ++n;
        }
        n = 0;
        while (n < n2) {
            int n4 = nArray[n];
            soxComponentArray[n] = this.cache(n4);
            if (bl && soxComponentArray[n] == null) {
                throw new IllegalStateException("" + n4);
            }
            ++n;
        }
        return soxComponentArray;
    }

    public synchronized SoxComponent update(SoxComponent soxComponent, int n) throws Exception {
        this.update(new SoxComponent[]{soxComponent}, n);
        return soxComponent;
    }

    public synchronized void update(SoxComponent[] soxComponentArray, int n) throws Exception {
        int n2;
        this.checkMine(soxComponentArray);
        ArrayList<SoxMsg> arrayList = new ArrayList<SoxMsg>();
        int n3 = 0;
        while (n3 < soxComponentArray.length) {
            n2 = soxComponentArray[n3].id;
            if ((n & 1) != 0) {
                arrayList.add(SoxMsg.makeUpdateRequest(n2, 116));
            }
            if ((n & 2) != 0) {
                arrayList.add(SoxMsg.makeUpdateRequest(n2, 99));
            }
            if ((n & 4) != 0) {
                arrayList.add(SoxMsg.makeUpdateRequest(n2, 114));
            }
            if ((n & 8) != 0) {
                arrayList.add(SoxMsg.makeUpdateRequest(n2, 108));
            }
            ++n3;
        }
        if (arrayList.size() == 0) {
            return;
        }
        SoxMsg[] soxMsgArray = this.requests(arrayList.toArray(new SoxMsg[arrayList.size()]));
        n2 = 0;
        while (n2 < soxMsgArray.length) {
            SoxMsg soxMsg = soxMsgArray[n2];
            soxMsg.checkResponse(67);
            this.applyToCache(soxMsg);
            ++n2;
        }
    }

    public synchronized void subscribeToAllTreeEvents() throws Exception {
        if (this.getSoxVersion() == null) {
            this.request(SoxMsg.makeSubscribeRequest(0, 97));
        } else {
            SoxMsg soxMsg = SoxMsg.prepareReq(115);
            soxMsg.u1(255);
            soxMsg.u1(0);
            this.request(soxMsg);
        }
        this.allTreeEvents = true;
        int n = 0;
        while (n < this.cache.length) {
            if (this.cache[n] != null) {
                this.cache[n].subscription |= 1;
            }
            ++n;
        }
    }

    public synchronized void subscribe(SoxComponent soxComponent, int n) throws Exception {
        this.subscribe(new SoxComponent[]{soxComponent}, n);
    }

    public synchronized void subscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        if (this.getSoxVersion() != null) {
            this.batchSubscribe(soxComponentArray, n, 5000L);
        } else {
            this.doSubscribe(soxComponentArray, n);
        }
    }

    public synchronized void subscribeAsync(SoxComponent[] soxComponentArray, int n) throws Exception {
        if (this.getSoxVersion() != null) {
            this.batchSubscribe(soxComponentArray, n, -1);
        } else {
            this.doSubscribe(soxComponentArray, n);
        }
    }

    private final Version getSoxVersion() {
        try {
            VersionInfo versionInfo = this.readVersion();
            return Version.parse((String)versionInfo.props.getProperty("soxVer"));
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void batchSubscribe(SoxComponent[] soxComponentArray, int n, long l) throws Exception {
        Object object;
        if (soxComponentArray.length > 255) {
            throw new SoxException("Cannot subscribe to more than 255 components: '" + soxComponentArray.length + '\'');
        }
        this.checkMine(soxComponentArray);
        ArrayList<SoxComponent> arrayList = new ArrayList<SoxComponent>();
        int n2 = 0;
        while (n2 < soxComponentArray.length) {
            object = soxComponentArray[n2];
            if ((object.subscription() & n) != n) {
                arrayList.add((SoxComponent)((Object)object));
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return;
        }
        SoxComponent[] soxComponentArray2 = arrayList.toArray(new SoxComponent[arrayList.size()]);
        object = SoxMsg.prepareReq(115);
        object.u1(n);
        object.u1(soxComponentArray2.length);
        int n3 = 0;
        while (n3 < soxComponentArray2.length) {
            object.u2(soxComponentArray2[n3].id);
            ++n3;
        }
        SoxMsg soxMsg = this.request((SoxMsg)((Object)object));
        soxMsg.checkResponse(83);
        if (l < 0L) {
            return;
        }
        Object object2 = this.subscribeSyncLock;
        synchronized (object2) {
            boolean[] blArray = new boolean[soxComponentArray2.length];
            long l2 = Env.ticks();
            int n4 = soxMsg.u1();
            block5: while (n4 > 0 && l2 + l > Env.ticks()) {
                this.subscribeSyncLock.wait(250L);
                int n5 = 0;
                while (true) {
                    SoxComponent soxComponent;
                    if (n5 >= soxComponentArray2.length) continue block5;
                    if (!blArray[n5] && (soxComponent = this.cache(soxComponentArray2[n5].id)) != null) {
                        boolean bl = false;
                        if ((soxComponent.subscription() & n) == n) {
                            bl = blArray[n5] = true;
                        }
                        if (bl) {
                            --n4;
                            l2 = System.currentTimeMillis();
                        }
                    }
                    ++n5;
                }
                break;
            }
            return;
        }
    }

    private final void doSubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        this.checkMine(soxComponentArray);
        ArrayList<SoxMsg> arrayList = new ArrayList<SoxMsg>();
        int n2 = 0;
        while (n2 < soxComponentArray.length) {
            SoxComponent soxComponent = soxComponentArray[n2];
            int n3 = soxComponent.id;
            int n4 = soxComponent.subscription();
            int n5 = n & ~n4;
            if ((n5 & 1) != 0) {
                arrayList.add(SoxMsg.makeSubscribeRequest(n3, 116));
            }
            if ((n5 & 2) != 0) {
                arrayList.add(SoxMsg.makeSubscribeRequest(n3, 99));
            }
            if ((n5 & 4) != 0) {
                arrayList.add(SoxMsg.makeSubscribeRequest(n3, 114));
            }
            if ((n5 & 8) != 0) {
                arrayList.add(SoxMsg.makeSubscribeRequest(n3, 108));
            }
            ++n2;
        }
        if (arrayList.size() == 0) {
            return;
        }
        SoxMsg[] soxMsgArray = this.requests(arrayList.toArray(new SoxMsg[arrayList.size()]));
        int n6 = 0;
        while (n6 < soxMsgArray.length) {
            SoxMsg soxMsg = soxMsgArray[n6];
            soxMsg.checkResponse(83);
            this.applyToCache(soxMsg);
            ++n6;
        }
        n6 = 0;
        while (n6 < soxComponentArray.length) {
            soxComponentArray[n6].subscription |= n;
            ++n6;
        }
    }

    public synchronized void unsubscribeToAllTreeEvents() throws Exception {
        if (this.isClosed()) {
            return;
        }
        if (this.getSoxVersion() == null) {
            this.request(SoxMsg.makeUnsubscribeRequest(0, 255));
        } else {
            SoxMsg soxMsg = SoxMsg.prepareReq(117);
            soxMsg.u1(255);
            soxMsg.u1(0);
            this.request(soxMsg);
        }
        this.allTreeEvents = false;
        int n = 0;
        while (n < this.cache.length) {
            if (this.cache[n] != null) {
                this.cache[n].subscription &= 0xFFFFFFFE;
            }
            ++n;
        }
    }

    public synchronized void unsubscribe(SoxComponent soxComponent, int n) throws Exception {
        this.unsubscribe(new SoxComponent[]{soxComponent}, n);
    }

    public synchronized void unsubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        this.checkMine(soxComponentArray);
        if (this.isClosed()) {
            return;
        }
        if (this.allTreeEvents) {
            n &= 0xFFFFFFFE;
        }
        ArrayList<SoxComponent> arrayList = new ArrayList<SoxComponent>();
        int n2 = 0;
        while (n2 < soxComponentArray.length) {
            if ((soxComponentArray[n2].subscription & n) != 0) {
                arrayList.add(soxComponentArray[n2]);
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            SoxComponent[] soxComponentArray2 = arrayList.toArray(new SoxComponent[arrayList.size()]);
            if (this.getSoxVersion() != null) {
                this.batchUnsubscribe(soxComponentArray2, n);
            } else {
                this.doUnsubscribe(soxComponentArray2, n);
            }
        }
        int n3 = 0;
        while (n3 < soxComponentArray.length) {
            soxComponentArray[n3].subscription &= ~n;
            ++n3;
        }
    }

    private final void batchUnsubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        SoxMsg soxMsg = SoxMsg.prepareReq(117);
        soxMsg.u1(n);
        soxMsg.u1(soxComponentArray.length);
        int n2 = 0;
        while (n2 < soxComponentArray.length) {
            soxMsg.u2(soxComponentArray[n2].id);
            ++n2;
        }
        this.request(soxMsg);
    }

    private final void doUnsubscribe(SoxComponent[] soxComponentArray, int n) throws Exception {
        SoxMsg[] soxMsgArray = new SoxMsg[soxComponentArray.length];
        int n2 = 0;
        while (n2 < soxComponentArray.length) {
            soxMsgArray[n2] = SoxMsg.makeUnsubscribeRequest(soxComponentArray[n2].id, n);
            ++n2;
        }
        this.requests(soxMsgArray);
    }

    public synchronized void invoke(SoxComponent soxComponent, Slot slot, Value value) throws Exception {
        this.checkMine(soxComponent);
        this.invoke(soxComponent.id, slot, value);
    }

    public synchronized void invoke(int n, Slot slot, Value value) throws Exception {
        if (!Component.testMode) {
            slot.assertValue(value);
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(105);
        soxMsg.u2(n);
        soxMsg.u1(slot.id);
        if (value != null) {
            value.encodeBinary((Buf)soxMsg);
        }
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(73);
    }

    public synchronized void write(SoxComponent soxComponent, Slot slot, Value value) throws Exception {
        this.checkMine(soxComponent);
        this.write(soxComponent.id, slot, value);
    }

    public synchronized void write(int n, Slot slot, Value value) throws Exception {
        if (!Component.testMode) {
            slot.assertValue(value);
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(119);
        soxMsg.u2(n);
        soxMsg.u1(slot.id);
        value.encodeBinary((Buf)soxMsg);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(87);
    }

    public synchronized SoxComponent add(SoxComponent soxComponent, Type type, String string, Value[] valueArray) throws Exception {
        int n;
        KitPart kitPart;
        KitPart kitPart2;
        Component.assertName((String)string);
        this.checkMine(soxComponent);
        if (soxComponent == null || soxComponent.client != this) {
            throw new IllegalArgumentException("Invalid parent");
        }
        if (soxComponent.children.length >= 200) {
            throw new IllegalArgumentException("Too many children under component");
        }
        if (type == null) {
            throw new IllegalArgumentException("Add error: invalid type");
        }
        if (type.schema != this.util.schema) {
            kitPart2 = type.kit.manifest.part();
            Kit kit = this.util.schema.kit(type.kit.name);
            if (kit == null) {
                throw new IllegalArgumentException("Schema does not support type: " + type);
            }
            kitPart = kit.manifest.part();
            if (!kitPart2.toString().equals(kitPart.toString())) {
                throw new IllegalArgumentException("Type's KitPart does not match client's: " + kitPart2 + " != " + kitPart);
            }
            type = this.util.schema.type(type.qname);
        }
        if (((KitPart)(kitPart2 = type.configProps())).length != valueArray.length) {
            throw new IllegalArgumentException("Config props don't match type's definition: " + type + " (" + ((KitPart)kitPart2).length + " != " + valueArray.length + ')');
        }
        int n2 = 0;
        while (n2 < valueArray.length) {
            kitPart = kitPart2[n2];
            n = valueArray[n2].typeId();
            if (kitPart.isAsStr() ? n != 101 : kitPart.type.id != n) {
                throw new IllegalArgumentException("Config props don't match type's definition: " + type + " (" + kitPart2[n2].name + ' ' + kitPart2[n2].type + " != " + valueArray[n2].getClass().getName() + ')');
            }
            ++n2;
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(97);
        soxMsg.u2(soxComponent.id);
        soxMsg.u1(type.kit.id);
        soxMsg.u1(type.id);
        soxMsg.str(string);
        int n3 = 0;
        while (n3 < valueArray.length) {
            valueArray[n3].encodeBinary((Buf)soxMsg);
            ++n3;
        }
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(65);
        n = soxMsg2.u2();
        SoxComponent soxComponent2 = new SoxComponent(this, n, type);
        this.cacheAdd(soxComponent2);
        soxComponent2.name = string;
        soxComponent2.parent = soxComponent.id;
        soxComponent2.setChildren(new int[0]);
        soxComponent.addChild(n);
        int n4 = 0;
        while (n4 < ((KitPart)kitPart2).length) {
            soxComponent2.set((Slot)kitPart2[n4], valueArray[n4]);
            ++n4;
        }
        return soxComponent2;
    }

    public synchronized void rename(SoxComponent soxComponent, String string) throws Exception {
        Component.assertName((String)string);
        this.checkMine(soxComponent);
        SoxMsg soxMsg = SoxMsg.prepareReq(110);
        soxMsg.u2(soxComponent.id);
        soxMsg.str(string);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(78);
        soxComponent.name = string;
    }

    public synchronized void reorder(SoxComponent soxComponent, int[] nArray) throws Exception {
        int[] nArray2 = (int[])nArray.clone();
        if (soxComponent.children.length != nArray2.length) {
            throw new IllegalArgumentException("childrenIds.length wrong");
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>(nArray2.length * 3);
        int n = 0;
        while (n < soxComponent.children.length) {
            hashMap.put(new Integer(soxComponent.children[n]), "x");
            ++n;
        }
        n = 0;
        while (n < nArray2.length) {
            if (hashMap.remove(new Integer(nArray2[n])) == null) {
                throw new IllegalArgumentException("childrenIds don't match current");
            }
            ++n;
        }
        if (hashMap.size() != 0) {
            throw new IllegalArgumentException("childrenIds don't match current");
        }
        SoxMsg soxMsg = SoxMsg.prepareReq(111);
        soxMsg.u2(soxComponent.id);
        soxMsg.u1(nArray2.length);
        int n2 = 0;
        while (n2 < nArray2.length) {
            soxMsg.u2(nArray2[n2]);
            ++n2;
        }
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(79);
        soxComponent.children = nArray2;
    }

    public synchronized void delete(SoxComponent soxComponent) throws Exception {
        this.checkMine(soxComponent);
        SoxMsg soxMsg = SoxMsg.prepareReq(100);
        soxMsg.u2(soxComponent.id);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(68);
        SoxComponent soxComponent2 = this.cache(soxComponent.parent);
        if (soxComponent2 != null) {
            soxComponent2.removeChild(soxComponent.id);
        }
        this.cacheRemove(soxComponent);
    }

    public synchronized void link(Link link) throws Exception {
        this.link(link, 97);
    }

    public synchronized void unlink(Link link) throws Exception {
        this.link(link, 100);
    }

    private final synchronized void link(Link link, int n) throws Exception {
        SoxMsg soxMsg = SoxMsg.prepareReq(108);
        soxMsg.u1(n);
        soxMsg.u2(link.fromCompId);
        soxMsg.u1(link.fromSlotId);
        soxMsg.u2(link.toCompId);
        soxMsg.u1(link.toSlotId);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(76);
    }

    public synchronized Link[] links(SoxComponent soxComponent) throws Exception {
        this.checkMine(soxComponent);
        return this.links(soxComponent.id);
    }

    public synchronized Link[] links(int n) throws Exception {
        SoxMsg soxMsg = SoxMsg.prepareReq(99);
        soxMsg.u2(n);
        soxMsg.u1(108);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(67);
        int n2 = soxMsg2.u2();
        if (n2 != n) {
            throw new SoxException("Response compId '" + n2 + "' does not match request '" + n + '\'');
        }
        int n3 = soxMsg2.u1();
        if (n3 != 108) {
            throw new SoxException("Response 'what' is not for links: '" + (char)n3 + '\'');
        }
        ArrayList<Link> arrayList = new ArrayList<Link>();
        while (true) {
            Link link = new Link();
            link.fromCompId = soxMsg2.u2();
            if (link.fromCompId == (char)-1) break;
            link.fromSlotId = soxMsg2.u1();
            link.toCompId = soxMsg2.u2();
            link.toSlotId = soxMsg2.u1();
            arrayList.add(link);
        }
        return arrayList.size() == 0 ? Link.none : arrayList.toArray(new Link[arrayList.size()]);
    }

    public synchronized int[] queryService(Type type) throws Exception {
        int n;
        SoxMsg soxMsg = SoxMsg.prepareReq(113);
        soxMsg.u1(115);
        soxMsg.u1(type.kit.id);
        soxMsg.u1(type.id);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(81);
        int[] nArray = new int[256];
        int n2 = 0;
        while ((n = soxMsg2.u2()) != (char)-1) {
            nArray[n2++] = n;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties getFile(String string, SoxFile soxFile, Properties properties, TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer(this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.getFile();
            Object var6_6 = null;
            this.fileTransfer = null;
            return properties2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileTransfer = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Properties putFile(String string, SoxFile soxFile, Properties properties, TransferListener transferListener) throws Exception {
        this.fileTransfer = new FileTransfer(this, string, soxFile, properties, transferListener);
        try {
            Properties properties2 = this.fileTransfer.putFile();
            Object var6_6 = null;
            this.fileTransfer = null;
            return properties2;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.fileTransfer = null;
            throw throwable;
        }
    }

    public synchronized void renameFile(String string, String string2) throws Exception {
        SoxMsg soxMsg = SoxMsg.prepareReq(98);
        soxMsg.str(string);
        soxMsg.str(string2);
        SoxMsg soxMsg2 = this.request(soxMsg);
        soxMsg2.checkResponse(66);
    }

    public Buf readPstoreFile(String string, SoxComponent soxComponent) throws Exception {
        if (soxComponent.getInt("status") != 0) {
            throw new Exception("PstoreFile.status not ok");
        }
        int n = soxComponent.getInt("resvOffset");
        int n2 = soxComponent.getInt("resvSize");
        Buf buf = new Buf(n2);
        Properties properties = new Properties();
        properties.put("fileSize", Integer.toString(n2));
        properties.put("offset", Integer.toString(n));
        this.getFile(string, SoxFile.make((Buf)buf), properties, null);
        if (buf.size != n2) {
            throw new IOException("Didn't read all of pstore: " + n2 + " != " + buf.size);
        }
        return buf;
    }

    public Buf readPstoreFile(SoxComponent soxComponent) throws Exception {
        SoxComponent soxComponent2 = this.load(soxComponent.parent);
        String string = "";
        try {
            string = this.readProp(soxComponent2, soxComponent2.slot("filename")).toString();
        }
        catch (Exception exception) {
            throw new Exception("PstoreFile parent not PstoreService: " + soxComponent2.type);
        }
        return this.readPstoreFile(string, soxComponent);
    }

    public void applyToCache(SoxMsg soxMsg) throws Exception {
        this.applyToCache(soxMsg, true);
    }

    public void applyToCache(SoxMsg soxMsg, boolean bl) throws Exception {
        boolean bl2 = false;
        if (soxMsg.command() == 101) {
            bl2 = true;
        }
        boolean bl3 = bl2;
        int n = soxMsg.u2();
        int n2 = soxMsg.u1();
        SoxComponent soxComponent = this.cache(n);
        SoxComponent soxComponent2 = this.util.apply(soxMsg, n, n2, soxComponent);
        if (soxComponent == null) {
            this.cacheAdd(soxComponent2);
        }
        if (bl3 && bl) {
            this.applyEvent(soxComponent2, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void applyEvent(SoxComponent soxComponent, int n) {
        if (soxComponent == null) {
            return;
        }
        int n2 = 0;
        switch (n) {
            case 116: {
                n2 = 1;
                break;
            }
            case 67: 
            case 99: {
                n2 = 2;
                break;
            }
            case 82: 
            case 114: {
                n2 = 4;
                break;
            }
            case 108: {
                n2 = 8;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown event: " + (char)n);
            }
        }
        if ((soxComponent.subscription & n2) != 0) return;
        Object object = this.subscribeSyncLock;
        synchronized (object) {
            soxComponent.subscription |= n2;
            this.subscribeSyncLock.notifyAll();
            return;
        }
    }

    private final SoxComponent cache(int n) {
        if (n >= 0 && n < this.cache.length) {
            return this.cache[n];
        }
        return null;
    }

    private final void cacheAdd(SoxComponent soxComponent) {
        if (soxComponent.id >= this.cache.length) {
            SoxComponent[] soxComponentArray = new SoxComponent[Math.max(this.cache.length * 2, soxComponent.id + 32)];
            System.arraycopy(this.cache, 0, soxComponentArray, 0, this.cache.length);
            this.cache = soxComponentArray;
        }
        this.cache[soxComponent.id] = soxComponent;
    }

    private final void cacheRemove(SoxComponent soxComponent) {
        int[] nArray = soxComponent.childrenIds();
        int n = 0;
        while (n < nArray.length) {
            SoxComponent soxComponent2 = this.cache(nArray[n]);
            if (soxComponent2 != null) {
                this.cacheRemove(soxComponent2);
            }
            ++n;
        }
        this.cache[soxComponent.id] = null;
    }

    private final void checkMine(SoxComponent soxComponent) {
        if (soxComponent.client != this) {
            throw new IllegalArgumentException("SoxComponent.client != this client");
        }
    }

    private final void checkMine(SoxComponent[] soxComponentArray) {
        int n = 0;
        while (n < soxComponentArray.length) {
            this.checkMine(soxComponentArray[n]);
            ++n;
        }
    }

    void send(SoxMsg soxMsg) throws Exception {
        this.device.getCommunicator().comm().sendResponse(this.device, soxMsg);
    }

    SoxMsg request(SoxMsg soxMsg) throws Exception {
        return this.requests(new SoxMsg[]{soxMsg})[0];
    }

    SoxMsg[] requests(SoxMsg[] soxMsgArray) throws Exception {
        this.requests = soxMsgArray;
        this.responses = new SoxMsg[soxMsgArray.length];
        int n = 0;
        while (n < soxMsgArray.length) {
            this.responses[n] = this.device.getCommunicator().comm().sendRequest(this.device, soxMsgArray[n]);
            ++n;
        }
        return this.responses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addListener(Listener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.add(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeListener(Listener listener) {
        Vector vector = this.listeners;
        synchronized (vector) {
            this.listeners.remove(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closed() {
        Vector vector = this.listeners;
        synchronized (vector) {
            int n = 0;
            while (n < this.listeners.size()) {
                ((Listener)this.listeners.get(n)).soxClientClosed(this);
                ++n;
            }
            return;
        }
    }

    void checkOpen() {
        if (this.isClosed()) {
            throw new SoxException("SoxClient closed: " + this.closeCause);
        }
    }

    public FileTransfer getFileTransfer() {
        return this.fileTransfer;
    }

    public void initOptions() {
        try {
            this.traceMsg = Env.getProperty((String)"sox.traceMsg", (boolean)this.traceMsg);
            this.traceXferStats = Env.getProperty((String)"sox.xfer.traceStats", (boolean)this.traceXferStats);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void printOptions() {
        this.printOptions(new PrintWriter(System.out));
    }

    public void printOptions(PrintWriter printWriter) {
        printWriter.println("  traceMsg        = " + this.traceMsg);
        printWriter.println("  xfer.traceStats = " + this.traceXferStats);
        printWriter.flush();
    }

    private final /* synthetic */ void this() {
        this.traceMsg = false;
        this.traceXferStats = false;
        this.closeCause = "never opened";
        this.cache = new SoxComponent[1024];
        this.listeners = new Vector();
        this.subscribeSyncLock = new Object();
    }

    public SoxClient(BIsmaSoxDevice bIsmaSoxDevice) {
        this.this();
        this.device = bIsmaSoxDevice;
        this.session = bIsmaSoxDevice.getDaspSession();
        this.util = new SoxUtil(this);
    }

    public static interface Listener {
        public void soxClientClosed(SoxClient var1);
    }

    public static interface TransferListener {
        public void progress(int var1, int var2);
    }
}

