/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.point;

import com.gc5.BIsmaSoxDevice;
import com.gc5.BIsmaSoxNetwork;
import com.gc5.comm.NoSessionException;
import com.gc5.comm.SoxComponent;
import com.gc5.comm.SoxMsg;
import com.gc5.comm.TimeOutException;
import com.gc5.core.BIsmaSoxCommunicator;
import com.gc5.point.BIsmaSoxPointDeviceExt;
import com.gc5.point.BIsmaSoxTuningPolicy;
import com.gc5.util.PointUtil;
import com.gc5.util.TextUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BNumericPoint;
import javax.baja.driver.point.BProxyExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBlob;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;
import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.Long;
import sedona.Schema;
import sedona.Short;
import sedona.Slot;
import sedona.Str;
import sedona.Value;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BIsmaSoxProxyExt
extends BProxyExt
implements BIPollable {
    public static final Property address = BIsmaSoxProxyExt.newProperty((int)0, (String)"", null);
    public static final Property config = BIsmaSoxProxyExt.newProperty((int)1, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"config"), (BFacets)BFacets.make((String)"falseText", (String)"runtime")));
    public static final Property typeId = BIsmaSoxProxyExt.newProperty((int)4, (int)-1, null);
    public static final Property asStr = BIsmaSoxProxyExt.newProperty((int)1, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"Str"), (BFacets)BFacets.make((String)"falseText", (String)"Buf")));
    public static final Action poll = BIsmaSoxProxyExt.newAction((int)20, null);
    public static final Type TYPE;
    private static final String SEDONA_BOOL_FALSE = "false";
    private static final String SEDONA_BOOL_TRUE = "true";
    private static final String SEDONA_BOOL_NULL = "sedonaNull";
    public static final BEnumRange SEDONA_BOOL_RANGE;
    int compId;
    int propId;
    Boolean cfg;
    boolean polled;
    static /* synthetic */ Class class$com$gc5$point$BIsmaSoxProxyExt;

    public String getAddress() {
        return this.getString(address);
    }

    public void setAddress(String string) {
        this.setString(address, string, null);
    }

    public boolean getConfig() {
        return this.getBoolean(config);
    }

    public void setConfig(boolean bl) {
        this.setBoolean(config, bl, null);
    }

    public int getTypeId() {
        return this.getInt(typeId);
    }

    public void setTypeId(int n) {
        this.setInt(typeId, n, null);
    }

    public boolean getAsStr() {
        return this.getBoolean(asStr);
    }

    public void setAsStr(boolean bl) {
        this.setBoolean(asStr, bl, null);
    }

    public void poll() {
        this.invoke(poll, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final BIsmaSoxNetwork getSoxNetwork() {
        return (BIsmaSoxNetwork)this.getNetwork();
    }

    public final BIsmaSoxCommunicator getCommunicator() {
        return this.getSoxDevice().getCommunicator();
    }

    public final BIsmaSoxDevice getSoxDevice() {
        return (BIsmaSoxDevice)this.getDevice();
    }

    public final BIsmaSoxPointDeviceExt getSoxPointDeviceExt() {
        return (BIsmaSoxPointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BIsmaSoxPointDeviceExt.TYPE;
    }

    protected void setReadStatus(BStatusValue bStatusValue) {
    }

    public String toString(Context context) {
        BComplex bComplex = this.getParent();
        return (bComplex != null ? bComplex.getName() : "---") + ':' + this.getAddress();
    }

    public BReadWriteMode getMode() {
        return this.getParentPoint().isWritablePoint() ? BReadWriteMode.readWrite : BReadWriteMode.readonly;
    }

    public void started() throws Exception {
        super.started();
        this.getComponentId();
        this.getPropId();
        this.getCfg();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning()) {
            return;
        }
        try {
            if (property.equals((Object)address)) {
                this.checkResubscribe(context, true);
            } else if (property.equals((Object)config) || property.equals((Object)tuningPolicyName)) {
                this.checkResubscribe(context, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void readSubscribed(Context context) throws Exception {
        if (this.isFatalFault()) {
            return;
        }
        BIsmaSoxTuningPolicy bIsmaSoxTuningPolicy = this.getSoxTuningPolicy();
        if (bIsmaSoxTuningPolicy.isSoxEvent()) {
            this.getCommunicator().postAsync(new Async(this, context, false){

                public final void run() {
                    BIsmaSoxProxyExt.this.doReadSubscribed(this.device, this.cx);
                }
            });
        } else if (bIsmaSoxTuningPolicy.isSoxPolled()) {
            this.getSoxNetwork().getPollScheduler().subscribe(this);
        }
    }

    public void readUnsubscribed(Context context) throws Exception {
        this.getSoxDevice().unwatchPoint(this, context);
        this.getSoxNetwork().getCovScheduler().unsubscribe(this);
        this.getSoxNetwork().getPollScheduler().unsubscribe(this);
    }

    void doReadSubscribed(BIsmaSoxDevice bIsmaSoxDevice, Context context) {
        this.getSoxNetwork().getCovScheduler().subscribe(this);
        try {
            bIsmaSoxDevice.watchPoint(this, context);
        }
        catch (Schema.MissingKitManifestException missingKitManifestException) {
            Lexicon lexicon = Lexicon.make(super.getClass());
            Object[] objectArray = new Object[]{missingKitManifestException.parts.toString()};
            String string = lexicon.getText("missingKitManifest", objectArray);
            this.readFail(string);
        }
        catch (Exception exception) {
            String string = exception.getMessage();
            if (string != null) {
                this.readFail(exception.getMessage());
            }
            this.readFail(exception.toString());
        }
    }

    void doProxyChanged(Context context, boolean bl) throws Exception {
        this.readUnsubscribed(context);
        if (bl) {
            this.compId = -1;
            this.propId = -1;
            this.cfg = null;
            this.setTypeId(-1);
        }
        if (this.getSoxTuningPolicy().isSoxEvent()) {
            this.doReadSubscribed(this.getSoxDevice(), context);
        } else {
            this.readSubscribed(context);
        }
    }

    public void tuningChanged(BIsmaSoxTuningPolicy bIsmaSoxTuningPolicy, Context context) {
        if (!this.isRunning()) {
            return;
        }
        try {
            if (bIsmaSoxTuningPolicy == null || bIsmaSoxTuningPolicy == this.getTuningPolicy()) {
                this.checkResubscribe(context, false);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private final void checkResubscribe(Context context, boolean bl) {
        try {
            if (this.getEnabled() && this.isSubscribedDesired()) {
                this.getCommunicator().postAsync(new Async(this, context, bl){

                    public final void run() {
                        try {
                            BIsmaSoxProxyExt.this.doProxyChanged(this.cx, this.flag);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean write(Context context) throws Exception {
        if (!this.isRunning()) {
            return false;
        }
        try {
            this.getCommunicator().postWrite(new Async(this, context, false){

                public final void run() {
                    BIsmaSoxProxyExt.this.doWrite(this.cx);
                }
            });
        }
        catch (Throwable throwable) {
            this.doWrite(context);
        }
        return false;
    }

    void doWrite(Context context) {
        if (this.isUnoperational()) {
            return;
        }
        this.doWriteSox(context);
    }

    private final void doWriteSox(Context context) {
        int n = this.getTypeId();
        if (n < 0) {
            this.writeFail("Type Id not yet read.");
            return;
        }
        try {
            BStatusValue bStatusValue = this.getWriteValue();
            BBoolean bBoolean = null;
            if (bStatusValue instanceof BStatusBoolean) {
                bBoolean = bStatusValue.getStatus().isNull() ? null : BBoolean.make((boolean)((BStatusBoolean)bStatusValue).getValue());
            } else if (bStatusValue instanceof BStatusNumeric) {
                bBoolean = bStatusValue.getStatus().isNull() ? BDouble.NaN : BDouble.make((double)((BStatusNumeric)bStatusValue).getValue());
            } else if (bStatusValue instanceof BStatusEnum) {
                int n2 = ((BStatusEnum)bStatusValue).getValue().getOrdinal();
                if (n == 1) {
                    switch (n2) {
                        case 0: {
                            bBoolean = BBoolean.FALSE;
                            break;
                        }
                        case 1: {
                            bBoolean = BBoolean.TRUE;
                            break;
                        }
                        case 2: {
                            bBoolean = null;
                        }
                    }
                } else {
                    bBoolean = BInteger.make((int)((BStatusEnum)bStatusValue).getValue().getOrdinal());
                }
            } else {
                if (this.getAsStr()) {
                    n = 101;
                }
                bBoolean = BString.make((String)bStatusValue.valueToString(context));
            }
            SoxMsg soxMsg = SoxMsg.make(119);
            soxMsg.u2(this.getComponentId());
            soxMsg.u1(this.getPropId());
            soxMsg.writeValue((BSimple)bBoolean, n);
            SoxMsg soxMsg2 = this.getCommunicator().comm().sendRequest(this.getSoxDevice(), soxMsg);
            if (!soxMsg2.isFailed()) {
                if (bStatusValue.getType() == this.getWriteValue().getType()) {
                    this.setReadStatus(bStatusValue);
                    this.writeOk(bStatusValue);
                    this.readOk(bStatusValue);
                    if (this.getSoxTuningPolicy().isSoxPolled()) {
                        this.doPoll();
                    }
                } else {
                    this.writeFail("Point dataType does not match.");
                }
            } else {
                soxMsg2.seek(2);
                this.writeFail("Sox write Error:" + soxMsg2.str());
            }
        }
        catch (TimeOutException timeOutException) {
            this.writeFail("Sox timeout.");
        }
        catch (Exception exception) {
            this.getCommunicator().getLog().trace("Exception writing " + (Object)((Object)this) + " via Sox:", (Throwable)exception);
            if (exception instanceof ClassCastException) {
                this.configFatal("Point dataType does not match.");
            }
            this.writeFail(exception.toString());
        }
    }

    public BPollFrequency getPollFrequency() {
        return ((BIsmaSoxTuningPolicy)this.getTuningPolicy()).getPollFrequency();
    }

    public final BIsmaSoxTuningPolicy getSoxTuningPolicy() {
        return (BIsmaSoxTuningPolicy)this.getTuningPolicy();
    }

    public void doPoll() {
        if (this.isUnoperational()) {
            return;
        }
        BIsmaSoxDevice bIsmaSoxDevice = this.getSoxDevice();
        if (bIsmaSoxDevice.isDown()) {
            return;
        }
        if (!bIsmaSoxDevice.getEnabled()) {
            return;
        }
        if (!this.getEnabled()) {
            return;
        }
        this.doPollSox();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doPollSox() {
        int n = this.getComponentId();
        int n2 = this.getPropId();
        if (n < 0 || n2 < 0) {
            this.readFail("Invalid address");
            return;
        }
        BIsmaSoxDevice bIsmaSoxDevice = (BIsmaSoxDevice)this.getDevice();
        try {
            int n3;
            SoxMsg soxMsg = SoxMsg.make(114);
            soxMsg.u2(n);
            soxMsg.u1(n2);
            SoxMsg soxMsg2 = this.getCommunicator().comm().sendRequest(bIsmaSoxDevice, soxMsg);
            if (soxMsg2 == null) {
                throw new TimeOutException("No response.");
            }
            if (soxMsg2.u1() == 33) {
                this.readFail(soxMsg2.str());
                return;
            }
            soxMsg2.u1();
            if (soxMsg2.u2() != n) {
                this.getCommunicator().getLog().message("Response has invalid component Id.");
            }
            if (soxMsg2.u1() != n2) {
                this.getCommunicator().getLog().message("Response has invalid property Id.");
            }
            if (!this.isSoxTypeOk(n3 = soxMsg2.read())) {
                this.readFail("Wrong proxy type for Sedona " + sedona.Type.predefinedName((int)n3));
                return;
            }
            this.setTypeId(n3);
            BSimple bSimple = soxMsg2.readValue(this.getTypeId());
            boolean bl = this.getParentPoint().getType().is(BEnumPoint.TYPE);
            BStatusBoolean bStatusBoolean = null;
            if (bSimple == null) {
                if (this.getParentPoint().getType().is(BEnumPoint.TYPE)) {
                    bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)2, (BEnumRange)SEDONA_BOOL_RANGE));
                } else if (this.getParentPoint().getType().is(BBooleanPoint.TYPE)) {
                    bStatusBoolean = new BStatusBoolean();
                    ((BStatusValue)bStatusBoolean).setStatusNull(true);
                } else if (this.getParentPoint().getType().is(BNumericPoint.TYPE)) {
                    bStatusBoolean = new BStatusNumeric();
                    ((BStatusValue)bStatusBoolean).setStatusNull(true);
                }
            } else if (bSimple instanceof BBoolean) {
                if (bl) {
                    int n4 = ((BBoolean)bSimple).getOrdinal();
                    bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)n4, (BEnumRange)SEDONA_BOOL_RANGE));
                } else {
                    bStatusBoolean = new BStatusBoolean(((BBoolean)bSimple).getBoolean());
                }
            } else if (bSimple instanceof BNumber) {
                if (bl) {
                    BEnumRange bEnumRange = ((BStatusEnum)this.getParentPoint().getOutStatusValue()).getValue().getRange();
                    bStatusBoolean = new BStatusEnum((BEnum)BDynamicEnum.make((int)((BNumber)bSimple).getInt(), (BEnumRange)bEnumRange));
                } else {
                    bStatusBoolean = new BStatusNumeric(((BNumber)bSimple).getDouble());
                }
            } else {
                bStatusBoolean = bSimple instanceof BBlob ? (this.getAsStr() ? new BStatusString(BIsmaSoxProxyExt.toStr(new Buf(((BBlob)bSimple).copyBytes()))) : new BStatusString(BIsmaSoxProxyExt.toStr(((BBlob)bSimple).copyBytes()))) : new BStatusString(bSimple.toString());
            }
            this.setReadStatus((BStatusValue)bStatusBoolean);
            if (!((BStatusValue)bStatusBoolean).getType().is(this.getReadValue().getType())) {
                this.readFail("Wrong point type:" + bStatusBoolean);
            } else {
                this.readOk((BStatusValue)bStatusBoolean);
            }
        }
        catch (TimeOutException timeOutException) {
            this.getCommunicator().getLog().trace("Timeout polling " + (Object)((Object)this) + " in " + (Object)((Object)bIsmaSoxDevice));
            this.readFail(timeOutException.getMessage());
            bIsmaSoxDevice.ping();
        }
        catch (NoSessionException noSessionException) {
            this.getCommunicator().getLog().trace("NoSessionException polling " + (Object)((Object)this) + " in " + (Object)((Object)bIsmaSoxDevice) + " via Sox:" + (Object)((Object)noSessionException));
            this.readFail(noSessionException.getMessage());
            bIsmaSoxDevice.doPing();
        }
        catch (Throwable throwable) {
            this.getCommunicator().getLog().trace("Exception polling " + (Object)((Object)this) + " in " + (Object)((Object)bIsmaSoxDevice) + " via Sox:", throwable);
            this.readFail(throwable.toString());
            bIsmaSoxDevice.ping();
        }
        try {
            Object var7_11 = null;
            bIsmaSoxDevice = null;
            return;
        }
        catch (Throwable throwable) {
            Object var7_12 = null;
            bIsmaSoxDevice = null;
            throw throwable;
        }
    }

    public void update(SoxComponent soxComponent) {
        if (!this.isRunning() || this.isUnoperational() || !this.getEnabled()) {
            return;
        }
        try {
            Object object;
            int n = this.getPropId();
            Slot slot = soxComponent.type.slot(n);
            Value value = soxComponent.get(slot);
            BBoolean bBoolean = null;
            this.setConfig(slot.isConfig());
            int n2 = value.typeId();
            if (!this.isSoxTypeOk(n2)) {
                this.readFail("Datatype mismatch: Wrong proxy type for Sedona " + sedona.Type.predefinedName((int)n2));
                return;
            }
            this.setTypeId(n2);
            switch (this.getTypeId()) {
                case 0: {
                    break;
                }
                case 1: {
                    bBoolean = BBoolean.make((boolean)((Bool)value).val);
                    break;
                }
                case 2: {
                    bBoolean = BInteger.make((int)((Byte)value).val);
                    break;
                }
                case 3: {
                    bBoolean = BInteger.make((int)((Short)value).val);
                    break;
                }
                case 4: {
                    bBoolean = BInteger.make((int)((Int)value).val);
                    break;
                }
                case 5: {
                    bBoolean = BLong.make((long)((Long)value).val);
                    break;
                }
                case 6: {
                    bBoolean = BDouble.make((double)((Float)value).val);
                    break;
                }
                case 7: {
                    bBoolean = BDouble.make((double)((Double)value).val);
                    break;
                }
                case 9: 
                case 101: {
                    bBoolean = BString.make((String)((Str)value).toString());
                    break;
                }
                case 8: {
                    object = (Buf)value;
                    try {
                        String string = slot.isAsStr() ? BIsmaSoxProxyExt.toStr(object) : BIsmaSoxProxyExt.toStr(object.bytes);
                        bBoolean = BString.make((String)string);
                    }
                    catch (Exception exception) {
                        this.getCommunicator().getLog().message("Exception processing buf[" + object.size + "] for " + (Object)((Object)this) + ':' + exception);
                        bBoolean = BString.make((String)("err:" + object.dumpToString()));
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown value type " + typeId + '\'' + (char)this.getTypeId() + '\'');
                }
            }
            object = this.getParentPoint().getOutStatusValue();
            boolean bl = ((BStatusValue)object).getType().is(BStatusEnum.TYPE);
            if (bBoolean instanceof BBoolean) {
                if (bl) {
                    Bool bool = (Bool)value;
                    int n3 = 0;
                    if (bool.val) {
                        n3 = 1;
                    }
                    if (value.isNull()) {
                        n3 = 2;
                    }
                    object = new BStatusEnum((BEnum)BDynamicEnum.make((int)n3, (BEnumRange)SEDONA_BOOL_RANGE));
                } else {
                    object = new BStatusBoolean(bBoolean.getBoolean());
                    if (value.typeId() == 1) {
                        ((BStatusValue)object).setStatusNull(value.isNull());
                    }
                }
            } else if (bBoolean instanceof BNumber) {
                if (bl) {
                    BEnumRange bEnumRange = ((BStatusEnum)object).getValue().getRange();
                    object = new BStatusEnum((BEnum)BDynamicEnum.make((int)((BNumber)bBoolean).getInt(), (BEnumRange)bEnumRange));
                } else {
                    object = new BStatusNumeric(((BNumber)bBoolean).getDouble());
                }
            } else {
                object = bBoolean instanceof BDynamicEnum ? new BStatusEnum((BEnum)((BDynamicEnum)bBoolean)) : new BStatusString(((BSimple)bBoolean).toString());
            }
            if (((BStatusValue)object).getType() == this.getReadValue().getType()) {
                this.readOk((BStatusValue)object);
            } else {
                this.readFail("Point dataType does not match, check the controller database");
            }
        }
        catch (Exception exception) {
            this.getCommunicator().getLog().trace("Exception processing Sox update:", (Throwable)exception);
            this.readFail(exception.toString());
        }
    }

    static String toStr(Buf buf) throws IOException {
        byte[] byArray = buf.bytes;
        int n = buf.size;
        boolean bl = false;
        int n2 = n;
        while (--n2 >= 0) {
            if (byArray[n2] != 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            String string = buf.str();
            if (string.length() < buf.size - 1) {
                return BIsmaSoxProxyExt.toStr(byArray);
            }
            return string;
        }
        return BIsmaSoxProxyExt.toStr(byArray);
    }

    static String toStr(byte[] byArray) {
        int n = byArray.length;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        int n2 = 0;
        while (n2 < n) {
            if (n2 % 4 == 0) {
                printWriter.print(' ');
            }
            printWriter.print(TextUtil.byteToHexString(byArray[n2] & 0xFF));
            ++n2;
        }
        printWriter.flush();
        return stringWriter.toString();
    }

    public int getComponentId() {
        if (this.compId == -1) {
            this.compId = PointUtil.getComponentId(this.getAddress());
        }
        return this.compId;
    }

    public int getPropId() {
        if (this.propId == -1) {
            this.propId = PointUtil.getPropId(this.getAddress());
        }
        return this.propId;
    }

    public boolean getCfg() {
        if (this.cfg == null) {
            this.cfg = new Boolean(this.getConfig());
        }
        return this.cfg;
    }

    private final boolean isSoxTypeOk(int n) {
        Type type = this.getParentPoint().getOutStatusValue().getType();
        if (n < 0 || n > 101) {
            return false;
        }
        switch (n) {
            case 0: {
                return true;
            }
            case 1: {
                boolean bl = false;
                if (type == BStatusBoolean.TYPE || type == BStatusEnum.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                boolean bl = false;
                if (type == BStatusNumeric.TYPE || type == BStatusEnum.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 6: 
            case 7: {
                boolean bl = false;
                if (type == BStatusNumeric.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 101: {
                boolean bl = false;
                if (type == BStatusString.TYPE) {
                    bl = true;
                }
                return bl;
            }
            case 8: {
                return true;
            }
        }
        return true;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.compId = -1;
        this.propId = -1;
        this.cfg = null;
        this.polled = false;
    }

    public BIsmaSoxProxyExt() {
        this.this();
    }

    static {
        Class clazz = class$com$gc5$point$BIsmaSoxProxyExt;
        if (clazz == null) {
            clazz = class$com$gc5$point$BIsmaSoxProxyExt = BIsmaSoxProxyExt.class("[Lcom.gc5.point.BIsmaSoxProxyExt;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        SEDONA_BOOL_RANGE = BEnumRange.make((String[])new String[]{SEDONA_BOOL_FALSE, SEDONA_BOOL_TRUE, SEDONA_BOOL_NULL});
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Async
    implements Runnable {
        BIsmaSoxCommunicator communicator;
        BIsmaSoxDevice device;
        Context cx;
        boolean flag;

        public void run() {
        }

        Async(Context context, boolean bl) {
            this.cx = context;
            this.flag = bl;
            this.communicator = BIsmaSoxProxyExt.this.getCommunicator();
            this.device = BIsmaSoxProxyExt.this.getSoxDevice();
        }
    }
}

