/*
 * Decompiled with CFR 0.152.
 */
package com.gc5.util;

import com.gc5.util.Base64;
import com.gc5.util.LicenseFeature;
import com.gc5.util.TextUtil;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.license.Feature;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class LicUtil {
    public static final byte[] set = new byte[]{47, 69, 72, 69, 73, 68, 42};
    public static String vendor = "";
    public static String key = "";
    public static String hostId = "";
    public static String generatedDate = "";
    public static boolean generatedDateInvalid = false;
    public static String expireDate = "";
    public static boolean licenseExpired = false;
    public static String uiExpireDate = "";
    public static boolean uiExpired = false;
    public static String uiSignature = "";
    public static String driverExpireDate = "";
    public static boolean driverExpired = false;
    public static String driverDeviceLimit = "";
    public static String driverPointLimit = "";
    public static String driverHistoryLimit = "";
    public static String driverScheduleLimit = "";
    public static String driverSignature = "";
    public static HashMap features;
    public static Feature feature;

    public static void load() {
        BFileSystem bFileSystem = null;
        XParser xParser = null;
        try {
            String string = Sys.getHostId();
            FilePath filePath = new FilePath("!licenses/Isma.license");
            bFileSystem = BFileSystem.INSTANCE;
            BIFile bIFile = bFileSystem.findFile(filePath);
            if (bIFile == null || bIFile.getSize() <= 0L) {
                filePath = new FilePath("!licenses/Isma_" + string + ".license");
                bIFile = bFileSystem.findFile(filePath);
            }
            if (bIFile != null && bIFile.getSize() > 0L) {
                xParser = XParser.make((InputStream)bIFile.getInputStream());
                LicUtil.decodeLicense(xParser.parse(true));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void decodeLicense(XElem xElem) throws IOException {
        BAbsTime bAbsTime = BAbsTime.now();
        vendor = xElem.get("vendor", "");
        hostId = xElem.get("hostId", "");
        generatedDate = xElem.get("generated", "");
        expireDate = xElem.get("expiration", "");
        licenseExpired = LicUtil.isExpired(LicUtil.parseDate(expireDate));
        XElem[] xElemArray = xElem.elems();
        int n = 0;
        while (n < xElemArray.length) {
            String string;
            if (xElemArray[n].get("name", "").equals("about")) {
                string = xElemArray[n].get("project", "");
                String string2 = xElemArray[n].get("owner", "");
            } else if (xElemArray[n].get("name", "").equals("ismaUI")) {
                uiExpireDate = xElemArray[n].get("expiration", "");
                uiExpired = LicUtil.isExpired(LicUtil.parseDate(uiExpireDate));
                uiSignature = Base64.decodeToString(xElemArray[n].get("key", ""));
            } else if (xElemArray[n].get("name", "").equals("ismaSoxDriver")) {
                driverExpireDate = xElemArray[n].get("expiration", "");
                driverExpired = LicUtil.isExpired(LicUtil.parseDate(driverExpireDate));
                driverDeviceLimit = xElemArray[n].get("device.limit", "");
                driverPointLimit = xElemArray[n].get("point.limit", "");
                driverHistoryLimit = xElemArray[n].get("history.limit", "");
                driverScheduleLimit = xElemArray[n].get("schedule.limit", "");
                string = xElemArray[n].get("name");
                long l = Long.MAX_VALUE;
                String string3 = xElemArray[n].get("expiration", null);
                if (string3 != null) {
                    l = LicUtil.parseDate(string3);
                }
                if (!LicUtil.isExpired(l)) {
                    features = new HashMap();
                    key = LicUtil.toKey(vendor, string);
                    LicenseFeature licenseFeature = new LicenseFeature(vendor, string, LicUtil.parseDate(driverExpireDate));
                    features.put(key, licenseFeature);
                    feature = (Feature)features.get(key);
                    int n2 = 0;
                    while (n2 < xElemArray[n].attrSize()) {
                        String string4 = xElemArray[n].attrName(n2);
                        String string5 = xElemArray[n].attrValue(n2);
                        if (!string4.equals("name") && !string4.equals("expiration")) {
                            if (licenseFeature.props == LicenseFeature.noProps) {
                                licenseFeature.props = new Properties();
                            }
                            licenseFeature.props.put(string4, string5);
                        }
                        ++n2;
                    }
                }
            } else {
                driverSignature = Base64.decodeToString(xElemArray[n].string());
            }
            ++n;
        }
    }

    public static String toKey(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(TextUtil.toLowerCase(string)).append(':').append(TextUtil.toLowerCase(string2));
        return stringBuffer.toString();
    }

    public static long parseDate(String string) {
        if (string.equalsIgnoreCase("never")) {
            return Long.MAX_VALUE;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "- ");
        int n = Integer.parseInt(stringTokenizer.nextToken()) - 1900;
        int n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
        int n3 = Integer.parseInt(stringTokenizer.nextToken());
        Date date = new GregorianCalendar(n + 1900, n2, n3, 23, 59).getTime();
        return date.getTime();
    }

    public static String formatDate(long l) {
        if (l == Long.MAX_VALUE) {
            return "never";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date(l));
    }

    private static final boolean isExpired(long l) {
        boolean bl = false;
        if (l < Clock.millis()) {
            bl = true;
        }
        return bl;
    }
}

