/*
 * Decompiled with CFR 0.152.
 */
package sedonac.analysis;

import java.util.HashSet;
import java.util.Set;
import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.analysis.BasicBlock;
import sedonac.analysis.ControlFlowGraph;
import sedonac.ast.Expr;
import sedonac.ast.Stmt;

public abstract class CfgStep
extends CompilerStep {
    protected final ControlFlowGraph cfg;

    protected void analyzeBlock(BasicBlock basicBlock) {
        Stmt[] stmtArray = basicBlock.stmts();
        int n = 0;
        while (n < stmtArray.length) {
            this.analyzeStatement(stmtArray[n]);
            ++n;
        }
    }

    protected void analyzeStatement(Stmt stmt) {
        switch (stmt.id) {
            case 2: {
                this.localDefStmt((Stmt.LocalDef)stmt);
                break;
            }
            case 1: {
                this.doExpr(((Stmt.ExprStmt)stmt).expr);
                break;
            }
            case 11: {
                this.doExpr(((Stmt.Assert)stmt).cond);
                break;
            }
            case 4: {
                this.doExpr(((Stmt.If)stmt).cond);
                break;
            }
            case 13: {
                this.doExpr(((Stmt.Switch)stmt).cond);
                break;
            }
            case 8: {
                this.doExpr(((Stmt.DoWhile)stmt).cond);
                break;
            }
            case 7: {
                this.doExpr(((Stmt.While)stmt).cond);
                break;
            }
            case 3: {
                this.doExpr(((Stmt.Return)stmt).expr);
                break;
            }
            case 5: {
                this.forStmt((Stmt.For)stmt);
                break;
            }
            case 6: {
                this.forEachStmt((Stmt.Foreach)stmt);
                break;
            }
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Statement: " + stmt.loc);
            }
        }
    }

    protected void localDefStmt(Stmt.LocalDef localDef) {
        this.doExpr(localDef.init);
    }

    protected void forEachStmt(Stmt.Foreach foreach) {
        this.doExpr(foreach.array);
        this.doExpr(foreach.length);
    }

    private final void forStmt(Stmt.For for_) {
        this.doExpr(for_.cond);
    }

    protected void doExpr(Expr expr) {
        if (expr == null || expr.isLiteral()) {
            return;
        }
        switch (expr.id) {
            case 60: {
                this.localExpr((Expr.Local)expr);
                break;
            }
            case 65: 
            case 71: {
                this.callExpr((Expr.Call)expr);
                break;
            }
            case 45: {
                this.assignExpr((Expr.Binary)expr);
                break;
            }
            case 64: {
                this.indexExpr((Expr.Index)expr);
                break;
            }
            case 72: {
                this.interpolationExpr((Expr.Interpolation)expr);
                break;
            }
            case 27: 
            case 28: {
                this.condExpr((Expr.Cond)expr);
                break;
            }
            case 57: {
                this.ternaryExpr((Expr.Ternary)expr);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                this.unaryExpr((Expr.Unary)expr);
                break;
            }
            case 66: {
                this.castExpr((Expr.Cast)expr);
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 75: {
                this.binaryExpr((Expr.Binary)expr);
                break;
            }
            case 73: {
                this.doExpr(((Expr.New)expr).arrayLength);
                break;
            }
            case 74: {
                this.doExpr(((Expr.Delete)expr).target);
                break;
            }
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled expression: " + this.cfg.method.name + ' ' + expr.id + ' ' + expr + '\n' + expr.loc);
            }
        }
    }

    protected void localExpr(Expr.Local local) {
    }

    protected void callExpr(Expr.Call call) {
        int n = 0;
        while (n < call.args.length) {
            this.doExpr(call.args[n]);
            ++n;
        }
        this.doExpr(call.target);
    }

    protected abstract void assignExpr(Expr.Binary var1);

    protected void indexExpr(Expr.Index index) {
        this.doExpr(index.index);
        this.doExpr(index.target);
    }

    protected void interpolationExpr(Expr.Interpolation interpolation) {
        int n = 0;
        while (n < interpolation.parts.size()) {
            this.doExpr((Expr)interpolation.parts.get(n));
            ++n;
        }
    }

    protected void condExpr(Expr.Cond cond) {
        int n = 0;
        while (n < cond.operands.size()) {
            this.doExpr((Expr)cond.operands.get(n));
            ++n;
        }
    }

    protected void ternaryExpr(Expr.Ternary ternary) {
        this.doExpr(ternary.cond);
        this.doExpr(ternary.trueExpr);
        this.doExpr(ternary.falseExpr);
    }

    protected void unaryExpr(Expr.Unary unary) {
        this.doExpr(unary.operand);
    }

    protected void castExpr(Expr.Cast cast) {
        this.doExpr(cast.target);
    }

    protected void binaryExpr(Expr.Binary binary) {
        this.doExpr(binary.lhs);
        this.doExpr(binary.rhs);
    }

    public CfgStep(Compiler compiler, ControlFlowGraph controlFlowGraph) {
        super(compiler);
        this.cfg = controlFlowGraph;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class DefinedSets {
        public Set defIn;
        public Set defAt;
        public Set defOut;

        private final /* synthetic */ void this() {
            this.defIn = new HashSet();
            this.defAt = new HashSet();
            this.defOut = new HashSet();
        }

        public DefinedSets() {
            this.this();
        }

        public DefinedSets(DefinedSets definedSets) {
            this.this();
            this.defIn.addAll(definedSets.defIn);
            this.defAt.addAll(definedSets.defAt);
            this.defOut.addAll(definedSets.defOut);
        }
    }
}

