/*
 * Decompiled with CFR 0.152.
 */
package sedonac.gen;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import sedona.Buf;
import sedonac.CompilerSupport;
import sedonac.ast.Expr;
import sedonac.gen.ImageGen;
import sedonac.ir.IrAddressable;
import sedonac.namespace.Slot;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConstPool
extends CompilerSupport {
    ImageGen parent;
    HashMap ints;
    HashMap longs;
    HashMap floats;
    HashMap doubles;
    HashMap strings;
    HashMap bufs;
    HashMap arrays;
    HashMap qnameTypes;
    HashMap qnameSlots;

    IrInt toInt(Integer n) {
        IrInt irInt = (IrInt)this.ints.get(n);
        if (irInt == null) {
            irInt = new IrInt(n);
            this.ints.put(n, irInt);
        }
        return irInt;
    }

    void ints() {
        Buf buf = this.parent.code;
        buf.align(4);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 4 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.ints.keySet().toArray(new Integer[this.ints.size()]);
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            IrInt irInt = (IrInt)this.ints.get(objectArray[n]);
            irInt.blockIndex = this.blockIndex();
            int n2 = irInt.val;
            buf.i4(n2);
            this.blockAlign();
            ++n;
        }
    }

    IrLong toLong(Long l) {
        IrLong irLong = (IrLong)this.longs.get(l);
        if (irLong == null) {
            irLong = new IrLong(l);
            this.longs.put(l, irLong);
        }
        return irLong;
    }

    void longs() {
        Buf buf = this.parent.code;
        buf.align(8);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 8 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.longs.keySet().toArray(new Long[this.longs.size()]);
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            IrLong irLong = (IrLong)this.longs.get(objectArray[n]);
            irLong.blockIndex = this.blockIndex();
            long l = irLong.val;
            buf.i8(l);
            this.blockAlign();
            ++n;
        }
    }

    IrFloat toFloat(Float f) {
        IrFloat irFloat = (IrFloat)this.floats.get(f);
        if (irFloat == null) {
            irFloat = new IrFloat(f);
            this.floats.put(f, irFloat);
        }
        return irFloat;
    }

    void floats() {
        Buf buf = this.parent.code;
        buf.align(4);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 4 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.floats.keySet().toArray(new Float[this.floats.size()]);
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            IrFloat irFloat = (IrFloat)this.floats.get(objectArray[n]);
            irFloat.blockIndex = this.blockIndex();
            float f = irFloat.val.floatValue();
            buf.f4(f);
            this.blockAlign();
            ++n;
        }
    }

    IrDouble toDouble(Double d) {
        IrDouble irDouble = (IrDouble)this.doubles.get(d);
        if (irDouble == null) {
            irDouble = new IrDouble(d);
            this.doubles.put(d, irDouble);
        }
        return irDouble;
    }

    void doubles() {
        Buf buf = this.parent.code;
        buf.align(8);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 8 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.doubles.keySet().toArray(new Double[this.doubles.size()]);
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            IrDouble irDouble = (IrDouble)this.doubles.get(objectArray[n]);
            irDouble.blockIndex = this.blockIndex();
            double d = irDouble.val;
            if (this.parent.image.armDouble) {
                long l = Double.doubleToLongBits(d);
                buf.i4((int)(l >> 32 & 0xFFFFFFFFL));
                buf.i4((int)(l & 0xFFFFFFFFL));
            } else {
                buf.f8(d);
            }
            this.blockAlign();
            ++n;
        }
    }

    IrStr string(String string) {
        IrStr irStr = (IrStr)this.strings.get(string);
        if (irStr == null) {
            irStr = new IrStr(string);
            this.strings.put(string, irStr);
        }
        return irStr;
    }

    void strings() {
        Buf buf = this.parent.code;
        Object[] objectArray = this.strings.keySet().toArray(new String[this.strings.size()]);
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            IrStr irStr = (IrStr)this.strings.get(objectArray[n]);
            irStr.blockIndex = this.blockIndex();
            this.writeStrLiteral(buf, irStr.val);
            ++n;
        }
    }

    void writeStrLiteral(Buf buf, String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '\u00ff') {
                throw this.err("Invalid string literal: " + string);
            }
            buf.u1((int)c);
            ++n;
        }
        buf.u1(0);
        this.blockAlign();
    }

    IrBuf buf(Buf buf) {
        IrBuf irBuf = (IrBuf)this.bufs.get(buf);
        if (irBuf == null) {
            irBuf = new IrBuf(buf);
            this.bufs.put(buf, irBuf);
        }
        return irBuf;
    }

    void bufs() {
        Buf buf = this.parent.code;
        buf.align(2);
        if (buf.size % this.parent.image.blockSize != 0) {
            throw new IllegalStateException();
        }
        if (buf.size % 2 != 0) {
            throw new IllegalStateException();
        }
        Object[] objectArray = this.bufs.keySet().toArray(new Buf[this.bufs.size()]);
        Arrays.sort(objectArray);
        int n = 0;
        while (n < objectArray.length) {
            IrBuf irBuf = (IrBuf)this.bufs.get(objectArray[n]);
            irBuf.blockIndex = this.blockIndex();
            Buf buf2 = irBuf.val;
            buf.u2(buf2.size);
            buf.u2(buf2.size);
            buf.append(buf2);
            buf.align(2);
            this.blockAlign();
            ++n;
        }
    }

    IrArray array(Expr.Literal literal) {
        Object[] objectArray;
        Type type = literal.type.arrayOf();
        IrArray irArray = new IrArray(type, objectArray = literal.asArray());
        IrArray irArray2 = (IrArray)this.arrays.get(irArray);
        if (irArray2 == null) {
            irArray2 = irArray;
            this.arrays.put(irArray, irArray);
        }
        return irArray2;
    }

    void arrays() {
        Buf buf = this.parent.code;
        IrArray[] irArrayArray = this.arrays.values().toArray(new IrArray[this.arrays.size()]);
        int n = 0;
        while (n < irArrayArray.length) {
            IrArray irArray = irArrayArray[n];
            Type type = irArray.of;
            Object[] objectArray = irArray.array;
            this.blockAlign();
            if (type.isStr()) {
                int[] nArray = new int[objectArray.length];
                int n2 = 0;
                while (n2 < objectArray.length) {
                    nArray[n2] = this.blockIndex();
                    this.writeStrLiteral(buf, (String)objectArray[n2]);
                    ++n2;
                }
                buf.align(2);
                irArray.blockIndex = this.blockIndex();
                n2 = 0;
                while (n2 < objectArray.length) {
                    buf.u2(nArray[n2]);
                    ++n2;
                }
            } else {
                switch (type.id()) {
                    case 2: {
                        irArray.blockIndex = this.blockIndex();
                        int n3 = 0;
                        while (n3 < objectArray.length) {
                            buf.u1(((Integer)objectArray[n3]).intValue());
                            ++n3;
                        }
                        break;
                    }
                    case 3: {
                        buf.align(2);
                        irArray.blockIndex = this.blockIndex();
                        int n4 = 0;
                        while (n4 < objectArray.length) {
                            buf.u2(((Integer)objectArray[n4]).intValue());
                            ++n4;
                        }
                        break;
                    }
                    case 4: {
                        buf.align(4);
                        irArray.blockIndex = this.blockIndex();
                        int n5 = 0;
                        while (n5 < objectArray.length) {
                            buf.i4(((Integer)objectArray[n5]).intValue());
                            ++n5;
                        }
                        break;
                    }
                    case 5: {
                        buf.align(8);
                        irArray.blockIndex = this.blockIndex();
                        int n6 = 0;
                        while (n6 < objectArray.length) {
                            buf.i8(((Long)objectArray[n6]).longValue());
                            ++n6;
                        }
                        break;
                    }
                    case 6: {
                        buf.align(4);
                        irArray.blockIndex = this.blockIndex();
                        int n7 = 0;
                        while (n7 < objectArray.length) {
                            buf.f4(((Float)objectArray[n7]).floatValue());
                            ++n7;
                        }
                        break;
                    }
                    case 7: {
                        int n8;
                        buf.align(8);
                        irArray.blockIndex = this.blockIndex();
                        if (this.parent.image.armDouble) {
                            n8 = 0;
                            while (n8 < objectArray.length) {
                                double d = (Double)objectArray[n8];
                                long l = Double.doubleToLongBits(d);
                                buf.i4((int)(l >> 32 & 0xFFFFFFFFL));
                                buf.i4((int)(l & 0xFFFFFFFFL));
                                ++n8;
                            }
                        } else {
                            n8 = 0;
                            while (n8 < objectArray.length) {
                                buf.f8(((Double)objectArray[n8]).doubleValue());
                                ++n8;
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("array literal: " + type);
                    }
                }
            }
            ++n;
        }
        this.blockAlign();
    }

    IrQnameType qnameType(Type type) {
        String string = type.qname();
        IrQnameType irQnameType = (IrQnameType)this.qnameTypes.get(string);
        if (irQnameType == null) {
            irQnameType = new IrQnameType();
            irQnameType.kitName = this.string(type.kit().name());
            irQnameType.typeName = this.string(type.name());
            this.qnameTypes.put(string, irQnameType);
        }
        return irQnameType;
    }

    void qnameTypes() {
        Buf buf = this.parent.code;
        buf.align(2);
        Iterator iterator = this.qnameTypes.values().iterator();
        while (iterator.hasNext()) {
            IrQnameType irQnameType = (IrQnameType)iterator.next();
            irQnameType.blockIndex = this.blockIndex();
            if (irQnameType.kitName.blockIndex <= 0) {
                throw new IllegalStateException();
            }
            buf.u2(irQnameType.kitName.blockIndex);
            buf.u2(irQnameType.typeName.blockIndex);
            this.blockAlign();
        }
    }

    IrQnameSlot qnameSlot(Slot slot) {
        String string = slot.qname();
        IrQnameSlot irQnameSlot = (IrQnameSlot)this.qnameSlots.get(string);
        if (irQnameSlot == null) {
            irQnameSlot = new IrQnameSlot();
            irQnameSlot.qnameType = this.qnameType(slot.parent());
            irQnameSlot.slotName = this.string(slot.name());
            this.qnameSlots.put(string, irQnameSlot);
        }
        return irQnameSlot;
    }

    void qnameSlots() {
        Buf buf = this.parent.code;
        buf.align(2);
        Iterator iterator = this.qnameSlots.values().iterator();
        while (iterator.hasNext()) {
            IrQnameSlot irQnameSlot = (IrQnameSlot)iterator.next();
            irQnameSlot.blockIndex = this.blockIndex();
            if (irQnameSlot.qnameType.blockIndex <= 0 || irQnameSlot.slotName.blockIndex <= 0) {
                throw new IllegalStateException();
            }
            buf.u2(irQnameSlot.qnameType.blockIndex);
            buf.u2(irQnameSlot.slotName.blockIndex);
            this.blockAlign();
        }
    }

    public int blockIndex() {
        return this.parent.blockIndex();
    }

    public void blockAlign() {
        this.parent.blockAlign();
    }

    private final /* synthetic */ void this() {
        this.ints = new HashMap();
        this.longs = new HashMap();
        this.floats = new HashMap();
        this.doubles = new HashMap();
        this.strings = new HashMap();
        this.bufs = new HashMap();
        this.arrays = new HashMap();
        this.qnameTypes = new HashMap();
        this.qnameSlots = new HashMap();
    }

    public ConstPool(ImageGen imageGen) {
        super(imageGen.compiler);
        this.this();
        this.parent = imageGen;
    }

    static class IrInt
    implements IrAddressable {
        final Integer val;
        int blockIndex;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrInt(Integer n) {
            this.val = n;
        }
    }

    static class IrLong
    implements IrAddressable {
        final Long val;
        int blockIndex;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrLong(Long l) {
            this.val = l;
        }
    }

    static class IrFloat
    implements IrAddressable {
        final Float val;
        int blockIndex;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrFloat(Float f) {
            this.val = f;
        }
    }

    static class IrDouble
    implements IrAddressable {
        final Double val;
        int blockIndex;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrDouble(Double d) {
            this.val = d;
        }
    }

    static class IrStr
    implements IrAddressable {
        final String val;
        int blockIndex;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrStr(String string) {
            this.val = string;
        }
    }

    static class IrBuf
    implements IrAddressable {
        final Buf val;
        int blockIndex;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrBuf(Buf buf) {
            this.val = buf;
        }
    }

    static class IrArray
    implements IrAddressable {
        final Type of;
        final Object[] array;
        final int hash;
        int blockIndex;

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (!(object instanceof IrArray)) {
                return false;
            }
            IrArray irArray = (IrArray)object;
            if (!this.of.equals(irArray.of)) {
                return false;
            }
            return Arrays.equals(this.array, irArray.array);
        }

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrArray(Type type, Object[] objectArray) {
            this.of = type;
            this.array = objectArray;
            this.hash = type.name().hashCode() ^ objectArray.length;
        }
    }

    static class IrQnameType
    implements IrAddressable {
        int blockIndex;
        IrStr kitName;
        IrStr typeName;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrQnameType() {
        }
    }

    static class IrQnameSlot
    implements IrAddressable {
        int blockIndex;
        IrQnameType qnameType;
        IrStr slotName;

        public int getBlockIndex() {
            return this.blockIndex;
        }

        public void setBlockIndex(int n) {
            this.blockIndex = n;
        }

        public boolean alignBlockIndex() {
            return true;
        }

        IrQnameSlot() {
        }
    }
}

