/*
 * Decompiled with CFR 0.152.
 */
package sedonac.namespace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import sedonac.namespace.Field;
import sedonac.namespace.Kit;
import sedonac.namespace.Method;
import sedonac.namespace.PrimitiveType;
import sedonac.namespace.Slot;
import sedonac.namespace.StubType;
import sedonac.namespace.Type;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Namespace {
    public static final Type error = new PrimitiveType("error", 0, 0);
    private static HashMap primitivesByName = new HashMap();
    public Type objType;
    public Type bufType;
    public Type compType;
    public Type logType;
    public Type slotType;
    public Type strType;
    public Type sysType;
    public Type typeType;
    public final PrimitiveType voidType;
    public final PrimitiveType boolType;
    public final PrimitiveType byteType;
    public final PrimitiveType shortType;
    public final PrimitiveType intType;
    public final PrimitiveType longType;
    public final PrimitiveType floatType;
    public final PrimitiveType doubleType;
    public final PrimitiveType[] primitiveTypes;
    HashMap kits;

    public Kit resolveKit(String string) {
        return (Kit)this.kits.get(string);
    }

    public Type resolveType(String string) {
        int n = string.indexOf(58);
        if (n < 0 || string.charAt(n + 1) != ':') {
            Type type = (Type)primitivesByName.get(string);
            if (type != null) {
                return type;
            }
            throw new IllegalStateException("Invalid type signature: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 2);
        Kit kit = this.resolveKit(string2);
        if (kit == null) {
            return null;
        }
        return kit.type(string3);
    }

    public Type[] resolveTypeBySimpleName(String string) {
        ArrayList<Type> arrayList = new ArrayList<Type>();
        Iterator iterator = this.kits.values().iterator();
        while (iterator.hasNext()) {
            Kit kit = (Kit)iterator.next();
            Type type = kit.type(string);
            if (type == null) continue;
            arrayList.add(type);
        }
        return arrayList.toArray(new Type[arrayList.size()]);
    }

    public Slot resolveSlot(String string) {
        return this.resolveSlot(string, false);
    }

    public Slot resolveSlot(String string, boolean bl) {
        int n = string.indexOf(46);
        if (n < 0) {
            throw new IllegalStateException("Invalid method signature: " + string);
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        Type type = this.resolveType(string2);
        if (type == null) {
            if (bl) {
                throw new IllegalStateException("Slot not found:: " + string);
            }
            return null;
        }
        Slot slot = type.slot(string3);
        if (slot == null && bl) {
            throw new IllegalStateException("Slot not found:: " + string);
        }
        return slot;
    }

    public Field resolveField(String string) {
        return (Field)this.resolveSlot(string);
    }

    public Method resolveMethod(String string) {
        return (Method)this.resolveSlot(string);
    }

    public Method resolveMethod(String string, boolean bl) {
        return (Method)this.resolveSlot(string, bl);
    }

    public void mount(Kit kit) {
        if (this.resolveKit(kit.name()) != null) {
            throw new IllegalStateException("duplicate kit: " + kit.name());
        }
        this.kits.put(kit.name(), kit);
        if (kit.name().equals("sys")) {
            this.objType = this.requiredType(kit, "Obj");
            this.bufType = this.requiredType(kit, "Buf");
            this.compType = this.requiredType(kit, "Component");
            this.logType = this.requiredType(kit, "Log");
            this.slotType = this.requiredType(kit, "Slot");
            this.strType = this.requiredType(kit, "Str");
            this.sysType = this.requiredType(kit, "Sys");
            this.typeType = this.requiredType(kit, "Type");
        }
    }

    private final Type requiredType(Kit kit, String string) {
        Type type = kit.type(string);
        if (type == null) {
            throw new IllegalStateException(string);
        }
        return type;
    }

    public Type[] predefined() {
        return new Type[]{this.voidType, this.boolType, this.byteType, this.shortType, this.intType, this.longType, this.floatType, this.doubleType, this.bufType};
    }

    private final PrimitiveType primitive(String string, int n, int n2) {
        PrimitiveType primitiveType = new PrimitiveType(string, n, n2);
        primitivesByName.put(string, primitiveType);
        return primitiveType;
    }

    private final /* synthetic */ void this() {
        this.objType = new StubType(this, null, "Obj");
        this.bufType = new StubType(this, this.objType, "Buf");
        this.compType = new StubType(this, this.objType, "Component");
        this.logType = new StubType(this, this.objType, "Log");
        this.slotType = new StubType(this, this.objType, "Slot");
        this.strType = new StubType(this, this.objType, "Str");
        this.sysType = new StubType(this, this.objType, "Sys");
        this.typeType = new StubType(this, this.objType, "Type");
        this.voidType = this.primitive("void", 0, 0);
        this.boolType = this.primitive("bool", 1, 1);
        this.byteType = this.primitive("byte", 2, 1);
        this.shortType = this.primitive("short", 3, 2);
        this.intType = this.primitive("int", 4, 4);
        this.longType = this.primitive("long", 5, 8);
        this.floatType = this.primitive("float", 6, 4);
        this.doubleType = this.primitive("double", 7, 8);
        this.primitiveTypes = new PrimitiveType[]{this.voidType, this.boolType, this.byteType, this.shortType, this.intType, this.longType, this.floatType, this.doubleType};
        this.kits = new HashMap();
    }

    public Namespace() {
        this.this();
    }
}

