/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import sedona.Depend;
import sedona.Env;
import sedona.kit.KitDb;
import sedona.kit.KitFile;
import sedona.util.FileUtil;
import sedona.util.Log;
import sedona.util.VendorUtil;
import sedona.xml.XContent;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XParser;
import sedonac.Compiler;
import sedonac.Location;
import sedonac.ir.IrKit;
import sedonac.platform.PlatformDef;
import sedonac.steps.InitImageCompile;
import sedonac.util.VarResolver;

public class InitStagePlatform
extends InitImageCompile {
    public void run() {
        try {
            this.log.info("  InitStagePlatform [" + this.xmlFile.getName() + ']');
            if (this.compiler.outDir == null) {
                throw this.err("Must specify target directory via -outDir", new Location("compiler args"));
            }
            this.makeStageDirs();
            PlatformDef platformDef = this.compiler.platform = this.parsePlatformDef();
            IrKit[] irKitArray = new IrKit[platformDef.nativeKits.length];
            int n = 0;
            while (n < irKitArray.length) {
                Depend depend = platformDef.nativeKits[n];
                KitFile kitFile = KitDb.matchBest((Depend)depend);
                if (kitFile == null) {
                    this.err("Missing kit dependency '" + depend + '\'', new Location(this.xml));
                } else {
                    irKitArray[n] = new IrKit(new Location(this.xml), kitFile);
                }
                ++n;
            }
            this.compiler.kits = irKitArray;
            this.quitIfErrors();
        }
        catch (XException xException) {
            throw this.err(xException);
        }
    }

    private final void makeStageDirs() {
        try {
            FileUtil.delete((File)this.compiler.outDir, (Log)this.log);
        }
        catch (IOException iOException) {
            this.err("Cannot delete stage dir", new Location(this.compiler.outDir));
        }
        File file = null;
        try {
            file = new File(new File(this.compiler.outDir, ".par"), "svm");
            FileUtil.mkdir((File)file, (Log)this.log);
        }
        catch (IOException iOException) {
            this.err("Cannot make stage dir", new Location(file));
        }
    }

    private final PlatformDef parsePlatformDef() {
        PlatformDef platformDef = new PlatformDef();
        platformDef.vendor = this.xml.get("vendor");
        platformDef.idPattern = this.xml.get("id", null);
        this.parseCompile(platformDef, this.xml.elem("compile", true));
        this.parseManifestIncludes(platformDef, this.xml.elems("manifestInclude"));
        this.checkVendor(platformDef);
        return platformDef;
    }

    private final void parseCompile(PlatformDef platformDef, XElem xElem) {
        VarResolver varResolver = new VarResolver();
        platformDef.refSize = xElem.geti("refSize");
        platformDef.blockSize = xElem.geti("blockSize");
        platformDef.endian = xElem.get("endian");
        platformDef.armDouble = xElem.getb("armDouble", platformDef.armDouble);
        platformDef.debug = xElem.getb("debug", platformDef.debug);
        platformDef.test = xElem.getb("test", platformDef.test);
        platformDef.embedManifest = xElem.getb("embedManifest", false);
        XElem[] xElemArray = xElem.elems("nativeKit");
        Depend[] dependArray = new Depend[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            dependArray[n] = xElemArray[n].getDepend("depend");
            ++n;
        }
        platformDef.nativeKits = dependArray;
        xElemArray = xElem.elems("nativeSource");
        ArrayList<String> arrayList = new ArrayList<String>(xElemArray.length);
        try {
            int n2 = 0;
            while (n2 < xElemArray.length) {
                File[] fileArray;
                Object object;
                try {
                    String string = varResolver.resolve(xElemArray[n2].get("path"));
                    if (!string.startsWith("/")) {
                        throw this.err("Paths must start with / and be relative to sedona home: " + string);
                    }
                    object = new File(Env.home, string.substring(1));
                    if (!((File)object).exists() || !((File)object).isDirectory()) {
                        this.warn("Source path not found '" + ((File)object).getPath() + '\'');
                        return;
                    }
                    fileArray = ((File)object).listFiles();
                    this.log.debug("    Copy '" + object + "' [" + fileArray.length + " files]");
                    if (fileArray.length == 0) {
                        throw this.err("No files found in directory " + object, new Location(xElem));
                    }
                    int n3 = 0;
                    while (n3 < fileArray.length) {
                        File file = fileArray[n3];
                        if (!file.isDirectory()) {
                            arrayList.add(file.getPath());
                        }
                        ++n3;
                    }
                }
                catch (XException xException) {
                    object = varResolver.resolve(xElemArray[n2].get("file"));
                    if (object == null) {
                        throw this.err("Could not read file attribute", new Location(xElem));
                    }
                    if (!((String)object).startsWith("/")) {
                        throw this.err("Paths must start with / and be relative to sedona home: " + (String)object);
                    }
                    fileArray = new File(Env.home, ((String)object).substring(1));
                    if (!fileArray.exists()) {
                        this.warn("Source path not found '" + fileArray.getPath() + '\'');
                        return;
                    }
                    arrayList.add(fileArray.getPath());
                }
                ++n2;
            }
            platformDef.nativeFiles = arrayList.toArray(new String[0]);
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage());
        }
        xElemArray = xElem.elems("nativePatch");
        String[] stringArray = new String[xElemArray.length];
        try {
            int n4 = 0;
            while (n4 < xElemArray.length) {
                stringArray[n4] = xElemArray[n4].get("qname");
                ++n4;
            }
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage());
        }
        platformDef.nativePatches = stringArray;
        if (!"big".equals(platformDef.endian) && !"little".equals(platformDef.endian)) {
            throw new XException("compile.endian must be 'big' or 'little'", xElem);
        }
        if (platformDef.nativeKits == null || platformDef.nativeKits.length == 0) {
            throw new XException("no compile.nativeKit elements defined", xElem);
        }
        if (xElem.elems("include").length > 0) {
            throw new XException("<include> is no longer supported.", xElem);
        }
    }

    private final void parseManifestIncludes(PlatformDef platformDef, XElem[] xElemArray) {
        ArrayList<XElem> arrayList = new ArrayList<XElem>();
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].get("path", null);
            if (string != null) {
                arrayList.add(this.resolveManifestInclude(string));
            }
            XElem[] xElemArray2 = xElemArray[n].elems();
            int n2 = 0;
            while (n2 < xElemArray2.length) {
                arrayList.add(xElemArray2[n2]);
                xElemArray[n].removeContent((XContent)xElemArray2[n2]);
                ++n2;
            }
            ++n;
        }
        platformDef.manifestIncludes = arrayList.toArray(new XElem[arrayList.size()]);
    }

    private final XElem resolveManifestInclude(String string) {
        Location location = new Location(this.xmlFile);
        File file = null;
        file = !string.startsWith("/") ? new File(this.xmlDir, string) : new File(Env.home, string.substring(1));
        try {
            return XParser.make((File)file).parse();
        }
        catch (Exception exception) {
            throw this.err("Could not include '" + string + '\'', location, (Throwable)exception);
        }
    }

    private final void checkVendor(PlatformDef platformDef) {
        Location location = new Location(this.xmlFile);
        try {
            VendorUtil.checkVendorName((String)platformDef.vendor);
            VendorUtil.checkPlatformPrefix((String)platformDef.vendor, (String)platformDef.idPattern);
        }
        catch (Exception exception) {
            throw this.err(exception.getMessage(), location);
        }
    }

    public InitStagePlatform(Compiler compiler) {
        super(compiler);
    }
}

