/*
 * Decompiled with CFR 0.152.
 */
package sedonac.steps;

import sedonac.Compiler;
import sedonac.CompilerStep;
import sedonac.Location;
import sedonac.ast.Expr;
import sedonac.ast.FieldDef;
import sedonac.ast.UnresolvedType;
import sedonac.namespace.ArrayType;
import sedonac.namespace.Field;
import sedonac.namespace.StubType;
import sedonac.namespace.Type;

public class ResolveTypes
extends CompilerStep {
    public void run() {
        this.log.debug("  ResolveTypes");
        this.walkAst(3);
        this.quitIfErrors();
    }

    public void exitField(FieldDef fieldDef) {
        super.exitField(fieldDef);
        if (fieldDef.isConst() && fieldDef.type.isArray()) {
            ArrayType arrayType = (ArrayType)fieldDef.type;
            fieldDef.type = new ArrayType(arrayType.loc, arrayType.of, arrayType.len, true);
        }
    }

    public Type type(Type type) {
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            arrayType.of = this.type(arrayType.of);
            arrayType.len = this.arrayLength(arrayType.len, arrayType.loc);
            return arrayType;
        }
        if (type instanceof StubType) {
            StubType stubType = (StubType)type;
            Type type2 = this.ns.resolveType(stubType.qname);
            if (type2 == null) {
                throw new IllegalStateException("Using StubType: " + stubType.qname);
            }
            return type2;
        }
        if (!(type instanceof UnresolvedType)) {
            return type;
        }
        UnresolvedType unresolvedType = (UnresolvedType)type;
        Type type3 = this.resolveType(unresolvedType.name, unresolvedType.loc, true);
        if (type3 != null) {
            return type3;
        }
        return unresolvedType;
    }

    public Expr expr(Expr expr) {
        if (expr.id == 58) {
            Type type;
            Expr.Name name = (Expr.Name)expr;
            if (name.target == null && (type = this.resolveType(name.name, name.loc, false)) != null) {
                return new Expr.StaticType(expr.loc, type);
            }
        }
        return expr;
    }

    private final Type resolveType(String string, Location location, boolean bl) {
        Type[] typeArray = this.ns.resolveTypeBySimpleName(string);
        if (typeArray.length == 0) {
            Type type = null;
            if (string.indexOf("::") > 0 && (type = this.ns.resolveType(string)) != null) {
                return type;
            }
            if (bl) {
                this.err("Unknown type '" + string + '\'', location);
            }
            return type;
        }
        if (typeArray.length > 1) {
            this.err("Ambiguous type '" + typeArray[0] + "' and '" + typeArray[1] + '\'', location);
            return null;
        }
        return typeArray[0];
    }

    public ArrayType.Len arrayLength(ArrayType.Len len, Location location) {
        if (len instanceof ArrayType.UnresolvedLen) {
            String string = ((ArrayType.UnresolvedLen)len).id;
            Field field = this.resolveDefine(string, location);
            if (field != null && !field.type().isInt()) {
                this.err("Array length define must be int type", location);
            }
            return new ArrayType.DefineLen(field);
        }
        return len;
    }

    public Field resolveDefine(String string, Location location) {
        Object object;
        String string2;
        Type type = this.curType;
        int n = string.indexOf(46);
        if (n < 0) {
            string2 = string;
        } else {
            string2 = string.substring(n + 1);
            object = string.substring(0, n);
            int n2 = ((String)object).indexOf(58);
            type = n2 < 0 ? this.resolveType((String)object, location, false) : this.ns.resolveType((String)object);
            if (type == null) {
                this.err("Unresolved base type in define '" + string + '\'', location);
                return null;
            }
        }
        object = type.slot(string2);
        if (object == null) {
            this.err("Unresolved define '" + string + '\'', location);
            return null;
        }
        if (!(object instanceof Field)) {
            this.err("Expected define field, not method '" + string + '\'', location);
            return null;
        }
        Field field = (Field)object;
        if (!field.isDefine()) {
            this.err("Expected '" + string + "' to be a define", location);
            return null;
        }
        return field;
    }

    public ResolveTypes(Compiler compiler) {
        super(compiler);
    }
}

