/*
 * Decompiled with CFR 0.152.
 */
package sedonac.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Hashtable;
import java.util.Properties;
import sedona.Bool;
import sedona.Buf;
import sedona.Byte;
import sedona.Component;
import sedona.Double;
import sedona.Float;
import sedona.Int;
import sedona.KitPart;
import sedona.Link;
import sedona.Long;
import sedona.Schema;
import sedona.Short;
import sedona.Slot;
import sedona.Str;
import sedona.Type;
import sedona.Value;
import sedona.dasp.DaspException;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineComponent;
import sedona.offline.OfflineLink;
import sedona.sox.SoxClient;
import sedona.sox.SoxComponent;
import sedona.sox.SoxComponentListener;
import sedona.sox.SoxException;
import sedona.sox.SoxFile;
import sedona.sox.VersionInfo;
import sedona.util.TextUtil;
import sedona.util.UserUtil;
import sedonac.test.AbstractSoxTest;
import sedonac.test.DaspTest;

public class SoxTest
extends AbstractSoxTest {
    static int binDropCount = 0;
    private static final int GETFILE = 0;
    private static final int PUTFILE = 1;
    OfflineApp app;
    OfflineComponent service;
    OfflineComponent plat;
    OfflineComponent sox;
    OfflineComponent web;
    OfflineComponent soxTest;
    OfflineComponent users;
    OfflineComponent admin;
    OfflineComponent a;
    OfflineComponent aa;
    OfflineComponent aa1;
    OfflineComponent aa2;
    OfflineComponent ab;
    OfflineComponent b;
    OfflineComponent r;
    OfflineComponent s;
    OfflineComponent t;
    OfflineComponent baz;
    Type soxTestType;
    int soxTestId;
    int xId;

    public void doTest() throws Exception {
        this.verifyConnect();
        this.verifyServer("verifyTrue");
        this.verifySchema();
        this.verifyVersion();
        this.verifyLoad();
        this.verifyWrite();
        this.verifyInvoke();
        this.verifyUpdate();
        this.verifySubscribe();
        this.verifyAdd();
        this.verifyRename();
        this.verifyReorder();
        this.verifyDelete();
        this.verifyLinks();
        this.verifyQuery();
        this.verifyFileTransfer();
        this.verifyBinaryTransfer();
        this.verifyFileRename();
        this.verifyClose();
    }

    private final void verifyConnect() throws Exception {
        InetAddress inetAddress = InetAddress.getLocalHost();
        Hashtable<String, DaspTest.TestHooks> hashtable = new Hashtable<String, DaspTest.TestHooks>();
        hashtable.put("dasp.test", new DaspTest.TestHooks());
        this.trace("Connect with bad username...");
        int n = -1;
        try {
            this.client = new SoxClient(this.sock, inetAddress, 1876, "baduser", "");
            this.client.connect(hashtable);
        }
        catch (DaspException daspException) {
            n = daspException.errorCode;
        }
        this.verifyEq(n, 228);
        this.trace("Connect with bad password...");
        n = -1;
        try {
            this.client = new SoxClient(this.sock, inetAddress, 1876, "admin", "");
            this.client.connect(hashtable);
        }
        catch (DaspException daspException) {
            n = daspException.errorCode;
        }
        this.verifyEq(n, 228);
        this.trace("Connect with good username and password...");
        this.client = new SoxClient(this.sock, inetAddress, 1876, "admin", "pw");
        this.client.connect(hashtable);
        this.verify(this.client.isClosed() ^ true);
        boolean bl = false;
        if (this.client.session() != null) {
            bl = true;
        }
        this.verify(bl);
    }

    private final void verifySchema() throws Exception {
        Schema schema = this.schema;
        Schema schema2 = this.client.readSchema();
        this.verify(schema.equivalent(schema2));
    }

    private final void verifyVersion() throws Exception {
        VersionInfo versionInfo = this.client.readVersion();
        this.verifyEq(versionInfo.kits.length, this.schema.kits.length);
        int n = 0;
        while (n < versionInfo.kits.length) {
            this.verifyEq(versionInfo.kits[n].name, this.schema.kits[n].name);
            this.verifyEq(versionInfo.kits[n].checksum, this.schema.kits[n].checksum);
            this.verifyEq(versionInfo.kits[n].version, this.schema.kits[n].manifest.version);
            ++n;
        }
        boolean bl = false;
        if (versionInfo.props != null) {
            bl = true;
        }
        this.verify(bl);
    }

    private final void verifyLoad() throws Exception {
        SoxComponent soxComponent = this.client.loadApp();
        this.verifyEq(soxComponent.id(), 0);
        this.verifyEq(soxComponent.name(), "app");
        this.verifyEq(soxComponent.path(), "/");
        this.verifyEq(soxComponent.parentId(), (char)-1);
        this.verifyEq(soxComponent.type, this.schema.type("sys::App"));
        this.verifyEq(soxComponent.childrenIds().length, 4);
        this.verifyEq(soxComponent.childrenIds()[0], this.app.children()[0].id());
        this.verifyEq(soxComponent.childrenIds()[1], this.app.children()[1].id());
        this.verifyEq(soxComponent.childrenIds()[2], this.app.children()[2].id());
        this.verifyEq(soxComponent.childrenIds()[3], this.app.children()[3].id());
        SoxComponent soxComponent2 = this.client.load(this.soxTestId);
        this.verifyEq(soxComponent2.path(), "/service/sox/soxtest");
        this.verifyEq(soxComponent2.id(), this.soxTestId);
        this.verifyEq(soxComponent2.name(), "soxtest");
        this.verifyEq(soxComponent2.parentId(), this.sox.id());
        this.verifyEq(soxComponent2.children().length, 0);
        SoxComponent[] soxComponentArray = soxComponent.children();
        SoxComponent soxComponent3 = soxComponent.child("service");
        SoxComponent soxComponent4 = soxComponent.child("a");
        SoxComponent soxComponent5 = soxComponent.child("b");
        SoxComponent soxComponent6 = soxComponent.child("baz");
        this.verifyEq(soxComponentArray.length, 4);
        boolean bl = false;
        if (soxComponentArray[0] == soxComponent3) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (soxComponentArray[1] == soxComponent4) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (soxComponentArray[2] == soxComponent5) {
            bl3 = true;
        }
        this.verify(bl3);
        boolean bl4 = false;
        if (soxComponentArray[3] == soxComponent6) {
            bl4 = true;
        }
        this.verify(bl4);
        this.verifyEq(soxComponent4.id(), this.a.id());
        this.verifyEq(soxComponent4.name(), "a");
        this.verifyEq(soxComponent4.path(), "/a");
        this.verifyEq(soxComponent4.parentId(), 0);
        boolean bl5 = false;
        if (soxComponent4.parent() == soxComponent) {
            bl5 = true;
        }
        this.verify(bl5);
        this.verifyEq(soxComponent4.childrenIds().length, 2);
    }

    private final void verifyWrite() throws Exception {
        this.verifyEq(this.readBool(this.aa, "z2"), true);
        this.verifyEq(this.readByte(this.aa, "b1"), 0);
        this.verifyEq(this.readShort(this.aa, "s2"), 48879);
        this.verifyEq(this.readInt(this.aa, "i2"), -123456789);
        this.verifyEq(this.readLong(this.aa, "j2"), -3000000000L);
        this.verifyEq(this.readFloat(this.aa, "f2"), 2.04f);
        this.verifyEq(this.readDouble(this.aa, "d2"), 256.0);
        this.client.write(this.aa.id(), this.aa.type.slot("z2", true), (Value)Bool.make((boolean)false));
        this.client.write(this.aa.id(), this.aa.type.slot("b1", true), (Value)Byte.make((int)227));
        this.client.write(this.aa.id(), this.aa.type.slot("s2", true), (Value)Short.make((int)1234));
        this.client.write(this.aa.id(), this.aa.type.slot("i2", true), (Value)Int.make((int)69));
        this.client.write(this.aa.id(), this.aa.type.slot("j2", true), (Value)Long.make((long)187723572702975L));
        this.client.write(this.aa.id(), this.aa.type.slot("f2", true), (Value)Float.make((float)-908.0f));
        this.client.write(this.aa.id(), this.aa.type.slot("d2", true), (Value)Double.make((double)204.0));
        this.client.write(this.aa.id(), this.aa.type.slot("bufB", true), (Value)new Buf(new byte[]{25, 114}));
        this.client.write(this.aa.id(), this.aa.type.slot("str", true), (Value)Str.make((String)"G\n!>"));
        this.verifyEq(this.readBool(this.aa, "z2"), false);
        this.verifyEq(this.readByte(this.aa, "b1"), 227);
        this.verifyEq(this.readShort(this.aa, "s2"), 1234);
        this.verifyEq(this.readInt(this.aa, "i2"), 69);
        this.verifyEq(this.readLong(this.aa, "j2"), 187723572702975L);
        this.verifyEq(this.readFloat(this.aa, "f2"), -908.0f);
        this.verifyEq(this.readDouble(this.aa, "d2"), 204.0);
        this.verifyEq(this.readBuf(this.aa, "bufB"), new Buf(new byte[]{25, 114}));
        this.verifyEq(this.readStr(this.aa, "str"), "G\n!>");
        this.client.write(this.aa.id(), this.aa.type.slot("z2", true), (Value)Bool.NULL);
        this.client.write(this.aa.id(), this.aa.type.slot("f2", true), (Value)Float.NULL);
        boolean bl = false;
        if (this.read(this.aa, "z2") == Bool.NULL) {
            bl = true;
        }
        this.verify(bl);
        this.verifyEq(this.read(this.aa, "z2").isNull(), true);
        boolean bl2 = false;
        if (this.read(this.aa, "f2") == Float.NULL) {
            bl2 = true;
        }
        this.verify(bl2);
        this.verifyEq(this.read(this.aa, "f2").isNull(), true);
        Component.testMode = true;
        this.client.write(this.aa.id(), this.aa.type.slot("bufA", true), (Value)new Buf(new byte[]{10, 11, 12, 13, 14}));
        this.client.write(this.aa.id(), this.aa.type.slot("bufB", true), (Value)new Buf(new byte[]{10, 11, 12, 13, 14}));
        this.client.write(this.aa.id(), this.aa.type.slot("str", true), (Value)Str.make((String)"01234"));
        this.verifyEq(this.readBuf(this.aa, "bufA"), new Buf(new byte[]{10, 11, 12, 13}));
        this.verifyEq(this.readBuf(this.aa, "bufB"), new Buf(new byte[]{10, 11}));
        this.verifyEq(this.readStr(this.aa, "str"), "0123");
        Component.testMode = false;
        Exception exception = null;
        try {
            this.client.write(this.aa.id(), this.aa.type.slot("bufA", true), (Value)new Buf(new byte[]{10, 11, 12, 13, 14}));
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        boolean bl3 = false;
        if (exception != null) {
            bl3 = true;
        }
        this.verify(bl3);
        exception = null;
        try {
            this.client.write(this.aa.id(), this.aa.type.slot("str", true), (Value)Str.make((String)"01234"));
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        boolean bl4 = false;
        if (exception != null) {
            bl4 = true;
        }
        this.verify(bl4);
        exception = null;
        try {
            this.client.write(this.aa.id(), this.aa.type.slot("str", true), (Value)Str.make((String)"\u0080"));
        }
        catch (Exception exception4) {
            exception = exception4;
        }
        boolean bl5 = false;
        if (exception != null) {
            bl5 = true;
        }
        this.verify(bl5);
        exception = null;
        try {
            this.client.write(this.baz.id(), this.baz.type.slot("bazFloat", true), (Value)Float.make((float)2.0f));
        }
        catch (Exception exception5) {
            exception = exception5;
        }
        if (exception != null) {
            exception.printStackTrace();
        }
        boolean bl6 = false;
        if (exception == null) {
            bl6 = true;
        }
        this.verify(bl6);
    }

    private final void verifyInvoke() throws Exception {
        this.client.write(this.aa.id(), this.aa.type.slot("i1", true), (Value)Int.make((int)9));
        this.client.write(this.aa.id(), this.aa.type.slot("z1", true), (Value)Bool.FALSE);
        this.client.write(this.aa.id(), this.aa.type.slot("d1", true), (Value)Double.make((double)77.0));
        this.client.write(this.aa.id(), this.aa.type.slot("bufA", true), (Value)new Buf(new byte[0]));
        this.client.write(this.aa.id(), this.aa.type.slot("str", true), (Value)Str.make((String)""));
        this.verifyEq(this.readInt(this.aa, "i1"), 9);
        this.verifyEq(this.readBool(this.aa, "z1"), false);
        this.verifyEq(this.readDouble(this.aa, "d1"), 77.0);
        this.verifyEq(this.readBuf(this.aa, "bufA"), new Buf(new byte[0]));
        this.verifyEq(this.readStr(this.aa, "str"), "");
        this.client.invoke(this.aa.id(), this.aa.type.slot("incI1", true), null);
        this.client.invoke(this.aa.id(), this.aa.type.slot("setZ1", true), (Value)Bool.TRUE);
        this.client.invoke(this.aa.id(), this.aa.type.slot("addD1", true), (Value)Double.make((double)303.0));
        this.client.invoke(this.aa.id(), this.aa.type.slot("actionBuf", true), (Value)new Buf(new byte[]{26, 43, 60, 77}));
        this.client.invoke(this.aa.id(), this.aa.type.slot("actionStr", true), (Value)Str.make((String)"#$%^"));
        this.verifyEq(this.readInt(this.aa, "i1"), 10);
        this.verifyEq(this.readBool(this.aa, "z1"), true);
        this.verifyEq(this.readDouble(this.aa, "d1"), 380.0);
        this.verifyEq(this.readBuf(this.aa, "bufA"), new Buf(new byte[]{26, 43, 60, 77}));
        this.verifyEq(this.readStr(this.aa, "str"), "#$%^");
        this.client.invoke(this.aa.id(), this.aa.type.slot("actionBuf", true), (Value)new Buf(new byte[]{-54, -2, -70, -66, -1}));
        this.verifyEq(this.readBuf(this.aa, "bufA"), new Buf(new byte[]{-54, -2, -70, -66}));
    }

    private final void verifyUpdate() throws Exception {
        SoxComponent soxComponent = this.client.load(this.a.id());
        Listener listener = new Listener(soxComponent);
        this.verifyEq(soxComponent.name(), "a");
        this.verifyEq(soxComponent.children().length, 2);
        this.verifyEq(soxComponent.children()[0].id(), this.aa.id());
        this.verifyEq(soxComponent.children()[1].id(), this.ab.id());
        this.verifyEq(soxComponent.get("z1").isNull(), true);
        this.verifyEq(soxComponent.getBool("z2"), true);
        this.verifyEq(soxComponent.getInt("b1"), 0);
        this.verifyEq(soxComponent.getInt("b2"), 171);
        this.verifyEq(soxComponent.getInt("s1"), 0);
        this.verifyEq(soxComponent.getInt("s2"), 48879);
        this.verifyEq(soxComponent.getInt("i1"), 0);
        this.verifyEq(soxComponent.getInt("i2"), -123456789);
        this.verifyEq(soxComponent.getLong("j1"), 0L);
        this.verifyEq(soxComponent.getLong("j2"), -3000000000L);
        this.verifyEq(soxComponent.get("f1").isNull(), true);
        this.verifyEq(soxComponent.getFloat("f1"), java.lang.Float.NaN);
        this.verifyEq(soxComponent.getFloat("f2"), 2.04f);
        this.verifyEq(soxComponent.getDouble("d1"), 0.0);
        this.verifyEq(soxComponent.getDouble("d2"), 256.0);
        this.verifyEq(soxComponent.getBuf((String)"bufA").size, 0);
        this.verifyEq(soxComponent.getBuf((String)"bufB").size, 0);
        this.verifyEq(soxComponent.links().length, 0);
        this.client.update(soxComponent, 14);
        this.verifyEq(soxComponent.getBool("z2"), true);
        this.verifyEq(soxComponent.getInt("b1"), 240);
        this.verifyEq(soxComponent.getInt("b2"), 171);
        this.verifyEq(soxComponent.getInt("s1"), 32000);
        this.verifyEq(soxComponent.getInt("s2"), 48879);
        this.verifyEq(soxComponent.getInt("i1"), -19088888);
        this.verifyEq(soxComponent.getInt("i2"), -123456789);
        this.verifyEq(soxComponent.getLong("j1"), 0L);
        this.verifyEq(soxComponent.getLong("j2"), -3000000000L);
        this.verifyEq(soxComponent.getFloat("f1"), 4.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 2.04f);
        this.verifyEq(soxComponent.getDouble("d1"), 0.0);
        this.verifyEq(soxComponent.getDouble("d2"), 256.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf());
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf());
        this.verifyEq(soxComponent.links().length, 1);
        this.verifyLink(soxComponent.links()[0], this.a, "b1", this.aa, "b2");
        listener.verify(14);
        this.invoke(this.soxTest, "changeProps", (Value)Int.make((int)this.a.id()));
        this.client.update(soxComponent, 14);
        this.verifyEq(soxComponent.getBool("z2"), false);
        this.verifyEq(soxComponent.getInt("b1"), 241);
        this.verifyEq(soxComponent.getInt("b2"), 172);
        this.verifyEq(soxComponent.getInt("s1"), 32001);
        this.verifyEq(soxComponent.getInt("s2"), 48880);
        this.verifyEq(soxComponent.getInt("i1"), -19088887);
        this.verifyEq(soxComponent.getInt("i2"), -123456788);
        this.verifyEq(soxComponent.getLong("j1"), 1L);
        this.verifyEq(soxComponent.getLong("j2"), -2999999999L);
        this.verifyEq(soxComponent.getFloat("f1"), 5.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 3.04f);
        this.verifyEq(soxComponent.getDouble("d1"), 1.0);
        this.verifyEq(soxComponent.getDouble("d2"), 257.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{1}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{1}));
        this.verifyEq(soxComponent.links().length, 1);
        listener.verify(14);
    }

    private final void verifySubscribe() throws Exception {
        this.client.subscribeToAllTreeEvents();
        SoxComponent soxComponent = this.client.load(this.a.id());
        Listener listener = new Listener(soxComponent);
        listener.clear();
        this.verifyEq(soxComponent.subscription(), 1);
        this.verifySub((Component)this.a, 0);
        this.invoke(this.soxTest, "changeProps", (Value)Int.make((int)this.a.id()));
        this.verifyEq(soxComponent.getBool("z2"), false);
        this.verifyEq(soxComponent.getInt("b1"), 241);
        this.verifyEq(soxComponent.getInt("b2"), 172);
        this.verifyEq(soxComponent.getInt("s1"), 32001);
        this.verifyEq(soxComponent.getInt("s2"), 48880);
        this.verifyEq(soxComponent.getInt("i1"), -19088887);
        this.verifyEq(soxComponent.getInt("i2"), -123456788);
        this.verifyEq(soxComponent.getLong("j1"), 1L);
        this.verifyEq(soxComponent.getLong("j2"), -2999999999L);
        this.verifyEq(soxComponent.getFloat("f1"), 5.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 3.04f);
        this.verifyEq(soxComponent.getDouble("d1"), 1.0);
        this.verifyEq(soxComponent.getDouble("d2"), 257.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{1}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{1}));
        this.client.subscribe(soxComponent, 4);
        this.verifyEq(soxComponent.subscription(), 5);
        this.verifySub((Component)this.a, 4);
        listener.verify(4);
        this.verifyEq(soxComponent.getBool("z2"), true);
        this.verifyEq(soxComponent.getInt("b1"), 241);
        this.verifyEq(soxComponent.getInt("b2"), 173);
        this.verifyEq(soxComponent.getInt("s1"), 32001);
        this.verifyEq(soxComponent.getInt("s2"), 48881);
        this.verifyEq(soxComponent.getInt("i1"), -19088887);
        this.verifyEq(soxComponent.getInt("i2"), -123456787);
        this.verifyEq(soxComponent.getLong("j1"), 1L);
        this.verifyEq(soxComponent.getLong("j2"), -2999999998L);
        this.verifyEq(soxComponent.getFloat("f1"), 5.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 4.04f);
        this.verifyEq(soxComponent.getDouble("d1"), 1.0);
        this.verifyEq(soxComponent.getDouble("d2"), 258.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{1}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{2}));
        this.invoke(this.soxTest, "changeProps", (Value)Int.make((int)this.a.id()));
        this.pause();
        this.verifyEq(soxComponent.getBool("z2"), false);
        this.verifyEq(soxComponent.getInt("b1"), 241);
        this.verifyEq(soxComponent.getInt("b2"), 174);
        this.verifyEq(soxComponent.getInt("s1"), 32001);
        this.verifyEq(soxComponent.getInt("s2"), 48882);
        this.verifyEq(soxComponent.getInt("i1"), -19088887);
        this.verifyEq(soxComponent.getInt("i2"), -123456786);
        this.verifyEq(soxComponent.getLong("j1"), 1L);
        this.verifyEq(soxComponent.getLong("j2"), -2999999997L);
        this.verifyEq(soxComponent.getFloat("f1"), 5.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 5.04f);
        this.verifyEq(soxComponent.getDouble("d1"), 1.0);
        this.verifyEq(soxComponent.getDouble("d2"), 259.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{1}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{3}));
        listener.verify(4);
        this.client.subscribe(soxComponent, 2);
        this.verifyEq(soxComponent.subscription(), 7);
        this.verifySub((Component)this.a, 6);
        listener.verify(2);
        this.verifyEq(soxComponent.getBool("z2"), false);
        this.verifyEq(soxComponent.getInt("b1"), 243);
        this.verifyEq(soxComponent.getInt("b2"), 174);
        this.verifyEq(soxComponent.getInt("s1"), 32003);
        this.verifyEq(soxComponent.getInt("s2"), 48882);
        this.verifyEq(soxComponent.getInt("i1"), -19088885);
        this.verifyEq(soxComponent.getInt("i2"), -123456786);
        this.verifyEq(soxComponent.getLong("j1"), (long)3);
        this.verifyEq(soxComponent.getLong("j2"), -2999999997L);
        this.verifyEq(soxComponent.getFloat("f1"), 7.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 5.04f);
        this.verifyEq(soxComponent.getDouble("d1"), (double)3);
        this.verifyEq(soxComponent.getDouble("d2"), 259.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{3}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{3}));
        this.invoke(this.soxTest, "changeProps", (Value)Int.make((int)this.a.id()));
        this.pause();
        this.verifyEq(soxComponent.getBool("z2"), true);
        this.verifyEq(soxComponent.getInt("b1"), 244);
        this.verifyEq(soxComponent.getInt("b2"), 175);
        this.verifyEq(soxComponent.getInt("s1"), 32004);
        this.verifyEq(soxComponent.getInt("s2"), 48883);
        this.verifyEq(soxComponent.getInt("i1"), -19088884);
        this.verifyEq(soxComponent.getInt("i2"), -123456785);
        this.verifyEq(soxComponent.getLong("j1"), (long)4);
        this.verifyEq(soxComponent.getLong("j2"), -2999999996L);
        this.verifyEq(soxComponent.getFloat("f1"), 8.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 6.04f);
        this.verifyEq(soxComponent.getDouble("d1"), (double)4);
        this.verifyEq(soxComponent.getDouble("d2"), 260.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{4}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{4}));
        listener.verify(6);
        this.client.unsubscribe(soxComponent, 4);
        this.verifyEq(soxComponent.subscription(), 3);
        this.verifySub((Component)this.a, 2);
        this.invoke(this.soxTest, "changeProps", (Value)Int.make((int)this.a.id()));
        this.pause();
        this.verifyEq(soxComponent.getBool("z2"), true);
        this.verifyEq(soxComponent.getInt("b1"), 245);
        this.verifyEq(soxComponent.getInt("b2"), 175);
        this.verifyEq(soxComponent.getInt("s1"), 32005);
        this.verifyEq(soxComponent.getInt("s2"), 48883);
        this.verifyEq(soxComponent.getInt("i1"), -19088883);
        this.verifyEq(soxComponent.getInt("i2"), -123456785);
        this.verifyEq(soxComponent.getLong("j1"), (long)5);
        this.verifyEq(soxComponent.getLong("j2"), -2999999996L);
        this.verifyEq(soxComponent.getFloat("f1"), 9.08f);
        this.verifyEq(soxComponent.getFloat("f2"), 6.04f);
        this.verifyEq(soxComponent.getDouble("d1"), (double)5);
        this.verifyEq(soxComponent.getDouble("d2"), 260.0);
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{5}));
        this.verifyEq(soxComponent.getBuf("bufB"), new Buf(new byte[]{4}));
        listener.verify(2);
        this.client.write(soxComponent.id(), soxComponent.type.slot("bufA", true), (Value)new Buf(new byte[]{19, 72}));
        this.pause();
        this.verifyEq(soxComponent.getBuf("bufA"), new Buf(new byte[]{19, 72}));
        listener.verify(2);
    }

    private final void verifySub(Component component, int n) throws Exception {
        int n2 = component.id() << 24 | this.client.remoteId() << 8 | n;
        this.verifyServer("verifySub", (Value)Int.make((int)n2));
    }

    private final void verifyAdd() throws Exception {
        SoxComponent soxComponent = this.client.load(this.a.id());
        this.verifyEq(soxComponent.children().length, 2);
        this.verifyEq(soxComponent.children()[0].id(), this.aa.id());
        this.verifyEq(soxComponent.children()[1].id(), this.ab.id());
        Value[] valueArray = new Value[]{Int.make((int)515), Bool.TRUE, Byte.make((int)35), Short.make((int)1896), Int.make((int)123454321), Long.make((long)-1229801703532086341L), Float.make((float)601.0f), Double.make((double)4.8), new Buf(new byte[]{-86, -69, -52, -35, -18}), Str.make((String)"hello")};
        Component.testMode = true;
        SoxComponent soxComponent2 = this.client.add(soxComponent, soxComponent.type, "x", valueArray);
        this.xId = soxComponent2.id();
        Component.testMode = false;
        this.verifyEq(soxComponent.children().length, 3);
        this.verifyEq(soxComponent.children()[0].id(), this.aa.id());
        this.verifyEq(soxComponent.children()[1].id(), this.ab.id());
        this.verifyEq(soxComponent.children()[2].id(), soxComponent2.id());
        this.verifyEq(soxComponent2.parentId(), this.a.id());
        boolean bl = false;
        if (soxComponent2.client() == this.client) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (soxComponent2.parent() == soxComponent) {
            bl2 = true;
        }
        this.verify(bl2);
        this.verifyEq(soxComponent2.name(), "x");
        this.verifyEq(soxComponent2.path(), "/a/x");
        this.verifyEq(soxComponent2.getInt("meta"), 515);
        this.verifyEq(soxComponent2.getBool("z1"), true);
        this.verifyEq(soxComponent2.getInt("b1"), 35);
        this.verifyEq(soxComponent2.getInt("s1"), 1896);
        this.verifyEq(soxComponent2.getInt("i1"), 123454321);
        this.verifyEq(soxComponent2.getLong("j1"), -1229801703532086341L);
        this.verifyEq(soxComponent2.getFloat("f1"), 601.0f);
        this.verifyEq(soxComponent2.getDouble("d1"), 4.8);
        this.verifyEq(soxComponent2.getBuf((String)"bufA").size, 5);
        this.verifyEq(soxComponent2.getBuf("bufA").get(0), 170);
        this.verifyEq(soxComponent2.getBuf("bufA").get(1), 187);
        this.verifyEq(soxComponent2.getBuf("bufA").get(2), 204);
        this.verifyEq(soxComponent2.getBuf("bufA").get(3), 221);
        this.verifyEq(soxComponent2.getStr("str"), "hello");
        this.verifyServer("verifyAdd", (Value)Int.make((int)soxComponent2.id()));
    }

    private final void verifyRename() throws Exception {
        SoxComponent soxComponent = this.client.load(this.xId);
        this.verifyEq(soxComponent.name(), "x");
        this.client.rename(soxComponent, "foobar");
        this.verifyEq(soxComponent.name(), "foobar");
        this.verifyServer("verifyRename", (Value)Int.make((int)this.xId));
    }

    private final void verifyReorder() throws Exception {
        SoxComponent soxComponent = this.client.load(this.b.id());
        SoxComponent soxComponent2 = this.client.load(this.r.id());
        SoxComponent soxComponent3 = this.client.load(this.s.id());
        SoxComponent soxComponent4 = this.client.load(this.t.id());
        this.verifyEq(soxComponent.childrenIds().length, 3);
        this.verifyEq(soxComponent.childrenIds()[0], this.r.id());
        this.verifyEq(soxComponent.childrenIds()[1], this.s.id());
        this.verifyEq(soxComponent.childrenIds()[2], this.t.id());
        boolean bl = false;
        if (soxComponent.children()[0] == soxComponent2) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (soxComponent.children()[1] == soxComponent3) {
            bl2 = true;
        }
        this.verify(bl2);
        boolean bl3 = false;
        if (soxComponent.children()[2] == soxComponent4) {
            bl3 = true;
        }
        this.verify(bl3);
        Exception exception = null;
        exception = null;
        try {
            this.client.reorder(soxComponent, new int[]{this.t.id(), this.s.id()});
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        boolean bl4 = false;
        if (exception != null) {
            bl4 = true;
        }
        this.verify(bl4);
        exception = null;
        try {
            this.client.reorder(soxComponent, new int[]{this.t.id(), this.s.id(), this.r.id(), this.r.id()});
        }
        catch (Exception exception3) {
            exception = exception3;
        }
        boolean bl5 = false;
        if (exception != null) {
            bl5 = true;
        }
        this.verify(bl5);
        exception = null;
        try {
            this.client.reorder(soxComponent, new int[]{this.t.id(), this.s.id(), this.s.id()});
        }
        catch (Exception exception4) {
            exception = exception4;
        }
        boolean bl6 = false;
        if (exception != null) {
            bl6 = true;
        }
        this.verify(bl6);
        exception = null;
        try {
            this.client.reorder(soxComponent, new int[]{this.t.id(), 9999, this.r.id()});
        }
        catch (Exception exception5) {
            exception = exception5;
        }
        boolean bl7 = false;
        if (exception != null) {
            bl7 = true;
        }
        this.verify(bl7);
        this.client.reorder(soxComponent, new int[]{this.t.id(), this.s.id(), this.r.id()});
        this.client.update(soxComponent, 15);
        this.verifyServer("verifyReorderCallback", (Value)Int.make((int)this.b.id()));
        this.verifyEq(soxComponent.childrenIds().length, 3);
        this.verifyEq(soxComponent.childrenIds()[0], this.t.id());
        this.verifyEq(soxComponent.childrenIds()[1], this.s.id());
        this.verifyEq(soxComponent.childrenIds()[2], this.r.id());
        boolean bl8 = false;
        if (soxComponent.children()[0] == soxComponent4) {
            bl8 = true;
        }
        this.verify(bl8);
        boolean bl9 = false;
        if (soxComponent.children()[1] == soxComponent3) {
            bl9 = true;
        }
        this.verify(bl9);
        boolean bl10 = false;
        if (soxComponent.children()[2] == soxComponent2) {
            bl10 = true;
        }
        this.verify(bl10);
        this.client.reorder(soxComponent, new int[]{this.t.id(), this.r.id(), this.s.id()});
        this.client.update(soxComponent, 15);
        this.verifyServer("verifyReorderCallback", (Value)Int.make((int)this.b.id()));
        this.verifyEq(soxComponent.childrenIds().length, 3);
        this.verifyEq(soxComponent.childrenIds()[0], this.t.id());
        this.verifyEq(soxComponent.childrenIds()[1], this.r.id());
        this.verifyEq(soxComponent.childrenIds()[2], this.s.id());
        boolean bl11 = false;
        if (soxComponent.children()[0] == soxComponent4) {
            bl11 = true;
        }
        this.verify(bl11);
        boolean bl12 = false;
        if (soxComponent.children()[1] == soxComponent2) {
            bl12 = true;
        }
        this.verify(bl12);
        boolean bl13 = false;
        if (soxComponent.children()[2] == soxComponent3) {
            bl13 = true;
        }
        this.verify(bl13);
    }

    private final void verifyDelete() throws Exception {
        SoxComponent soxComponent = this.client.load(this.a.id());
        SoxComponent soxComponent2 = this.client.load(this.b.id());
        SoxComponent soxComponent3 = this.client.load(this.aa.id());
        SoxComponent soxComponent4 = this.client.load(this.aa1.id());
        SoxComponent soxComponent5 = this.client.load(this.aa2.id());
        this.verifyEq(soxComponent.children().length, 3);
        this.verifyEq(soxComponent.children()[0].id(), this.aa.id());
        this.verifyEq(soxComponent.children()[1].id(), this.ab.id());
        this.verifyEq(soxComponent.children()[2].id(), this.xId);
        this.verifyEq(soxComponent3.children().length, 2);
        this.verifyEq(soxComponent3.children()[0].id(), this.aa1.id());
        this.verifyEq(soxComponent3.children()[1].id(), this.aa2.id());
        this.client.update(soxComponent, 8);
        this.client.update(soxComponent2, 8);
        this.verifyEq(soxComponent.links().length, 1);
        this.verifyEq(soxComponent2.links().length, 2);
        this.verifyLink(soxComponent.links()[0], this.a, "b1", this.aa, "b2");
        this.verifyLink(soxComponent2.links()[0], this.aa2, "b1", this.b, "b2");
        this.verifyLink(soxComponent2.links()[1], this.aa, "i1", this.b, "i2");
        this.client.delete(soxComponent3);
        this.verifyEq(soxComponent.children().length, 2);
        this.verifyEq(soxComponent.children()[0].id(), this.ab.id());
        this.verifyEq(soxComponent.children()[1].id(), this.xId);
        SoxException soxException = null;
        try {
            this.client.load(this.aa.id());
        }
        catch (SoxException soxException2) {
            soxException = soxException2;
        }
        boolean bl = false;
        if (soxException != null) {
            bl = true;
        }
        this.verify(bl);
        soxException = null;
        try {
            this.client.load(this.aa1.id());
        }
        catch (SoxException soxException3) {
            soxException = soxException3;
        }
        boolean bl2 = false;
        if (soxException != null) {
            bl2 = true;
        }
        this.verify(bl2);
        soxException = null;
        try {
            this.client.load(this.aa2.id());
        }
        catch (SoxException soxException4) {
            soxException = soxException4;
        }
        boolean bl3 = false;
        if (soxException != null) {
            bl3 = true;
        }
        this.verify(bl3);
        this.client.update(soxComponent, 8);
        this.client.update(soxComponent2, 8);
        this.verifyEq(soxComponent.links().length, 0);
        this.verifyEq(soxComponent2.links().length, 0);
        this.verifyServer("verifyDelete", (Value)Int.make((int)this.aa.id()));
        this.verifyServer("verifyDelete", (Value)Int.make((int)this.aa1.id()));
        this.verifyServer("verifyDelete", (Value)Int.make((int)this.aa2.id()));
    }

    private final void verifyLinks() throws Exception {
        SoxComponent soxComponent = this.client.load(this.r.id());
        SoxComponent soxComponent2 = this.client.load(this.s.id());
        SoxComponent soxComponent3 = this.client.load(this.t.id());
        Listener listener = new Listener(soxComponent);
        Listener listener2 = new Listener(soxComponent2);
        Listener listener3 = new Listener(soxComponent3);
        this.client.subscribe(new SoxComponent[]{soxComponent, soxComponent2, soxComponent3}, 8);
        listener.verify(8);
        listener2.verify(8);
        listener3.verify(8);
        this.verifyEq(soxComponent.links().length, 1);
        this.verifyLink(soxComponent.links()[0], this.r, "i1", this.s, "i2");
        this.verifyEq(soxComponent2.links().length, 2);
        this.verifyLink(soxComponent2.links()[0], this.r, "i1", this.s, "i2");
        this.verifyLink(soxComponent2.links()[1], this.s, "f1", this.t, "f2");
        this.verifyEq(soxComponent3.links().length, 1);
        this.verifyLink(soxComponent3.links()[0], this.s, "f1", this.t, "f2");
        this.client.link(new Link((Component)soxComponent, soxComponent.slot("s1"), (Component)soxComponent3, soxComponent3.slot("s2")));
        this.pause();
        listener.verify(8);
        listener2.verify(0);
        listener3.verify(8);
        this.verifyEq(soxComponent.links().length, 2);
        this.verifyLink(soxComponent.links()[0], this.r, "s1", this.t, "s2");
        this.verifyLink(soxComponent.links()[1], this.r, "i1", this.s, "i2");
        this.verifyEq(soxComponent2.links().length, 2);
        this.verifyLink(soxComponent2.links()[0], this.r, "i1", this.s, "i2");
        this.verifyLink(soxComponent2.links()[1], this.s, "f1", this.t, "f2");
        this.verifyEq(soxComponent3.links().length, 2);
        this.verifyLink(soxComponent3.links()[0], this.r, "s1", this.t, "s2");
        this.verifyLink(soxComponent3.links()[1], this.s, "f1", this.t, "f2");
        this.client.unlink(new Link((Component)soxComponent, soxComponent.slot("i1"), (Component)soxComponent2, soxComponent2.slot("i2")));
        this.pause();
        listener.verify(8);
        listener2.verify(8);
        listener3.verify(0);
        this.verifyEq(soxComponent.links().length, 1);
        this.verifyLink(soxComponent.links()[0], this.r, "s1", this.t, "s2");
        this.verifyEq(soxComponent2.links().length, 1);
        this.verifyLink(soxComponent2.links()[0], this.s, "f1", this.t, "f2");
        this.verifyEq(soxComponent3.links().length, 2);
        this.verifyLink(soxComponent3.links()[0], this.r, "s1", this.t, "s2");
        this.verifyLink(soxComponent3.links()[1], this.s, "f1", this.t, "f2");
        this.client.unlink(new Link((Component)soxComponent, soxComponent.slot("s1"), (Component)soxComponent3, soxComponent3.slot("s2")));
        this.pause();
        listener.verify(8);
        listener2.verify(0);
        listener3.verify(8);
        this.verifyEq(soxComponent.links().length, 0);
        this.verifyEq(soxComponent2.links().length, 1);
        this.verifyLink(soxComponent2.links()[0], this.s, "f1", this.t, "f2");
        this.verifyEq(soxComponent3.links().length, 1);
        this.verifyLink(soxComponent3.links()[0], this.s, "f1", this.t, "f2");
        this.client.unsubscribe(new SoxComponent[]{soxComponent, soxComponent2, soxComponent3}, 8);
    }

    private final void verifyQuery() throws Exception {
        int[] nArray = this.client.queryService(this.schema.type("sox::SoxService"));
        this.verifyEq(nArray.length, 1);
        this.verifyEq(nArray[0], this.sox.id());
        nArray = this.client.queryService(this.schema.type("sys::UserService"));
        this.verifyEq(nArray.length, 1);
        this.verifyEq(nArray[0], this.users.id());
        nArray = this.client.queryService(this.schema.type("web::WebService"));
        this.verifyEq(nArray.length, 1);
        this.verifyEq(nArray[0], this.web.id());
        nArray = this.client.queryService(this.schema.type("sys::Service"));
        this.verifyEq(nArray.length, 4);
        this.verifyEq(nArray[0], this.users.id());
        this.verifyEq(nArray[1], this.web.id());
        this.verifyEq(nArray[2], this.sox.id());
        this.verifyEq(nArray[3], this.plat.id());
        nArray = this.client.queryService(this.schema.type("sys::User"));
        this.verifyEq(nArray.length, 0);
    }

    private final void verifyFileTransfer() throws Exception {
        int n;
        Serializable serializable;
        this.verifyFileNotFound();
        this.verifyFileTransfer("", null);
        this.verifyFileTransfer("#", null);
        this.verifyFileTransfer("abc", null);
        int n2 = 0;
        while (n2 < 3) {
            serializable = new Properties();
            ((Properties)serializable).put("chunkSize", "10");
            n = 8;
            while (n <= 12) {
                String string = "";
                int n3 = 0;
                while (n3 < n2 * 10 + n) {
                    string = string + (char)(48 + n3);
                    ++n3;
                }
                Properties properties = this.verifyFileTransfer(string, (Properties)serializable);
                this.verify(properties.get("chunkSize").equals("10"));
                ++n;
            }
            ++n2;
        }
        Properties properties = new Properties();
        properties.put("chunkSize", "3");
        properties.put("test.drop", "0");
        this.verifyFileTransfer("0123abcd[.]", properties);
        properties.put("test.drop", "1");
        this.verifyFileTransfer("0123abcd[.]", properties);
        properties.put("test.drop", "2");
        this.verifyFileTransfer("0123abcd[.]", properties);
        properties.put("test.drop", "3");
        this.verifyFileTransfer("0123abcd[.]", properties);
        properties.put("test.drop", "0,1,3");
        this.verifyFileTransfer("0123abcd[.]", properties);
        serializable = new StringBuffer();
        n = 0;
        while (n < 2000) {
            ((StringBuffer)serializable).append((char)(97 + n % 26));
            if (n > 0 && (n + 1) % 26 == 0) {
                ((StringBuffer)serializable).append("\n");
            }
            ++n;
        }
        ((StringBuffer)serializable).append("\n[end]");
        this.verifyFileTransfer(((StringBuffer)serializable).toString(), null);
        properties = new Properties();
        properties.put("chunkSize", "99");
        properties.put("test.drop", "0,4,17,19");
        this.verifyFileTransfer(((StringBuffer)serializable).toString(), properties);
    }

    private final void verifyBinaryTransfer() throws Exception {
        Properties properties = new Properties();
        properties.put("mode", "w");
        this.client.putFile("blob.txt", this.memFile("0123456789"), properties, null);
        Thread.sleep(100L);
        properties.put("mode", "m");
        properties.put("chunkSize", "1");
        this.verifyBinGet("", 0, 10);
        this.verifyBinGet("", 1, 10);
        this.verifyBinGet("9", 1, 9);
        this.verifyBinGet("9", 0, 9);
        this.verifyBinGet("0", 1, 0);
        StringBuffer stringBuffer = new StringBuffer("0123456789");
        int n = 0;
        while (n <= "0123456789".length() / 2 + 1) {
            char c = (char)(97 + n);
            String string = "" + c + c;
            properties.put("offset", Integer.toString(n * 2));
            System.out.println();
            System.out.println("]]]]]]]]]]]]]]]]]>>> TEST BINARY PUT " + properties);
            this.setupBinaryDrops();
            this.client.putFile("blob.txt", this.memFile(string), properties, null);
            Thread.sleep(100L);
            stringBuffer = new StringBuffer().append(stringBuffer.substring(0, n * 2)).append(c).append(c).append((n + 1) * 2 < "0123456789".length() ? stringBuffer.substring((n + 1) * 2) : "");
            this.verifyBinGet(stringBuffer.toString(), 0, 0);
            this.verifyBinGet(string, 2, n * 2);
            this.verifyBinGet(stringBuffer.substring(n), 0, n);
            this.verifyBinGet(stringBuffer.substring(n), stringBuffer.length(), n);
            ++n;
        }
    }

    private final Properties verifyBinGet(String string, int n, int n2) throws Exception {
        Buf buf = new Buf();
        Properties properties = new Properties();
        properties.put("fileSize", Integer.toString(n));
        properties.put("offset", Integer.toString(n2));
        properties.put("chunkSize", "1");
        System.out.println();
        System.out.println("]]]]]]]]]]]]]]]]]>>> TEST BINARY GET " + properties);
        if (binDropCount++ % 3 == 0) {
            this.setupBinaryDrops();
        }
        Properties properties2 = this.tryTransfer(0, this.client, "blob.txt", SoxFile.make((Buf)buf), properties);
        this.verifyEq(string.length(), buf.size);
        String string2 = new String(buf.trim());
        System.out.println("Verify: " + string + " == " + string2);
        this.verifyEq(string, string2);
        ((DaspTest.TestHooks)this.client.session().test).clearDrop();
        return properties2;
    }

    private final void setupBinaryDrops() {
        int[] nArray = new int[12];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 5;
        nArray[5] = 7;
        nArray[6] = 11;
        nArray[7] = 13;
        nArray[8] = 17;
        nArray[9] = 19;
        nArray[10] = 21;
        nArray[11] = 23;
        int[] nArray2 = nArray;
        DaspTest.TestHooks testHooks = (DaspTest.TestHooks)this.client.session().test;
        testHooks.clearDrop();
        int n = 0;
        while (n < nArray2.length) {
            testHooks.addDrop(testHooks.sendSeqNum() + 1 + nArray2[n]);
            ++n;
        }
    }

    private final SoxFile memFile(String string) {
        return SoxFile.make((Buf)new Buf(string.getBytes()));
    }

    private final void verifyFileNotFound() throws Exception {
        SoxException soxException = null;
        try {
            this.client.getFile("boo hoo.txt", SoxFile.make((File)new File(this.testDir(), "x")), null, null);
        }
        catch (SoxException soxException2) {
            System.out.println("  " + (Object)((Object)soxException2));
            soxException = soxException2;
        }
        boolean bl = false;
        if (soxException != null) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (soxException.getMessage().indexOf("not found") > 0) {
            bl2 = true;
        }
        this.verify(bl2);
    }

    private final Properties verifyFileTransfer(String string, Properties properties) throws Exception {
        String string2 = properties == null ? "" : properties.getProperty("test.drop", "");
        DaspTest.TestHooks testHooks = (DaspTest.TestHooks)this.client.session().test;
        if (string2.length() > 0) {
            testHooks.dropType = 5;
        }
        String[] stringArray = TextUtil.split((String)string2, (char)',');
        int n = 0;
        while (n < stringArray.length) {
            int n2 = Integer.parseInt(stringArray[n]);
            testHooks.addDrop(testHooks.sendSeqNum() + 1 + n2);
            ++n;
        }
        File file = new File(this.testDir(), "transfer.txt");
        PrintWriter printWriter = new PrintWriter(this.openFileWriter(file));
        printWriter.print(string);
        printWriter.close();
        System.out.println();
        System.out.println("]]]]]]]]]]]]]]]]]>>> TEST FILE GET " + properties + ' ' + string.length());
        File file2 = new File(this.testDir(), "get.txt");
        Properties properties2 = this.tryTransfer(0, this.client, "transfer.txt", SoxFile.make((File)file2), properties);
        this.verify(file2.exists());
        this.verifyEq(file2.length(), file.length());
        this.verifyEq(string, this.readToStr(file2));
        System.out.println();
        System.out.println("]]]]]]]]]]]]]]]]]>>> TEST FILE PUT " + properties);
        File file3 = new File(this.testDir(), "put.txt");
        properties2 = this.tryTransfer(1, this.client, "put.txt", SoxFile.make((File)file), properties);
        Thread.sleep(100L);
        this.verify(file3.exists());
        this.verifyEq(file3.length(), file.length());
        this.verifyEq(string, this.readToStr(file3));
        return properties2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readToStr(File file) throws IOException {
        String string;
        char[] cArray = new char[(int)file.length()];
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            int n;
            int n2 = 0;
            while ((n = ((Reader)bufferedReader).read()) >= 0) {
                cArray[n2] = (char)n;
                ++n2;
            }
            string = new String(cArray);
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            ((Reader)bufferedReader).close();
            throw throwable;
        }
        ((Reader)bufferedReader).close();
        return string;
    }

    private final void verifyFileRename() throws Exception {
        File file = new File(this.testDir(), "oldname.txt");
        File file2 = new File(this.testDir(), "newname.txt");
        file.delete();
        file2.delete();
        new FileOutputStream(file).close();
        this.verify(file.exists());
        this.verify(file2.exists() ^ true);
        this.client.renameFile("oldname.txt", "newname.txt");
        this.verify(file.exists() ^ true);
        this.verify(file2.exists());
    }

    private final void verifyClose() throws Exception {
        int n = this.client.remoteId();
        this.trace("Close...");
        this.verify(this.client.isClosed() ^ true);
        boolean bl = false;
        if (this.client.remoteId() != -1) {
            bl = true;
        }
        this.verify(bl);
        this.client.close();
        this.verify(this.client.isClosed());
        boolean bl2 = false;
        if (this.client.remoteId() == -1) {
            bl2 = true;
        }
        this.verify(bl2);
        this.client.connect();
        this.verifyServer("verifyClose", (Value)Int.make((int)n));
        this.client.close();
        this.verify(this.client.isClosed());
    }

    public OfflineApp buildApp() throws Exception {
        this.schema = Schema.load((KitPart[])new KitPart[]{KitPart.forLocalKit((String)"sys"), KitPart.forLocalKit((String)"sox"), KitPart.forLocalKit((String)"inet"), KitPart.forLocalKit((String)"web")});
        OfflineComponent offlineComponent = new OfflineComponent(this.schema.type("web::WebService"), "web");
        offlineComponent.setInt("port", 8080);
        this.app = new OfflineApp(this.schema);
        this.service = this.app.add((OfflineComponent)this.app, new OfflineComponent(this.schema.type("sys::Component"), "service"));
        this.plat = this.app.add(this.service, new OfflineComponent(this.schema.type("sys::PlatformService"), "plat"));
        this.sox = this.app.add(this.service, new OfflineComponent(this.schema.type("sox::SoxService"), "sox"));
        this.web = this.app.add(this.service, offlineComponent);
        this.soxTestType = this.schema.type("sox::SoxTest");
        this.soxTest = this.app.add(this.sox, new OfflineComponent(this.soxTestType, "soxtest"));
        this.users = this.app.add(this.service, new OfflineComponent(this.schema.type("sys::UserService"), "users"));
        this.admin = this.app.add(this.users, new OfflineComponent(this.schema.type("sys::User"), "admin"));
        this.admin.setBuf("cred", new Buf(UserUtil.credentials((String)"admin", (String)"pw")));
        this.admin.setInt("perm", -1);
        this.admin.setInt("prov", 255);
        this.a = new OfflineComponent(this.schema.type("sys::TestComp"), "a");
        this.a.setInt("b1", 240);
        this.a.setInt("b2", 50);
        this.a.setInt("s1", 32000);
        this.a.setInt("i1", -19088888);
        this.a.setFloat("f1", 4.08f);
        this.aa = new OfflineComponent(this.schema.type("sys::TestComp"), "aa");
        this.ab = new OfflineComponent(this.schema.type("sys::SubTestComp"), "ab");
        this.ab.setInt("sb", 7);
        this.ab.setInt("si", 1972);
        this.aa1 = new OfflineComponent(this.schema.type("sys::TestComp"), "aa1");
        this.aa2 = new OfflineComponent(this.schema.type("sys::TestComp"), "aa2");
        this.b = new OfflineComponent(this.schema.type("sys::TestComp"), "b");
        this.r = new OfflineComponent(this.schema.type("sys::TestComp"), "r");
        this.s = new OfflineComponent(this.schema.type("sys::TestComp"), "s");
        this.t = new OfflineComponent(this.schema.type("sys::TestComp"), "t");
        this.baz = new OfflineComponent(this.schema.type("sys::BazAction"), "baz");
        this.app.add((OfflineComponent)this.app, this.a);
        this.app.add(this.a, this.aa);
        this.app.add(this.aa, this.aa1);
        this.app.add(this.aa, this.aa2);
        this.app.add(this.a, this.ab);
        this.app.add((OfflineComponent)this.app, this.b);
        this.app.add(this.b, this.r);
        this.app.add(this.b, this.s);
        this.app.add(this.b, this.t);
        this.app.add((OfflineComponent)this.app, this.baz);
        this.app.assignIds();
        Type type = this.a.type;
        this.app.addLink(new OfflineLink(this.a, type.slot("b1"), this.aa, type.slot("b2")));
        this.app.addLink(new OfflineLink(this.aa, type.slot("i1"), this.b, type.slot("i2")));
        this.app.addLink(new OfflineLink(this.aa1, type.slot("i1"), this.aa2, type.slot("i2")));
        this.app.addLink(new OfflineLink(this.aa2, type.slot("b1"), this.b, type.slot("b2")));
        this.app.addLink(new OfflineLink(this.r, type.slot("i1"), this.s, type.slot("i2")));
        this.app.addLink(new OfflineLink(this.s, type.slot("f1"), this.t, type.slot("f2")));
        this.soxTestId = this.soxTest.id();
        boolean bl = false;
        if (this.app.lookup(this.soxTestId) == this.soxTest) {
            bl = true;
        }
        this.verify(bl);
        this.verify(this.app.equivalent(this.app));
        return this.app;
    }

    public void verifyServer(String string) throws Exception {
        this.verifyServer(string, null);
    }

    public void verifyServer(String string, Value value) throws Exception {
        this.trace("verifyServer(" + string + ')');
        int n = this.readInt(this.soxTest, "verifies");
        int n2 = this.readInt(this.soxTest, "failures");
        this.trace("{");
        this.invoke(this.soxTest, string, value);
        this.trace("}");
        int n3 = this.readInt(this.soxTest, "verifies");
        int n4 = this.readInt(this.soxTest, "failures");
        boolean bl = false;
        if (n3 > n) {
            bl = true;
        }
        this.verify(bl);
        boolean bl2 = false;
        if (n4 == n2) {
            bl2 = true;
        }
        this.verify(bl2);
    }

    public void verifyLink(Link link, OfflineComponent offlineComponent, String string, OfflineComponent offlineComponent2, String string2) {
        Slot slot = offlineComponent.type.slot(string, true);
        Slot slot2 = offlineComponent2.type.slot(string2, true);
        this.verifyEq(link.fromCompId, offlineComponent.id());
        this.verifyEq(link.fromSlotId, slot.id);
        this.verifyEq(link.toCompId, offlineComponent2.id());
        this.verifyEq(link.toSlotId, slot2.id);
    }

    private final Properties tryTransfer(int n, SoxClient soxClient, String string, SoxFile soxFile, Properties properties) throws Exception {
        Properties properties2;
        block14: {
            properties2 = null;
            String string2 = n == 0 ? "get" : "put";
            int n2 = 0;
            while (n2 < 9) {
                block13: {
                    try {
                        if (n == 0) {
                            properties2 = soxClient.getFile(string, soxFile, properties, null);
                            break block13;
                        }
                        if (n == 1) {
                            properties2 = soxClient.putFile(string, soxFile, properties, null);
                            break block13;
                        }
                        throw new Exception("Error in test!");
                    }
                    catch (Exception exception) {}
                }
                if (properties2 != null) break;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
                ++n2;
            }
            if (properties2 == null) {
                try {
                    if (n == 0) {
                        properties2 = soxClient.getFile(string, soxFile, properties, null);
                        break block14;
                    }
                    if (n == 1) {
                        properties2 = soxClient.putFile(string, soxFile, properties, null);
                        break block14;
                    }
                    throw new Exception("Error in test!");
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.fail("\nFailed to " + string2 + " file " + string + " after 10 attempts");
                }
            } else {
                System.out.println("\t" + string2 + "file(" + string + ") succeeded after " + n2 + " failures.");
            }
        }
        return properties2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class Listener
    implements SoxComponentListener {
        SoxComponent target;
        SoxComponent comp;
        int mask;

        public void changed(SoxComponent soxComponent, int n) {
            this.comp = soxComponent;
            this.mask |= n;
        }

        void clear() {
            this.comp = null;
            this.mask = 0;
        }

        void verify(int n) {
            if (n == 0) {
                if (this.comp != null) {
                    System.out.println("Listener.verify " + this.comp + " mask=" + Integer.toHexString(this.mask));
                }
                boolean bl = false;
                if (this.comp == null) {
                    bl = true;
                }
                SoxTest.this.verify(bl);
            } else {
                boolean bl = false;
                if (this.comp == this.target) {
                    bl = true;
                }
                SoxTest.this.verify(bl, this.comp + " != " + this.target);
            }
            SoxTest.this.verifyEq(this.mask, n);
            this.clear();
        }

        Listener(SoxComponent soxComponent) {
            this.target = soxComponent;
            soxComponent.listener = this;
        }
    }
}

