/*
 * Decompiled with CFR 0.152.
 */
package sedonac.util;

import java.util.Properties;
import sedona.Env;

public class VarResolver {
    private static final String OS = "os.env.";
    private static final String SEDONA = "sedona.env.";
    protected Properties vars;

    public String resolve(String string) throws Exception {
        return this.resolve(string, new Properties());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolve(String string, Properties properties) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        try {
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return stringBuffer.toString();
                }
                char c = string.charAt(n2);
                if (c != '$') {
                    stringBuffer.append(c);
                } else if ((c = string.charAt(++n2)) == '$') {
                    stringBuffer.append(c);
                } else {
                    String string2;
                    if (c != '{') {
                        throw new Exception("Expected '{' after '" + string.substring(0, n2) + '\'');
                    }
                    StringBuffer stringBuffer2 = new StringBuffer();
                    if ((c = string.charAt(++n2)) == '}') {
                        throw new Exception("Empty patterns not allowed '" + string.substring(0, n2 + 1) + '\'');
                    }
                    while (true) {
                        if (c == '}') {
                            string2 = this.getValue(stringBuffer2.toString(), properties);
                            if (string2 != null) break;
                            throw new Exception("Could not resolve variable: ${" + stringBuffer2.toString() + '}');
                        }
                        stringBuffer2.append(c);
                        c = string.charAt(++n2);
                    }
                    stringBuffer.append(string2);
                }
                ++n2;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new Exception("Unexpected end of pattern: '" + string + '\'');
        }
    }

    protected String getValue(String string, Properties properties) {
        if (string.startsWith(OS)) {
            return System.getenv(string.substring(OS.length()));
        }
        if (string.startsWith(SEDONA)) {
            if (string.equals("sedona.env.version")) {
                return Env.version;
            }
            return Env.getProperty((String)string.substring(SEDONA.length()));
        }
        if (properties.containsKey(string)) {
            return properties.getProperty(string);
        }
        return this.vars.getProperty(string);
    }

    public VarResolver() {
        this(new Properties());
    }

    public VarResolver(Properties properties) {
        this.vars = properties;
    }
}

