/*
 * Decompiled with CFR 0.152.
 */
package sedona.offline;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import sedona.Buf;
import sedona.Component;
import sedona.Kit;
import sedona.Link;
import sedona.Slot;
import sedona.Type;
import sedona.Value;
import sedona.offline.OfflineApp;
import sedona.offline.OfflineLink;
import sedona.xml.XElem;
import sedona.xml.XException;
import sedona.xml.XWriter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class OfflineComponent
extends Component {
    static OfflineComponent[] none = new OfflineComponent[0];
    OfflineApp app;
    int id;
    String name;
    OfflineComponent parent;
    ArrayList kids;
    HashMap kidsByName;

    public OfflineApp app() {
        return this.app;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public void rename(String string) {
        OfflineComponent.assertName(string);
        if (this.parent != null && this.parent.kidsByName != null) {
            this.parent.kidsByName.remove(this.name);
            this.parent.kidsByName.put(string, this);
        }
        this.name = string;
    }

    public Component getParent() {
        return this.parent();
    }

    public Component[] getChildren() {
        return this.children();
    }

    public Component getChild(String string) {
        return this.child(string);
    }

    public OfflineComponent parent() {
        return this.parent;
    }

    public OfflineComponent[] children() {
        if (this.kids == null) {
            return none;
        }
        return this.kids.toArray(new OfflineComponent[this.kids.size()]);
    }

    public OfflineComponent child(String string) {
        if (this.kidsByName == null) {
            return null;
        }
        return (OfflineComponent)this.kidsByName.get(string);
    }

    public Link[] links() {
        if (this.app == null) {
            return new Link[0];
        }
        ArrayList<Link> arrayList = new ArrayList<Link>();
        OfflineLink[] offlineLinkArray = this.app.getLinks();
        int n = 0;
        while (n < offlineLinkArray.length) {
            OfflineLink offlineLink = offlineLinkArray[n];
            if (this == offlineLink.fromComp || this == offlineLink.toComp) {
                arrayList.add(new Link(offlineLink.fromComp, offlineLink.fromSlot, offlineLink.toComp, offlineLink.toSlot));
            }
            ++n;
        }
        return arrayList.toArray(new Link[arrayList.size()]);
    }

    public boolean equivalent(OfflineComponent offlineComponent) {
        OfflineComponent[] offlineComponentArray;
        if (this.getClass() != offlineComponent.getClass()) {
            return false;
        }
        if (!this.type.qname.equals(offlineComponent.type.qname) || this.id != offlineComponent.id || !this.name.equals(offlineComponent.name)) {
            return false;
        }
        Slot[] slotArray = this.type.slots;
        Slot[] slotArray2 = offlineComponent.type.slots;
        if (slotArray.length != slotArray2.length) {
            return false;
        }
        int n = 0;
        while (n < slotArray.length) {
            offlineComponentArray = slotArray[n];
            Slot slot = slotArray2[n];
            if (offlineComponentArray.isProp()) {
                if (!slot.isProp()) {
                    return false;
                }
                if (!this.get((Slot)offlineComponentArray).equals(offlineComponent.get(slot))) {
                    return false;
                }
            }
            ++n;
        }
        OfflineComponent[] offlineComponentArray2 = this.children();
        if (offlineComponentArray2.length != (offlineComponentArray = offlineComponent.children()).length) {
            return false;
        }
        int n2 = 0;
        while (n2 < offlineComponentArray2.length) {
            if (!offlineComponentArray2[n2].equivalent(offlineComponentArray[n2])) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void encodeXml(XWriter xWriter, int n) {
        xWriter.indent(n).w("<!-- ").w(this.path()).w(" -->\n");
        xWriter.indent(n).w("<comp");
        xWriter.attr(" name", this.name).attr(" id", String.valueOf(this.id)).attr(" type", this.type.qname);
        boolean bl = false;
        bl = this.encodeXmlProps(xWriter, n + 2, bl);
        bl = this.encodeXmlChildren(xWriter, n + 2, bl);
        if (!bl) {
            xWriter.w("/>\n");
        } else {
            xWriter.indent(n).w("</comp>\n");
        }
    }

    boolean encodeXmlProps(XWriter xWriter, int n, boolean bl) {
        Slot[] slotArray = this.type.slots;
        int n2 = 0;
        while (n2 < slotArray.length) {
            Value value;
            Slot slot = slotArray[n2];
            if (slot.isProp() && !(value = this.get(slot)).equals(slot.def())) {
                if (!bl) {
                    xWriter.w(">\n");
                    bl = true;
                }
                xWriter.indent(n).w("<prop").attr(" name", slot.name).attr(" val", value.encodeString()).w("/>\n");
            }
            ++n2;
        }
        return bl;
    }

    boolean encodeXmlChildren(XWriter xWriter, int n, boolean bl) {
        OfflineComponent[] offlineComponentArray = this.children();
        if (offlineComponentArray.length == 0) {
            return bl;
        }
        if (!bl) {
            xWriter.w(">\n");
            bl = true;
        }
        int n2 = 0;
        while (n2 < offlineComponentArray.length) {
            offlineComponentArray[n2].encodeXml(xWriter, n);
            ++n2;
        }
        return bl;
    }

    void decodeXmlProps(XElem xElem) {
        int n = 0;
        while (n < xElem.contentSize()) {
            if (xElem.elem(n).name().equals("prop")) {
                this.decodeXmlProp(xElem.elem(n));
            }
            ++n;
        }
    }

    void decodeXmlProp(XElem xElem) {
        String string = xElem.get("name");
        Slot slot = this.type.slot(string);
        if (slot == null) {
            System.out.println("WARNING: Unknown slot " + this.type + '.' + string + " [" + xElem.location() + ']');
            return;
        }
        String string2 = xElem.get("val");
        Value value = this.get(slot);
        try {
            value = value.decodeString(string2);
        }
        catch (Exception exception) {
            throw new XException("Invalid " + value.getClass().getName() + " format: " + string2, xElem);
        }
        try {
            this.set(slot, value);
        }
        catch (Exception exception) {
            throw new XException(exception.getMessage(), xElem);
        }
    }

    void decodeXmlChildren(XElem xElem) {
        int n = 0;
        while (n < xElem.contentSize()) {
            XElem xElem2 = xElem.elem(n);
            if (xElem2.name().equals("comp")) {
                try {
                    this.decodeXmlChild(xElem2);
                }
                catch (XException xException) {
                    throw xException;
                }
                catch (Exception exception) {
                    throw new XException("Cannot decode component: " + exception.toString(), xElem2);
                }
            }
            ++n;
        }
    }

    void decodeXmlChild(XElem xElem) {
        String string = xElem.get("type");
        Type type = this.app.schema.type(string);
        if (type == null) {
            throw new XException("Unknown type in schema: " + string, xElem);
        }
        OfflineComponent offlineComponent = new OfflineComponent(type);
        offlineComponent.id = xElem.geti("id", -1);
        String string2 = xElem.get("name");
        String string3 = OfflineComponent.checkName(string2);
        if (string3 != null) {
            throw new XException("Invalid name \"" + string2 + "\" (" + string3 + ')', xElem);
        }
        offlineComponent.rename(string2);
        this.app.add(this, offlineComponent);
        offlineComponent.decodeXmlProps(xElem);
        offlineComponent.decodeXmlChildren(xElem);
    }

    public void encodeBinary(Buf buf) {
        buf.u2(this.id);
        buf.u1(this.type.kit.id);
        buf.u1(this.type.id);
        this.encodeBinaryMeta(buf);
        this.encodeBinaryProps(buf);
        buf.u1(59);
    }

    void encodeBinaryMeta(Buf buf) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        if (this.parent != null) {
            n = this.parent.id;
            int n4 = this.parent.kids.indexOf(this);
            if (n4 + 1 < this.parent.kids.size()) {
                n3 = ((OfflineComponent)this.parent.kids.get((int)(n4 + 1))).id;
            }
        }
        if (this.kids != null && this.kids.size() > 0) {
            n2 = ((OfflineComponent)this.kids.get((int)0)).id;
        }
        buf.str(this.name);
        buf.u2(n);
        buf.u2(n2);
        buf.u2(n3);
    }

    void encodeBinaryProps(Buf buf) {
        Slot[] slotArray = this.type.slots;
        int n = 0;
        while (n < slotArray.length) {
            Slot slot = slotArray[n];
            if (slot.isProp() && slot.isConfig()) {
                this.get(slot).encodeBinary(buf);
            }
            ++n;
        }
    }

    static Decoded decodeBinary(OfflineApp offlineApp, Buf buf, int n) throws Exception {
        int n2 = buf.u1();
        int n3 = buf.u1();
        Kit kit = offlineApp.schema.kits[n2];
        Type type = kit.types[n3];
        Decoded decoded = new Decoded();
        if (n == 0) {
            decoded.comp = offlineApp;
        } else {
            decoded.comp = new OfflineComponent(type);
            decoded.comp.app = offlineApp;
        }
        decoded.comp.id = n;
        decoded.comp.name = buf.str();
        decoded.parentId = buf.u2();
        decoded.childrenId = buf.u2();
        decoded.nextSiblingId = buf.u2();
        decoded.comp.decodeBinaryProps(buf);
        if (buf.u1() != 59) {
            throw new IOException("Corrupted component " + n + ' ' + decoded.comp.name);
        }
        return decoded;
    }

    void decodeBinaryProps(Buf buf) throws IOException {
        Slot[] slotArray = this.type.slots;
        int n = 0;
        while (n < slotArray.length) {
            Slot slot = slotArray[n];
            if (slot.isProp() && slot.isConfig()) {
                this.set(slot, this.get(slot).decodeBinary(buf));
            }
            ++n;
        }
    }

    private final /* synthetic */ void this() {
        this.id = -1;
    }

    public OfflineComponent(Type type) {
        this(type, null);
    }

    public OfflineComponent(Type type, String string) {
        super(type);
        this.this();
        if (string != null) {
            this.rename(string);
        }
    }

    public OfflineComponent(Type type, String string, int n) {
        super(type);
        this.this();
        this.id = n;
        if (string != null) {
            this.rename(string);
        }
    }

    static class Decoded {
        OfflineComponent comp;
        int parentId;
        int childrenId;
        int nextSiblingId;

        Decoded() {
        }
    }
}

