/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.zip.CRC32;
import sedona.Value;
import sedona.util.Base64;
import sedona.util.TextUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Buf
extends Value
implements Comparable {
    public int size;
    public byte[] bytes;
    public int pos;
    public boolean bigEndian;
    public boolean checkAlignment;

    public int typeId() {
        return 8;
    }

    public int hashCode() {
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.bytes, 0, this.size);
        long l = cRC32.getValue();
        int n = 31 * (int)(l ^ l >>> 32);
        n = 31 * n + this.size;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Buf)) {
            return false;
        }
        Buf buf = (Buf)object;
        if (this.size != buf.size) {
            return false;
        }
        int n = 0;
        while (n < this.size) {
            if (this.bytes[n] != buf.bytes[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public String encodeString() {
        return Base64.encode(this.trim());
    }

    public Value decodeString(String string) {
        return new Buf(Base64.decode(string));
    }

    public void encodeBinary(Buf buf) {
        buf.u2(this.size);
        buf.write(this.bytes, 0, this.size);
    }

    public Value decodeBinary(Buf buf) throws IOException {
        int n = buf.u2();
        byte[] byArray = new byte[n];
        if (buf.read(byArray) != n) {
            throw new IOException("unexpected end of file " + n);
        }
        return new Buf(byArray);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("0x[");
        int n = 0;
        while (n < this.size) {
            stringBuffer.append(TextUtil.byteToHexString(this.bytes[n] & 0xFF));
            ++n;
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static Buf fromString(String string) {
        if (!string.startsWith("0x[") || !string.endsWith("]")) {
            throw new IllegalArgumentException("Not a Buf literal: " + string);
        }
        Buf buf = new Buf();
        int n = 3;
        while (n < string.length() - 1) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\t' && c != '\r' && c != '\n') {
                int n2 = TextUtil.hexCharToInt(c);
                int n3 = TextUtil.hexCharToInt(string.charAt(++n));
                buf.write(n2 << 4 | n3);
            }
            ++n;
        }
        buf.seek(0);
        return buf;
    }

    public int size() {
        return this.size;
    }

    public int pos() {
        return this.pos;
    }

    public void clear() {
        this.pos = 0;
        this.size = 0;
        this.bytes = new byte[this.bytes.length / 2];
    }

    public void seek(int n) {
        this.pos = n;
    }

    public void truncate(int n) {
        if (n >= this.size) {
            return;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.bytes, 0, byArray, 0, n);
        this.bytes = byArray;
        this.size = n;
    }

    public int get(int n) {
        if (n >= this.size) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this.bytes[n] & 0xFF;
    }

    public void flip() {
        this.pos = 0;
    }

    public byte[] bytes() {
        return this.bytes;
    }

    public byte[] trim() {
        byte[] byArray = new byte[this.size];
        System.arraycopy(this.bytes, 0, byArray, 0, this.size);
        return byArray;
    }

    public void write(int n) {
        this.u1(n);
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(byte[] byArray, int n, int n2) {
        this.grow(this.pos, n2);
        System.arraycopy(byArray, n, this.bytes, this.pos, n2);
        this.pos += n2;
    }

    public void append(Buf buf) {
        this.pos = this.size;
        this.grow(this.size, buf.size);
        System.arraycopy(buf.bytes, 0, this.bytes, this.pos, buf.size);
        this.pos += buf.size;
    }

    public void align(int n) {
        int n2 = this.size % n;
        if (n2 == 0) {
            return;
        }
        this.pad(n - n2);
    }

    public void pad(int n) {
        this.pos = this.size;
        this.grow(this.size, n);
        int n2 = 0;
        while (n2 < n) {
            this.bytes[this.pos++] = 0;
            ++n2;
        }
    }

    private final void grow(int n, int n2) {
        int n3 = n + n2;
        if (this.bytes.length < n3) {
            byte[] byArray = new byte[Math.max(n3, this.bytes.length * 2)];
            System.arraycopy(this.bytes, 0, byArray, 0, this.bytes.length);
            this.bytes = byArray;
        }
        if (this.size < n3) {
            this.size = n3;
        }
    }

    public void bool(boolean bl) {
        this.u1(bl ? 1 : 0);
    }

    public void u1(int n) {
        this.grow(this.pos, 1);
        this.bytes[this.pos++] = (byte)n;
    }

    public void u1(int n, int n2) {
        this.grow(n, 1);
        this.bytes[n] = (byte)n2;
    }

    public void s1(int n) {
        this.u1(n);
    }

    public void s1(int n, int n2) {
        this.u1(n, n2);
    }

    public void u2(int n) {
        this.u2(n, this.checkAlignment);
    }

    public void u2(int n, boolean bl) {
        this.u2(this.pos, n, bl);
        this.pos += 2;
    }

    public void u2(int n, int n2) {
        this.u2(n, n2, this.checkAlignment);
    }

    public void u2(int n, int n2, boolean bl) {
        if (bl && n % 2 != 0) {
            throw new RuntimeException("u2 not aligned (" + n + ')');
        }
        this.grow(n, 2);
        if (this.bigEndian) {
            this.bytes[n] = (byte)(n2 >>> 8);
            this.bytes[n + 1] = (byte)n2;
        } else {
            this.bytes[n] = (byte)n2;
            this.bytes[n + 1] = (byte)(n2 >>> 8);
        }
    }

    public void s2(int n) {
        this.u2(n);
    }

    public void s2(int n, int n2) {
        this.u2(n, n2);
    }

    public void i4(int n) {
        this.i4(this.pos, n);
        this.pos += 4;
    }

    public void i4(int n, int n2) {
        if (this.checkAlignment && n % 4 != 0) {
            throw new RuntimeException("i4 not aligned (" + n + ')');
        }
        this.grow(n, 4);
        if (this.bigEndian) {
            this.bytes[n] = (byte)(n2 >>> 24);
            this.bytes[n + 1] = (byte)(n2 >>> 16);
            this.bytes[n + 2] = (byte)(n2 >>> 8);
            this.bytes[n + 3] = (byte)n2;
        } else {
            this.bytes[n] = (byte)n2;
            this.bytes[n + 1] = (byte)(n2 >>> 8);
            this.bytes[n + 2] = (byte)(n2 >>> 16);
            this.bytes[n + 3] = (byte)(n2 >>> 24);
        }
    }

    public void i8(long l) {
        this.i8(this.pos, l);
        this.pos += 8;
    }

    public void i8(int n, long l) {
        if (this.checkAlignment && this.size % 8 != 0) {
            throw new RuntimeException("i8 not aligned (" + n + ')');
        }
        this.grow(n, 8);
        if (this.bigEndian) {
            this.bytes[n] = (byte)(l >>> 56);
            this.bytes[n + 1] = (byte)(l >>> 48);
            this.bytes[n + 2] = (byte)(l >>> 40);
            this.bytes[n + 3] = (byte)(l >>> 32);
            this.bytes[n + 4] = (byte)(l >>> 24);
            this.bytes[n + 5] = (byte)(l >>> 16);
            this.bytes[n + 6] = (byte)(l >>> 8);
            this.bytes[n + 7] = (byte)l;
        } else {
            this.bytes[n] = (byte)l;
            this.bytes[n + 1] = (byte)(l >>> 8);
            this.bytes[n + 2] = (byte)(l >>> 16);
            this.bytes[n + 3] = (byte)(l >>> 24);
            this.bytes[n + 4] = (byte)(l >>> 32);
            this.bytes[n + 5] = (byte)(l >>> 40);
            this.bytes[n + 6] = (byte)(l >>> 48);
            this.bytes[n + 7] = (byte)(l >>> 56);
        }
    }

    public void f4(float f) {
        this.i4(this.pos, Float.floatToIntBits(f));
        this.pos += 4;
    }

    public void f4(int n, float f) {
        this.i4(n, Float.floatToIntBits(f));
    }

    public void f8(double d) {
        this.f8(this.pos, d);
        this.pos += 8;
    }

    public void f8(int n, double d) {
        this.i8(n, Double.doubleToLongBits(d));
    }

    public void str(String string) {
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c > '\u007f') {
                throw new IllegalStateException("Not ASCII string: " + string);
            }
            this.u1(c);
            ++n;
        }
        this.u1(0);
    }

    public int available() {
        return this.size - this.pos;
    }

    public int peek() throws IOException {
        if (this.pos >= this.size) {
            throw new EOFException();
        }
        return this.bytes[this.pos] & 0xFF;
    }

    public int read() throws IOException {
        if (this.pos >= this.size) {
            return -1;
        }
        return this.bytes[this.pos++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if (this.pos >= this.size) {
            return -1;
        }
        int n3 = Math.min(n2, this.available());
        System.arraycopy(this.bytes, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public int skipBytes(int n) {
        this.pos += n;
        return n;
    }

    public boolean bool() throws IOException {
        boolean bl = false;
        if (this.u1() != 0) {
            bl = true;
        }
        return bl;
    }

    public int u1() throws IOException {
        if (this.pos >= this.size) {
            throw new EOFException();
        }
        return this.bytes[this.pos++] & 0xFF;
    }

    public int s1() throws IOException {
        return (byte)this.u1();
    }

    public int u2() throws IOException {
        if (this.bigEndian) {
            return (this.u1() << 8) + this.u1();
        }
        return this.u1() + (this.u1() << 8);
    }

    public int s2() throws IOException {
        if (this.bigEndian) {
            return (short)((this.u1() << 8) + this.u1());
        }
        return (short)(this.u1() + (this.u1() << 8));
    }

    public int i4() throws IOException {
        if (this.bigEndian) {
            return (this.u1() << 24) + (this.u1() << 16) + (this.u1() << 8) + this.u1();
        }
        return this.u1() + (this.u1() << 8) + (this.u1() << 16) + (this.u1() << 24);
    }

    public long i8() throws IOException {
        if (this.bigEndian) {
            return ((long)this.i4() << 32) + ((long)this.i4() & 0xFFFFFFFFL);
        }
        return ((long)this.i4() & 0xFFFFFFFFL) + ((long)this.i4() << 32);
    }

    public float f4() throws IOException {
        return Float.intBitsToFloat(this.i4());
    }

    public double f8() throws IOException {
        return Double.longBitsToDouble(this.i8());
    }

    public String str() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.u1()) != 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public InputStream getInputStream() {
        return new InputStream(){

            public final int available() throws IOException {
                return Buf.this.available();
            }

            public final int read() throws IOException {
                return Buf.this.read();
            }

            public final int read(byte[] byArray, int n, int n2) throws IOException {
                return Buf.this.read(byArray, n, n2);
            }
        };
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            public final void write(int n) {
                Buf.this.write(n);
            }

            public final void write(byte[] byArray, int n, int n2) {
                Buf.this.write(byArray, n, n2);
            }
        };
    }

    public int readFrom(InputStream inputStream, int n) throws IOException {
        this.grow(this.pos, n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(this.bytes, this.pos, n - n2);
            if (n3 < 0) break;
            this.pos += n3;
            n2 += n3;
        }
        return n2;
    }

    public void readFullyFrom(InputStream inputStream, int n) throws IOException {
        if (n < 0) {
            this.readToEnd(inputStream);
            return;
        }
        this.grow(this.pos, n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(this.bytes, this.pos, n - n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            this.pos += n3;
            n2 += n3;
        }
    }

    public void readToEnd(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray, 0, 1024)) >= 0) {
            this.write(byArray, 0, n);
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.bytes, 0, this.size);
    }

    public void writeTo(OutputStream outputStream, int n, int n2) throws IOException {
        if (n2 > this.size) {
            throw new IOException("len > internal buffer");
        }
        outputStream.write(this.bytes, n, n2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Buf readFrom(File file) throws IOException {
        int n = (int)file.length();
        Buf buf = new Buf(n);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            buf.readFullyFrom(bufferedInputStream, n);
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((InputStream)bufferedInputStream).close();
            throw throwable;
        }
        {
            Object var5_6 = null;
        }
        ((InputStream)bufferedInputStream).close();
        buf.seek(0);
        return buf;
    }

    public void readFrom(RandomAccessFile randomAccessFile, int n) throws IOException {
        this.grow(this.pos, n);
        randomAccessFile.readFully(this.bytes, this.pos, n);
        this.pos += n;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            this.writeTo(bufferedOutputStream);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            ((OutputStream)bufferedOutputStream).close();
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        ((OutputStream)bufferedOutputStream).close();
    }

    public void writeTo(RandomAccessFile randomAccessFile, int n) throws IOException {
        if (this.pos + n > this.size) {
            throw new IOException("Unexpected end of buf. pos=" + this.pos + " size=" + this.size + " n=" + n);
        }
        randomAccessFile.write(this.bytes, this.pos, n);
        this.pos += n;
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        Buf.hexDump(printWriter, this.bytes, 0, this.size);
        printWriter.flush();
    }

    public String dumpToString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Buf.hexDump(printWriter, this.bytes, 0, this.size);
        printWriter.flush();
        return stringWriter.toString();
    }

    public static void hexDump(PrintWriter printWriter, byte[] byArray, int n, int n2) {
        int n3 = 0;
        byte[] byArray2 = new byte[16];
        int n4 = 0;
        while (n4 < n2) {
            n3 = Math.min(16, n2 - n4);
            System.arraycopy(byArray, n + n4, byArray2, 0, n3);
            String string = Integer.toHexString(n4 + n);
            printWriter.print(TextUtil.padLeft(string, 3));
            printWriter.print(':');
            int n5 = 0;
            while (n5 < 16) {
                if (n5 % 4 == 0) {
                    printWriter.print(' ');
                }
                if (n5 >= n3) {
                    printWriter.print("  ");
                } else {
                    printWriter.print(TextUtil.byteToHexString(byArray2[n5] & 0xFF));
                }
                ++n5;
            }
            printWriter.print("  ");
            n5 = 0;
            while (n5 < n3) {
                printWriter.print(TextUtil.byteToChar(byArray2[n5] & 0xFF, '.'));
                ++n5;
            }
            printWriter.println();
            n4 += n3;
        }
    }

    private final /* synthetic */ void this() {
        this.bigEndian = true;
        this.checkAlignment = false;
    }

    public Buf(byte[] byArray, int n) {
        this.this();
        this.pos = 0;
        this.size = n;
        this.bytes = byArray;
    }

    public Buf(byte[] byArray) {
        this.this();
        this.pos = 0;
        this.size = byArray.length;
        this.bytes = byArray;
    }

    public Buf(int n) {
        this.this();
        this.bytes = new byte[n];
    }

    public Buf() {
        this(256);
    }
}

