/*
 * Decompiled with CFR 0.152.
 */
package sedona;

import java.util.ArrayList;
import java.util.HashMap;
import sedona.Constants;
import sedona.Facets;
import sedona.Kit;
import sedona.Schema;
import sedona.Slot;
import sedona.Value;
import sedona.manifest.TypeManifest;

public class Type
implements Comparable,
Constants {
    public static final int ABSTRACT = 1;
    public static final int CONST = 2;
    public static final int FINAL = 4;
    public static final int INTERNAL = 8;
    public static final int PUBLIC = 16;
    public final Schema schema;
    public final Kit kit;
    public final TypeManifest manifest;
    public final int id;
    public final String name;
    public final String qname;
    public final Facets facets;
    public Type base;
    public Slot[] slots;
    HashMap slotsByName;

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    public boolean equals(Object object) {
        if (object instanceof Type) {
            return ((Type)object).toString().equals(this.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.qname;
    }

    public boolean is(Type type) {
        Type type2 = this;
        while (type2 != null) {
            if (type2 == type) {
                return true;
            }
            type2 = type2.base;
        }
        return false;
    }

    public boolean isaComponent() {
        return this.is(this.schema.type("sys::Component"));
    }

    public boolean isAbstract() {
        boolean bl = false;
        if ((this.manifest.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isPublic() {
        boolean bl = false;
        if ((this.manifest.flags & 0x10) != 0) {
            bl = true;
        }
        return bl;
    }

    public boolean isPrimitive() {
        return Type.isPrimitive(this.id);
    }

    public boolean isInteger() {
        boolean bl = false;
        if (this.id == 2 || this.id == 3 || this.id == 4) {
            bl = true;
        }
        return bl;
    }

    public boolean is(Value value) {
        if (this.kit.id != 0) {
            return false;
        }
        if (value == null) {
            boolean bl = false;
            if (this.id == 0) {
                bl = true;
            }
            return bl;
        }
        boolean bl = false;
        if (value.typeId() == this.id) {
            bl = true;
        }
        return bl;
    }

    public Slot slot(int n) {
        if (n >= 0 && n < this.slots.length) {
            return this.slots[n];
        }
        return null;
    }

    public Slot slot(String string) {
        return (Slot)this.slotsByName.get(string);
    }

    public Slot slot(String string, boolean bl) {
        Slot slot = (Slot)this.slotsByName.get(string);
        if (slot != null) {
            return slot;
        }
        if (bl) {
            throw new RuntimeException("Unknown slot " + this.qname + '.' + string);
        }
        return null;
    }

    public Slot[] props() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>(this.slots.length);
        int n = 0;
        while (n < this.slots.length) {
            if (this.slots[n].isProp()) {
                arrayList.add(this.slots[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Slot[arrayList.size()]);
    }

    public Slot[] configProps() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>(this.slots.length);
        int n = 0;
        while (n < this.slots.length) {
            if (this.slots[n].isConfig()) {
                arrayList.add(this.slots[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Slot[arrayList.size()]);
    }

    public Slot[] runtimeProps() {
        ArrayList<Slot> arrayList = new ArrayList<Slot>(this.slots.length);
        int n = 0;
        while (n < this.slots.length) {
            if (this.slots[n].isRuntime()) {
                arrayList.add(this.slots[n]);
            }
            ++n;
        }
        return arrayList.toArray(new Slot[arrayList.size()]);
    }

    public Value facet(String string) {
        return this.facet(string, false);
    }

    public Value facet(String string, boolean bl) {
        Value value = this.facets.get(string, null);
        if (value != null) {
            return value;
        }
        if (bl && this.base != null) {
            return this.base.facet(string, true);
        }
        return null;
    }

    void resolveBase() throws Exception {
        if (this.manifest.base != null) {
            this.base = this.schema.type(this.manifest.base);
            if (this.base == null) {
                throw new Exception("Missing base '" + this.manifest.base + "' for '" + this.qname + '\'');
            }
        }
    }

    void resolveSlots() throws Exception {
        Slot[] slotArray;
        if (this.slots != null) {
            return;
        }
        if (this.base != null) {
            this.base.resolveSlots();
            slotArray = this.base.slots;
        } else {
            slotArray = new Slot[]{};
        }
        ArrayList arrayList = new ArrayList();
        this.slotsByName = new HashMap(slotArray.length * 2);
        int n = 0;
        while (n < slotArray.length) {
            this.addSlot(arrayList, slotArray[n]);
            ++n;
        }
        n = 0;
        while (n < this.manifest.slots.length) {
            int n2 = arrayList.size();
            this.addSlot(arrayList, new Slot(this, n2, this.manifest.slots[n]));
            ++n;
        }
        this.slots = arrayList.toArray(new Slot[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void addSlot(ArrayList arrayList, Slot slot) throws Exception {
        if (slot.id < arrayList.size()) {
            throw new IllegalStateException();
        }
        Slot slot2 = (Slot)this.slotsByName.get(slot.name);
        if (slot2 != null) {
            if (!slot2.isAction() || !slot.isAction()) throw new Exception("Duplicate slot name '" + slot.name + "' in '" + this.qname + '\'');
            slot = new Slot(this, slot2.id, slot.manifest);
            arrayList.set(slot2.id, slot);
        } else {
            arrayList.add(slot);
        }
        this.slotsByName.put(slot.name, slot);
    }

    public static boolean isPrimitive(int n) {
        boolean bl = false;
        if (n <= 7) {
            bl = true;
        }
        return bl;
    }

    public static int predefinedId(String string) {
        if (string.equals("void")) {
            return 0;
        }
        if (string.equals("bool")) {
            return 1;
        }
        if (string.equals("byte")) {
            return 2;
        }
        if (string.equals("short")) {
            return 3;
        }
        if (string.equals("int")) {
            return 4;
        }
        if (string.equals("long")) {
            return 5;
        }
        if (string.equals("float")) {
            return 6;
        }
        if (string.equals("double")) {
            return 7;
        }
        if (string.equals("sys::Buf")) {
            return 8;
        }
        if (string.equals("str")) {
            return 101;
        }
        throw new IllegalStateException("Unknown primitive type: " + string);
    }

    public static String predefinedName(int n) {
        switch (n) {
            case 0: {
                return "void";
            }
            case 1: {
                return "bool";
            }
            case 2: {
                return "byte";
            }
            case 3: {
                return "short";
            }
            case 4: {
                return "int";
            }
            case 5: {
                return "long";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 8: {
                return "sys::Buf";
            }
            case 101: {
                return "str";
            }
        }
        throw new IllegalStateException("Unknown primitive type id: " + n);
    }

    Type(Kit kit, TypeManifest typeManifest) throws Exception {
        this.schema = kit.schema;
        this.kit = kit;
        this.manifest = typeManifest;
        this.id = typeManifest.id;
        this.name = typeManifest.name;
        this.qname = typeManifest.qname;
        this.facets = typeManifest.facets;
    }
}

